/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.expressions;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.internal.ui.actions.AbstractRemoveActionDelegate;
import org.eclipse.debug.internal.ui.viewers.TreePath;
import org.eclipse.debug.internal.ui.viewers.TreeSelection;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.progress.WorkbenchJob;

public class RemoveExpressionAction
extends AbstractRemoveActionDelegate {
    protected IExpression[] getExpressions() {
        TreeSelection selection = (TreeSelection)this.getSelection();
        TreePath[] paths = selection.getPaths();
        ArrayList<Object> expressions = new ArrayList<Object>();
        int i = paths.length - 1;
        while (i >= 0) {
            TreePath path = paths[i];
            Object segment = path.getSegment(1);
            if (segment instanceof IExpression) {
                expressions.add(segment);
            }
            --i;
        }
        return expressions.toArray(new IExpression[expressions.size()]);
    }

    public void run(IAction action) {
        WorkbenchJob job = new WorkbenchJob("remove expression"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IExpressionManager expManager = DebugPlugin.getDefault().getExpressionManager();
                IExpression[] exp = RemoveExpressionAction.this.getExpressions();
                if (exp != null) {
                    expManager.removeExpressions(exp);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        this.schedule((Job)job);
    }
}

