/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.model.viewers;

import java.util.ArrayList;
import org.eclipse.debug.internal.ui.model.viewers.AsynchronousModel;
import org.eclipse.debug.internal.ui.model.viewers.AsynchronousTreeModelViewer;
import org.eclipse.debug.internal.ui.model.viewers.ContainerModelRequestMonitor;
import org.eclipse.debug.internal.ui.model.viewers.ModelAddRequestMonitor;
import org.eclipse.debug.internal.ui.model.viewers.ModelNode;
import org.eclipse.debug.internal.ui.model.viewers.ModelRemoveRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.TreePath;
import org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousContentAdapter;

public class AsynchronousTreeModel
extends AsynchronousModel {
    public AsynchronousTreeModel(AsynchronousTreeModelViewer viewer) {
        super(viewer);
    }

    public synchronized void add(TreePath treePath) {
        if (treePath.getSegmentCount() > 1) {
            int i;
            int parentIndex = treePath.getSegmentCount() - 2;
            Object parent = treePath.getSegment(parentIndex);
            ModelNode[] nodes = this.getNodes(parent);
            if (nodes != null) {
                i = 0;
                while (i < nodes.length) {
                    ModelNode node = nodes[i];
                    if (treePath.startsWith(node.getTreePath())) {
                        ModelAddRequestMonitor addRequest = new ModelAddRequestMonitor(node, treePath, this);
                        this.requestScheduled(addRequest);
                        addRequest.done();
                        return;
                    }
                    ++i;
                }
            }
            i = parentIndex - 1;
            while (i >= 0) {
                parent = treePath.getSegment(i);
                nodes = this.getNodes(parent);
                if (nodes != null) {
                    int j = 0;
                    while (j < nodes.length) {
                        final ModelNode node = nodes[j];
                        if (treePath.startsWith(node.getTreePath())) {
                            Runnable runnable = new Runnable(){

                                public void run() {
                                    AsynchronousTreeModel.this.getViewer().nodeChanged(node);
                                }
                            };
                            this.getViewer().getControl().getDisplay().asyncExec(runnable);
                            return;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    public synchronized void remove(TreePath treePath) {
        if (treePath.getSegmentCount() > 1) {
            ModelNode node;
            int i;
            Object element = treePath.getLastSegment();
            ModelNode[] nodes = this.getNodes(element);
            if (nodes != null) {
                i = 0;
                while (i < nodes.length) {
                    node = nodes[i];
                    if (node.correspondsTo(treePath)) {
                        ModelRemoveRequestMonitor request = new ModelRemoveRequestMonitor(node, treePath, this);
                        this.requestScheduled(request);
                        request.done();
                        return;
                    }
                    ++i;
                }
            }
            if ((nodes = this.getNodes(element = treePath.getSegment(treePath.getSegmentCount() - 2))) != null) {
                i = 0;
                while (i < nodes.length) {
                    node = nodes[i];
                    if (treePath.startsWith(node.getTreePath())) {
                        Runnable runnable = new Runnable(){

                            public void run() {
                                AsynchronousTreeModel.this.getViewer().nodeChanged(node);
                            }
                        };
                        this.getViewer().getControl().getDisplay().asyncExec(runnable);
                        return;
                    }
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(final ModelNode node) {
        final ModelNode parentNode = node.getParentNode();
        if (parentNode == null) {
            return;
        }
        AsynchronousTreeModel asynchronousTreeModel = this;
        synchronized (asynchronousTreeModel) {
            parentNode.removeChild(node);
            this.unmapNode(node);
            node.dispose();
        }
        final AsynchronousTreeModelViewer viewer = this.getTreeViewer();
        this.preservingSelection(new Runnable(){

            public void run() {
                viewer.nodeDisposed(node);
                viewer.nodeChildrenChanged(parentNode);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(ModelNode parent, Object element) {
        Object[] children = this.filter(parent.getElement(), new Object[]{element});
        if (children.length == 0) {
            return;
        }
        AsynchronousTreeModel asynchronousTreeModel = this;
        synchronized (asynchronousTreeModel) {
            ModelNode node = new ModelNode(parent, element);
            parent.addChild(node);
            this.mapElement(element, node);
        }
        this.getTreeViewer().nodeChildrenChanged(parent);
    }

    public synchronized TreePath[] getTreePaths(Object element) {
        ModelNode[] nodes = this.getNodes(element);
        if (nodes == null) {
            return null;
        }
        TreePath[] paths = new TreePath[nodes.length];
        int i = 0;
        while (i < nodes.length) {
            ModelNode node = nodes[i];
            ArrayList<Object> path = new ArrayList<Object>();
            path.add(element);
            node = node.getParentNode();
            while (node != null) {
                Object data = node.getElement();
                path.add(0, data);
                node = node.getParentNode();
            }
            paths[i] = new TreePath(path.toArray());
            ++i;
        }
        return paths;
    }

    protected AsynchronousTreeModelViewer getTreeViewer() {
        return (AsynchronousTreeModelViewer)this.getViewer();
    }

    protected void updateHasChildren(ModelNode node) {
        Object element = node.getElement();
        IAsynchronousContentAdapter adapter = this.getContentAdapter(element);
        if (adapter != null) {
            ContainerModelRequestMonitor update = new ContainerModelRequestMonitor(node, this);
            this.requestScheduled(update);
            adapter.isContainer(element, this.getPresentationContext(), update);
        }
    }

    protected synchronized void unmapNode(ModelNode node) {
        ModelNode[] childrenNodes = node.getChildrenNodes();
        if (childrenNodes != null) {
            int i = 0;
            while (i < childrenNodes.length) {
                this.unmapNode(childrenNodes[i]);
                ++i;
            }
        }
        super.unmapNode(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIsContainer(ModelNode node, boolean containsChildren) {
        ModelNode[] prevChildren = node.getChildrenNodes();
        node.setIsContainer(containsChildren);
        AsynchronousTreeModelViewer viewer = this.getTreeViewer();
        if (containsChildren) {
            if (prevChildren == null) {
                viewer.nodeChildrenChanged(node);
                viewer.nodeContainerChanged(node);
            } else {
                viewer.nodeContainerChanged(node);
            }
        } else if (!containsChildren && prevChildren != null) {
            AsynchronousTreeModel asynchronousTreeModel = this;
            synchronized (asynchronousTreeModel) {
                int i = 0;
                while (i < prevChildren.length) {
                    ModelNode child = prevChildren[i];
                    this.unmapNode(child);
                    child.dispose();
                    ++i;
                }
                node.setChildren(null);
            }
            int i = 0;
            while (i < prevChildren.length) {
                ModelNode child = prevChildren[i];
                viewer.nodeDisposed(child);
                ++i;
            }
            viewer.nodeChildrenChanged(node);
        }
    }
}

