/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.model.viewers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.model.viewers.AsynchronousModel;
import org.eclipse.debug.internal.ui.model.viewers.AsynchronousModelViewer;
import org.eclipse.debug.internal.ui.model.viewers.AsynchronousTreeModel;
import org.eclipse.debug.internal.ui.model.viewers.IModelUpdatePolicy;
import org.eclipse.debug.internal.ui.model.viewers.ModelNode;
import org.eclipse.debug.internal.ui.model.viewers.TreeUpdatePolicy;
import org.eclipse.debug.internal.ui.viewers.TreePath;
import org.eclipse.debug.internal.ui.viewers.TreeSelection;
import org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousContentAdapter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.progress.WorkbenchJob;

public class AsynchronousTreeModelViewer
extends AsynchronousModelViewer
implements Listener {
    private static final Rectangle NOT_VISIBLE = new Rectangle(0, 0, 0, 0);
    private Tree fTree;
    private List fPendingExpansion = new ArrayList();
    private Map fParentsPendingChildren = new HashMap();
    static /* synthetic */ Class class$0;

    public AsynchronousTreeModelViewer(Composite parent) {
        this(parent, 268436226);
    }

    public AsynchronousTreeModelViewer(Composite parent, int style) {
        this(new Tree(parent, style));
    }

    public AsynchronousTreeModelViewer(Tree tree) {
        Assert.isTrue(((tree.getStyle() & 0x10000000) != 0 ? 1 : 0) != 0);
        this.fTree = tree;
        this.hookControl((Control)this.fTree);
        this.setUseHashlookup(false);
        tree.addTreeListener(new TreeListener(){

            public void treeExpanded(TreeEvent e) {
                ((TreeItem)e.item).setExpanded(true);
                AsynchronousTreeModelViewer.this.internalRefresh(e.item.getData(), e.item);
            }

            public void treeCollapsed(TreeEvent e) {
            }
        });
        tree.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                TreeItem item = ((Tree)e.widget).getItem(new Point(e.x, e.y));
                if (item != null) {
                    if (item.getExpanded()) {
                        item.setExpanded(false);
                    } else {
                        item.setExpanded(true);
                        AsynchronousTreeModelViewer.this.internalRefresh(item.getData(), (Widget)item);
                    }
                }
            }
        });
        tree.addListener(36, (Listener)this);
    }

    public Tree getTree() {
        return this.fTree;
    }

    protected void updateHasChildren(Object element, Widget widget) {
        ModelNode node = this.getModel().getNode(widget);
        if (node != null) {
            ((AsynchronousTreeModel)this.getModel()).updateHasChildren(node);
        }
    }

    protected void updateChildren(Object parent, Widget widget) {
        ModelNode node = this.getModel().getNode(widget);
        if (node != null) {
            ((AsynchronousTreeModel)this.getModel()).updateChildren(node);
        }
    }

    protected IAsynchronousContentAdapter getContentAdapter(Object element) {
        IAsynchronousContentAdapter adapter = null;
        if (element instanceof IAsynchronousContentAdapter) {
            adapter = (IAsynchronousContentAdapter)element;
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousContentAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            adapter = (IAsynchronousContentAdapter)adaptable.getAdapter((Class)clazz);
        }
        return adapter;
    }

    public synchronized void expand(ISelection selection) {
        if (selection instanceof TreeSelection) {
            TreePath[] paths = ((TreeSelection)selection).getPaths();
            int i = 0;
            while (i < paths.length) {
                this.fPendingExpansion.add(paths[i]);
                ++i;
            }
            if (this.getControl().getDisplay().getThread() == Thread.currentThread()) {
                this.attemptExpansion();
            } else {
                WorkbenchJob job = new WorkbenchJob("attemptExpansion"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        AsynchronousTreeModelViewer.this.attemptExpansion();
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        }
    }

    synchronized void attemptExpansion() {
        if (this.fPendingExpansion != null) {
            Iterator i = this.fPendingExpansion.iterator();
            while (i.hasNext()) {
                TreePath path = (TreePath)i.next();
                if (!this.attemptExpansion(path)) continue;
                i.remove();
            }
        }
    }

    synchronized boolean attemptExpansion(TreePath path) {
        boolean tryAgain = false;
        int segmentCount = path.getSegmentCount();
        int j = segmentCount - 1;
        while (j >= 0) {
            Object element = path.getSegment(j);
            ModelNode[] nodes = this.getModel().getNodes(element);
            if (nodes != null) {
                int k = 0;
                while (k < nodes.length) {
                    ModelNode node = nodes[k];
                    TreePath treePath = node.getTreePath();
                    if (path.startsWith(treePath) && !node.isDisposed()) {
                        Widget widget = node.getWidget();
                        if (widget == null) {
                            ModelNode parent = node.getParentNode();
                            ModelNode child = node;
                            widget = parent.getWidget();
                            while (widget == null && parent != null) {
                                child = parent;
                                if ((parent = parent.getParentNode()) == null) continue;
                                widget = parent.getWidget();
                                treePath = parent.getTreePath();
                            }
                            int childIndex = parent.getChildIndex(child);
                            if (childIndex < 0) {
                                return false;
                            }
                            TreeItem[] items = this.getItems(widget);
                            if (childIndex < items.length) {
                                this.getModel().mapWidget((Widget)items[childIndex], child);
                                widget = child.getWidget();
                                treePath = child.getTreePath();
                                tryAgain = true;
                            } else {
                                return false;
                            }
                        }
                        if (widget instanceof TreeItem) {
                            TreeItem treeItem = (TreeItem)widget;
                            if (treeItem.getExpanded()) {
                                return path.getSegmentCount() == treePath.getSegmentCount();
                            }
                            if (treeItem.getItemCount() > 0) {
                                this.updateChildren(element, (Widget)treeItem);
                                this.expand(treeItem);
                                if (path.getSegmentCount() == treePath.getSegmentCount()) {
                                    return true;
                                }
                                if (tryAgain) {
                                    return this.attemptExpansion(path);
                                }
                                return false;
                            }
                        }
                    }
                    ++k;
                }
            }
            --j;
        }
        if (tryAgain) {
            return this.attemptExpansion(path);
        }
        return false;
    }

    public Control getControl() {
        return this.fTree;
    }

    protected synchronized void inputChanged(Object input, Object oldInput) {
        this.fPendingExpansion.clear();
        this.fParentsPendingChildren.clear();
        super.inputChanged(input, oldInput);
    }

    protected synchronized TreePath getTreePath(TreeItem item) {
        TreeItem parent = item;
        ArrayList<Object> path = new ArrayList<Object>();
        while (parent != null && !parent.isDisposed()) {
            Object parentElement = parent.getData();
            if (parentElement == null) {
                return new TreePath(new Object[0]);
            }
            path.add(0, parentElement);
            parent = parent.getParentItem();
        }
        path.add(0, this.fTree.getData());
        return new TreePath(path.toArray());
    }

    public TreePath[] getTreePaths(Object element) {
        ModelNode[] nodes = this.getModel().getNodes(element);
        if (nodes == null) {
            return new TreePath[0];
        }
        TreePath[] paths = new TreePath[nodes.length];
        int i = 0;
        while (i < nodes.length) {
            paths[i] = nodes[i].getTreePath();
            ++i;
        }
        return paths;
    }

    protected void nodeChildrenChanged(ModelNode parentNode) {
        Widget widget = parentNode.getWidget();
        if (widget != null && !widget.isDisposed()) {
            int childCount = parentNode.getChildCount();
            this.setItemCount(widget, childCount);
            this.attemptExpansion();
            this.attemptSelection(false);
        }
    }

    protected void nodeContainerChanged(ModelNode node) {
        Widget widget = node.getWidget();
        if (widget != null && !widget.isDisposed() && this.isVisible(widget)) {
            boolean expanded = true;
            if (node.isContainer() && this.getItemCount(widget) == 0) {
                this.setItemCount(widget, 1);
            }
            if (widget instanceof TreeItem) {
                expanded = ((TreeItem)widget).getExpanded();
            }
            if (expanded) {
                this.updateChildren(node.getElement(), widget);
            }
        }
        this.attemptExpansion();
        this.attemptSelection(false);
    }

    protected int getItemCount(Widget widget) {
        if (widget instanceof TreeItem) {
            return ((TreeItem)widget).getItemCount();
        }
        return ((Tree)widget).getItemCount();
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
        super.doUpdateItem(item, element, fullMap);
        this.updateHasChildren(element, item);
    }

    private void setItemCount(Widget widget, int itemCount) {
        if (widget == this.fTree) {
            this.fTree.setItemCount(itemCount);
        } else {
            ((TreeItem)widget).setItemCount(itemCount);
        }
    }

    private TreeItem[] getItems(Widget widget) {
        if (widget instanceof TreeItem) {
            return ((TreeItem)widget).getItems();
        }
        return this.fTree.getItems();
    }

    public void handleEvent(Event event) {
        TreeItem item = (TreeItem)event.item;
        TreeItem parentItem = item.getParentItem();
        int index = 0;
        if (parentItem != null) {
            index = parentItem.indexOf(item);
        } else {
            parentItem = this.fTree;
            index = this.fTree.indexOf(item);
        }
        ModelNode parentNode = this.getModel().getModelNode((Widget)parentItem);
        if (parentNode != null) {
            ModelNode[] childrenNodes = parentNode.getChildrenNodes();
            if (childrenNodes != null && index < childrenNodes.length) {
                ModelNode child = childrenNodes[index];
                this.getModel().mapWidget((Widget)item, child);
                this.internalRefresh(child.getElement(), (Widget)item);
                this.attemptExpansion();
                this.attemptSelection(false);
            } else {
                this.addPendingChildIndex(parentNode, index);
            }
        }
    }

    private synchronized void addPendingChildIndex(ModelNode parent, int index) {
        int[] indicies = (int[])this.fParentsPendingChildren.get(parent);
        if (indicies == null) {
            indicies = new int[]{index};
        } else {
            int[] next = new int[indicies.length + 1];
            System.arraycopy(indicies, 0, next, 0, indicies.length);
            next[indicies.length] = index;
            indicies = next;
        }
        this.fParentsPendingChildren.put(parent, indicies);
    }

    private void expand(TreeItem child) {
        if (!child.getExpanded()) {
            child.setExpanded(true);
            TreeItem parent = child.getParentItem();
            if (parent != null) {
                this.expand(parent);
            }
        }
    }

    private void clear(Widget widget) {
        if (widget instanceof TreeItem) {
            TreeItem item = (TreeItem)widget;
            item.clearAll(true);
        } else {
            this.fTree.clearAll(true);
        }
    }

    private boolean isVisible(Widget widget) {
        if (widget instanceof Tree) {
            return true;
        }
        TreeItem item = (TreeItem)widget;
        Rectangle itemBounds = item.getBounds();
        return !NOT_VISIBLE.equals((Object)itemBounds);
    }

    protected Widget doFindInputItem(Object element) {
        if (element.equals(this.getInput())) {
            return this.fTree;
        }
        return null;
    }

    protected Widget doFindItem(Object element) {
        Widget[] widgets = this.getWidgets(element);
        if (widgets != null && widgets.length > 0) {
            return widgets[0];
        }
        return null;
    }

    protected ISelection newSelectionFromWidget() {
        Control control = this.getControl();
        if (control == null || control.isDisposed()) {
            return StructuredSelection.EMPTY;
        }
        List list = this.getSelectionFromWidget();
        return new TreeSelection((TreePath[])list.toArray());
    }

    protected synchronized List getSelectionFromWidget() {
        TreeItem[] selection = this.fTree.getSelection();
        TreePath[] paths = new TreePath[selection.length];
        int i = 0;
        while (i < selection.length) {
            paths[i] = this.getTreePath(selection[i]);
            ++i;
        }
        return Arrays.asList(paths);
    }

    protected synchronized void internalRefresh(Object element, Widget item) {
        super.internalRefresh(element, item);
        this.updateHasChildren(element, item);
    }

    public void reveal(Object element) {
        Widget[] widgets = this.getWidgets(element);
        if (widgets != null && widgets.length > 0) {
            TreeItem item = (TreeItem)widgets[0];
            Tree tree = (Tree)this.getControl();
            tree.showItem(item);
        }
    }

    protected synchronized ISelection doAttemptSelectionToWidget(ISelection selection, boolean reveal) {
        ArrayList<TreePath> remaining = new ArrayList<TreePath>();
        if (!selection.isEmpty()) {
            ArrayList<Widget> toSelect = new ArrayList<Widget>();
            ArrayList<Object> theElements = new ArrayList<Object>();
            TreeSelection treeSelection = (TreeSelection)selection;
            TreePath[] paths = treeSelection.getPaths();
            int i = 0;
            while (i < paths.length) {
                TreePath path = paths[i];
                if (path != null) {
                    ModelNode[] nodes = this.getModel().getNodes(path.getLastSegment());
                    boolean selected = false;
                    if (nodes != null) {
                        int j = 0;
                        while (j < nodes.length) {
                            Widget widget;
                            ModelNode node = nodes[j];
                            if (node.correspondsTo(path) && (widget = node.getWidget()) != null && !widget.isDisposed()) {
                                toSelect.add(widget);
                                theElements.add(path.getLastSegment());
                                selected = true;
                                break;
                            }
                            ++j;
                        }
                    }
                    if (!selected) {
                        remaining.add(path);
                    }
                }
                ++i;
            }
            if (!toSelect.isEmpty()) {
                TreeItem[] items = toSelect.toArray(new TreeItem[toSelect.size()]);
                int i2 = 0;
                while (i2 < items.length) {
                    TreeItem item = items[i2];
                    Object element = theElements.get(i2);
                    if (!item.isDisposed() && item.getData() != element) {
                        ModelNode node = this.getModel().getNode((Widget)item);
                        node.remap(element);
                        item.setData(element);
                    }
                    ++i2;
                }
                this.fTree.setSelection(items);
                if (reveal) {
                    this.fTree.showItem(items[0]);
                }
            }
        } else {
            this.fTree.setSelection(new TreeItem[0]);
        }
        return new TreeSelection(remaining.toArray(new TreePath[remaining.size()]));
    }

    public void collapseAll() {
        TreeItem[] items = this.fTree.getItems();
        int i = 0;
        while (i < items.length) {
            TreeItem item = items[i];
            if (item.getExpanded()) {
                this.collapse(item);
            }
            ++i;
        }
    }

    protected void collapse(TreeItem item) {
        TreeItem[] items = item.getItems();
        int i = 0;
        while (i < items.length) {
            TreeItem child = items[i];
            if (child.getExpanded()) {
                this.collapse(child);
            }
            ++i;
        }
        item.setExpanded(false);
    }

    void setColors(Widget widget, RGB[] foregrounds, RGB[] backgrounds) {
        if (widget instanceof TreeItem) {
            TreeItem item = (TreeItem)widget;
            Color[] fgs = this.getColor(foregrounds);
            Color[] bgs = this.getColor(backgrounds);
            int i = 0;
            while (i < bgs.length) {
                item.setForeground(i, fgs[i]);
                item.setBackground(i, bgs[i]);
                ++i;
            }
        }
    }

    void setFonts(Widget widget, FontData[] fontData) {
        if (widget instanceof TreeItem) {
            TreeItem item = (TreeItem)widget;
            Font[] fonts = this.getFonts(fontData);
            int i = 0;
            while (i < fonts.length) {
                item.setFont(i, fonts[i]);
                ++i;
            }
        }
    }

    protected boolean acceptsSelection(ISelection selection) {
        return selection instanceof TreeSelection;
    }

    protected ISelection getEmptySelection() {
        return new TreeSelection(new TreePath[0]);
    }

    public void add(TreePath treePath) {
        ((AsynchronousTreeModel)this.getModel()).add(treePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(TreePath treePath) {
        AsynchronousTreeModelViewer asynchronousTreeModelViewer = this;
        synchronized (asynchronousTreeModelViewer) {
            Iterator i = this.fPendingExpansion.iterator();
            while (i.hasNext()) {
                TreePath expansionPath = (TreePath)i.next();
                if (!expansionPath.startsWith(treePath)) continue;
                i.remove();
            }
        }
        ((AsynchronousTreeModel)this.getModel()).remove(treePath);
    }

    void setLabels(Widget widget, String[] text, ImageDescriptor[] image) {
        TreeItem item;
        if (widget instanceof TreeItem && !(item = (TreeItem)widget).isDisposed()) {
            item.setText(text);
            item.setImage(this.getImages(image));
        }
    }

    protected AsynchronousModel createModel() {
        return new AsynchronousTreeModel(this);
    }

    protected void nodeChanged(ModelNode node) {
        Widget widget = node.getWidget();
        if (widget != null && !widget.isDisposed()) {
            if (widget instanceof TreeItem && !this.isVisible(widget)) {
                this.clear(widget);
                return;
            }
            widget.setData(node.getElement());
            this.getModel().mapWidget(widget, node);
            this.internalRefresh(node.getElement(), widget);
            this.attemptExpansion();
            this.attemptSelection(false);
        }
    }

    protected void nodeChildrenSet(ModelNode parent, ModelNode[] children) {
        Widget widget;
        int[] indicies = (int[])this.fParentsPendingChildren.remove(parent);
        if (indicies != null && (widget = parent.getWidget()) != null && !widget.isDisposed()) {
            int i = 0;
            while (i < indicies.length) {
                int index = indicies[i];
                TreeItem item = null;
                if (widget instanceof TreeItem) {
                    TreeItem treeItem = (TreeItem)widget;
                    if (index < treeItem.getItemCount()) {
                        item = treeItem.getItem(index);
                    }
                } else {
                    Tree tree = (Tree)widget;
                    if (index < tree.getItemCount()) {
                        item = ((Tree)widget).getItem(index);
                    }
                }
                if (item != null && index < children.length) {
                    this.getModel().mapWidget((Widget)item, children[index]);
                    this.internalRefresh(children[index].getElement(), (Widget)item);
                }
                ++i;
            }
            this.setItemCount(widget, children.length);
            this.attemptExpansion();
            this.attemptSelection(false);
        }
    }

    public IModelUpdatePolicy createUpdatePolicy() {
        return new TreeUpdatePolicy();
    }

    protected synchronized void nodeDisposed(ModelNode node) {
        super.nodeDisposed(node);
        Widget widget = node.getWidget();
        if (widget instanceof Tree && !widget.isDisposed()) {
            this.clear(widget);
        }
    }
}

