/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.model.viewers;

import org.eclipse.debug.internal.ui.model.viewers.AsynchronousModel;
import org.eclipse.debug.internal.ui.model.viewers.AsynchronousModelRequestMonitor;
import org.eclipse.debug.internal.ui.model.viewers.AsynchronousModelViewer;
import org.eclipse.debug.internal.ui.model.viewers.ModelNode;
import org.eclipse.debug.internal.ui.viewers.provisional.ILabelRequestMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Widget;

class ModelLabelRequestMonitor
extends AsynchronousModelRequestMonitor
implements ILabelRequestMonitor {
    private String[] fLabels;
    private ImageDescriptor[] fImageDescriptors;
    private FontData[] fFontDatas;
    private RGB[] fForegrounds;
    private RGB[] fBackgrounds;

    ModelLabelRequestMonitor(ModelNode node, AsynchronousModel model) {
        super(node, model);
    }

    protected void performUpdate() {
        AsynchronousModelViewer viewer = this.getModel().getViewer();
        Widget widget = this.getNode().getWidget();
        if (!widget.isDisposed()) {
            viewer.setLabels(widget, this.fLabels, this.fImageDescriptors);
            viewer.setColors(widget, this.fForegrounds, this.fBackgrounds);
            viewer.setFonts(widget, this.fFontDatas);
        }
    }

    protected boolean contains(AsynchronousModelRequestMonitor update) {
        return update instanceof ModelLabelRequestMonitor && update.getNode() == this.getNode();
    }

    public void setLabels(String[] text) {
        this.fLabels = text;
    }

    public void setFontDatas(FontData[] fontData) {
        this.fFontDatas = fontData;
    }

    public void setImageDescriptors(ImageDescriptor[] image) {
        this.fImageDescriptors = image;
    }

    public void setForegrounds(RGB[] foreground) {
        this.fForegrounds = foreground;
    }

    public void setBackgrounds(RGB[] background) {
        this.fBackgrounds = background;
    }
}

