/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers;

import org.eclipse.debug.internal.ui.viewers.AsynchronousTableViewer;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class AsynchronousTableViewerContentManager
implements Listener {
    private Table fTable;
    private int fItemCount = 0;
    private Object[] fElements = new Object[50];
    private AsynchronousTableViewer fViewer;

    public AsynchronousTableViewerContentManager(AsynchronousTableViewer viewer) {
        this.fViewer = viewer;
        this.fTable = viewer.getTable();
        this.fTable.addListener(36, (Listener)this);
    }

    public void handleEvent(Event event) {
        TableItem item = (TableItem)event.item;
        int index = this.fTable.indexOf(item);
        Object element = this.fElements[index];
        this.fViewer.map(element, (Widget)item);
        this.fViewer.updateLabel(element, (Widget)item);
    }

    public void setElements(Object[] newElements) {
        this.growElementArray(newElements.length);
        int oldItemCount = this.fItemCount;
        this.setItemCount(newElements.length);
        int topIndex = this.fTable.getTopIndex();
        int visibleItems = this.getVisibleItemCount(topIndex);
        int bottomIndex = topIndex + visibleItems;
        int index = 0;
        int i = 0;
        while (i < newElements.length) {
            Object element;
            this.fElements[index] = element = newElements[i];
            TableItem item = this.fTable.getItem(index);
            if (index >= topIndex && index <= bottomIndex) {
                if (item.getData() != null) {
                    this.fViewer.remap(this.fElements[index], (Widget)item);
                } else {
                    this.fViewer.map(this.fElements[index], (Widget)item);
                }
                this.fViewer.updateLabel(this.fElements[index], (Widget)item);
            } else {
                this.fViewer.unmap(this.fElements[i], (Widget)item);
                this.fTable.clear(index);
            }
            ++index;
            ++i;
        }
        while (index < oldItemCount && this.fTable.getItemCount() > index) {
            TableItem item = this.fTable.getItem(index);
            this.fViewer.unmap(this.fElements[index], (Widget)item);
            this.fElements[index] = null;
            ++index;
        }
    }

    private void setItemCount(int itemCount) {
        this.fItemCount = itemCount;
        this.fTable.setItemCount(this.fItemCount);
        this.fTable.redraw();
    }

    private void growElementArray(int size) {
        if (size > this.fElements.length) {
            Object[] elements = new Object[size];
            System.arraycopy(this.fElements, 0, elements, 0, this.fElements.length);
            this.fElements = elements;
        }
    }

    public int getVisibleItemCount(int top) {
        int itemCount = this.fTable.getItemCount();
        return Math.min(this.fTable.getBounds().height / this.fTable.getItemHeight() + 2, itemCount - top);
    }

    public void dispose() {
        this.fElements = null;
        this.fViewer = null;
    }

    public Object[] getElements() {
        Object[] elements = new Object[this.fItemCount];
        System.arraycopy(this.fElements, 0, elements, 0, this.fItemCount);
        return elements;
    }

    public void add(Object[] elements) {
        this.growElementArray(this.fItemCount + elements.length);
        int index = this.fItemCount;
        while (index < this.fItemCount + elements.length) {
            this.fElements[index] = elements[index - this.fItemCount];
            ++index;
        }
        this.setItemCount(this.fItemCount + elements.length);
    }

    public void remove(Object[] elements) {
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            this.remove(element);
            ++i;
        }
    }

    private void remove(Object element) {
        int i = 0;
        while (i < this.fItemCount) {
            Object obj = this.fElements[i];
            if (element.equals(obj)) {
                System.arraycopy(this.fElements, i + 1, this.fElements, i, this.fItemCount - 1);
                TableItem item = this.fTable.getItem(i);
                this.fViewer.unmap(element, (Widget)item);
                item.dispose();
                --this.fItemCount;
            }
            ++i;
        }
    }

    public void insert(Object[] elements, int index) {
        Object element;
        this.growElementArray(this.fItemCount + elements.length);
        System.arraycopy(this.fElements, index, this.fElements, index + elements.length, this.fItemCount - index);
        int topIndex = this.fTable.getTopIndex();
        int visibleItems = this.getVisibleItemCount(topIndex);
        int bottomIndex = topIndex + visibleItems;
        int i = 0;
        while (i < elements.length) {
            this.fElements[index + i] = element = elements[i];
            ++i;
        }
        this.setItemCount(this.fItemCount + elements.length);
        i = index;
        while (i < this.fItemCount) {
            Object data;
            element = this.fElements[i];
            TableItem item = this.fTable.getItem(i);
            Object object = data = item != null ? item.getData() : null;
            if (i >= topIndex && i <= bottomIndex) {
                if (data != null) {
                    this.fViewer.remap(element, (Widget)item);
                } else {
                    this.fViewer.map(element, (Widget)item);
                }
                this.fViewer.updateLabel(element, (Widget)item);
            } else {
                if (data != null) {
                    this.fViewer.unmap(element, (Widget)item);
                }
                this.fTable.clear(i);
            }
            ++i;
        }
    }

    public void replace(Object element, Object replacement) {
        int i = 0;
        while (i < this.fItemCount) {
            Object obj = this.fElements[i];
            if (obj.equals(element)) {
                TableItem item = this.fTable.getItem(i);
                Object data = item.getData();
                int topIndex = this.fTable.getTopIndex();
                int visibleItems = this.getVisibleItemCount(topIndex);
                int bottomIndex = topIndex + visibleItems;
                if (i >= topIndex && i <= bottomIndex) {
                    if (data != null) {
                        this.fViewer.remap(replacement, (Widget)item);
                    } else {
                        this.fViewer.map(replacement, (Widget)item);
                    }
                    this.fViewer.updateLabel(replacement, (Widget)item);
                } else {
                    if (data != null) {
                        this.fViewer.unmap(element, (Widget)item);
                    }
                    this.fTable.clear(i);
                }
                this.fElements[i] = replacement;
                return;
            }
            ++i;
        }
    }

    public Object getElement(int index) {
        if (index >= 0 && index < this.fElements.length) {
            return this.fElements[index];
        }
        return null;
    }

    public Object getElement(TableItem item) {
        int i = this.fTable.indexOf(item);
        if (i > 0 && i < this.fElements.length) {
            return this.fElements[i];
        }
        return null;
    }

    public int indexOfElement(Object element) {
        int i = 0;
        while (i < this.fElements.length) {
            if (this.fElements[i] == element) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected AsynchronousTableViewer getTableViewer() {
        return this.fViewer;
    }
}

