/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers;

import org.eclipse.debug.internal.ui.viewers.DefaultElementComparer;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.swt.widgets.TreeItem;

public final class TreePath {
    private Object[] fSegments;
    private int fHash;
    private TreeItem fItem;

    public TreePath(Object[] segments) {
        Assert.isNotNull((Object)segments);
        int i = 0;
        while (i < segments.length) {
            Assert.isNotNull((Object)segments[i]);
            ++i;
        }
        this.fSegments = segments;
    }

    public Object getSegment(int index) {
        return this.fSegments[index];
    }

    public int getSegmentCount() {
        return this.fSegments.length;
    }

    public Object getFirstSegment() {
        if (this.fSegments.length == 0) {
            return null;
        }
        return this.fSegments[0];
    }

    public Object getLastSegment() {
        if (this.fSegments.length == 0) {
            return null;
        }
        return this.fSegments[this.fSegments.length - 1];
    }

    public boolean equals(Object other) {
        if (!(other instanceof TreePath)) {
            return false;
        }
        return this.equals((TreePath)other, null);
    }

    public int hashCode() {
        if (this.fHash != 0) {
            return this.fHash;
        }
        int i = 0;
        while (i < this.fSegments.length) {
            this.fHash += this.fSegments[i].hashCode();
            ++i;
        }
        return this.fHash;
    }

    public boolean equals(TreePath otherPath, IElementComparer comparer) {
        if (comparer == null) {
            comparer = DefaultElementComparer.INSTANCE;
        }
        if (otherPath == null) {
            return false;
        }
        if (this.fSegments.length != otherPath.fSegments.length) {
            return false;
        }
        int i = 0;
        while (i < this.fSegments.length) {
            if (!comparer.equals(this.fSegments[i], otherPath.fSegments[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    void setTreeItem(TreeItem item) {
        this.fItem = item;
    }

    TreeItem getTreeItem() {
        return this.fItem;
    }

    public boolean startsWith(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        int thisLength = this.getSegmentCount();
        int otherLength = treePath.getSegmentCount();
        if (otherLength == thisLength) {
            return treePath.equals(this);
        }
        if (otherLength > thisLength) {
            return false;
        }
        int segmentCount = treePath.getSegmentCount();
        if (segmentCount > this.fSegments.length) {
            return false;
        }
        int i = 0;
        while (i < segmentCount) {
            Object segment = treePath.getSegment(i);
            if (!segment.equals(this.fSegments[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void replaceSegment(int index, Object replacement) {
        this.fSegments[index] = replacement;
    }
}

