/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.update;

import org.eclipse.debug.internal.ui.viewers.AsynchronousTableViewer;
import org.eclipse.debug.internal.ui.viewers.AsynchronousViewer;
import org.eclipse.debug.internal.ui.viewers.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.update.AbstractUpdatePolicy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class DefaultTableUpdatePolicy
extends AbstractUpdatePolicy
implements IModelChangedListener {
    public void modelChanged(IModelDelta delta) {
        this.updateNodes(new IModelDelta[]{delta});
    }

    private void handleState(IModelDelta node) {
        AsynchronousViewer viewer = this.getViewer();
        if (viewer != null) {
            Object element = node.getElement();
            viewer.update(element);
            this.updateSelection(element, node.getFlags());
        }
    }

    private void handleContent(IModelDelta node) {
        AsynchronousViewer viewer = this.getViewer();
        if (viewer != null) {
            Object element = node.getElement();
            viewer.refresh(element);
            this.updateSelection(element, node.getFlags());
        }
    }

    private void updateSelection(Object element, int flags) {
        AsynchronousViewer viewer = this.getViewer();
        if (viewer != null && (flags & 0x200000) != 0) {
            ((AsynchronousTableViewer)this.getViewer()).setSelection((ISelection)new StructuredSelection(element));
        }
    }

    protected void updateNodes(IModelDelta[] nodes) {
        int i = 0;
        while (i < nodes.length) {
            IModelDelta node = nodes[i];
            int flags = node.getFlags();
            if ((flags & 0x800) != 0) {
                this.handleState(node);
            }
            if ((flags & 0x400) != 0) {
                this.handleContent(node);
            }
            if ((flags & 1) != 0) {
                this.handleAdd(node);
            }
            if ((flags & 2) != 0) {
                this.handleRemove(node);
            }
            if ((flags & 8) != 0) {
                this.handleReplace(node);
            }
            if ((flags & 0x10) != 0) {
                this.handleInsert(node);
            }
            IModelDelta[] childNodes = node.getNodes();
            this.updateNodes(childNodes);
            ++i;
        }
    }

    private void handleInsert(IModelDelta node) {
        AsynchronousTableViewer viewer = (AsynchronousTableViewer)this.getViewer();
        if (viewer != null) {
            viewer.insert(node.getElement(), node.getIndex());
            this.updateSelection(node.getElement(), node.getFlags());
        }
    }

    private void handleReplace(IModelDelta node) {
        AsynchronousTableViewer viewer = (AsynchronousTableViewer)this.getViewer();
        if (viewer != null) {
            viewer.replace(node.getElement(), node.getReplacementElement());
            this.updateSelection(node.getReplacementElement(), node.getFlags());
        }
    }

    protected void handleAdd(IModelDelta node) {
        ((AsynchronousTableViewer)this.getViewer()).add(node.getElement());
        this.updateSelection(node.getElement(), node.getFlags());
    }

    protected void handleRemove(IModelDelta node) {
        ((AsynchronousTableViewer)this.getViewer()).remove(node.getElement());
    }
}

