/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.internal.ui.views.memory.RetargetAddMemoryBlockAction;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.debug.ui.memory.IMemoryRenderingType;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

public class AddMemoryRenderingDialog
extends SelectionDialog {
    IMemoryBlock[] fMemoryBlocks;
    Combo memoryBlock;
    ListViewer fViewer;
    IMemoryBlock fSelectedMemoryBlock;
    Button addNew;
    ISelectionChangedListener fSelectionChangedListener;
    MouseListener fMouseListener;
    SelectionListener fSelectionListener;
    private IMemoryRenderingSite fSite;
    static /* synthetic */ Class class$0;

    public boolean close() {
        this.fViewer.removeSelectionChangedListener(this.fSelectionChangedListener);
        this.memoryBlock.removeSelectionListener(this.fSelectionListener);
        this.addNew.removeMouseListener(this.fMouseListener);
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    public Object[] getResult() {
        Object[] results = super.getResult();
        if (results != null) {
            Object[] renderings = ((IStructuredSelection)results[0]).toArray();
            return renderings;
        }
        return new Object[0];
    }

    protected void cancelPressed() {
        this.setResult(null);
        super.cancelPressed();
    }

    protected void okPressed() {
        ISelection select = this.fViewer.getSelection();
        this.setSelectionResult(new Object[]{select});
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = 3;
        compositeLayout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)compositeLayout);
        GridData comositeSpec = new GridData();
        comositeSpec.grabExcessVerticalSpace = true;
        comositeSpec.grabExcessHorizontalSpace = true;
        comositeSpec.horizontalAlignment = 4;
        comositeSpec.verticalAlignment = 2;
        composite.setLayoutData((Object)comositeSpec);
        Label textLabel = new Label(composite, 0);
        textLabel.setText(DebugUIMessages.AddMemoryRenderingDialog_Memory_Monitor);
        GridData textLayout = new GridData();
        textLayout.verticalAlignment = 2;
        textLayout.horizontalAlignment = 1;
        textLabel.setLayoutData((Object)textLayout);
        this.memoryBlock = new Combo(composite, 2056);
        GridData spec = new GridData(768);
        spec.grabExcessVerticalSpace = false;
        spec.grabExcessHorizontalSpace = false;
        spec.horizontalAlignment = 4;
        spec.verticalAlignment = 4;
        spec.horizontalSpan = 4;
        this.memoryBlock.setLayoutData((Object)spec);
        Label filler = new Label(composite, 0);
        filler.setText(" ");
        GridData fillerData = new GridData(768);
        fillerData.horizontalSpan = 2;
        filler.setLayoutData((Object)fillerData);
        this.addNew = new Button(composite, 0);
        this.addNew.setText(DebugUIMessages.AddMemoryRenderingDialog_Add_New);
        GridData specButton = new GridData();
        specButton.horizontalAlignment = 3;
        specButton.verticalAlignment = 2;
        this.addNew.setLayoutData((Object)specButton);
        this.fMouseListener = new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                IMemoryBlock[] oldBlocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks();
                RetargetAddMemoryBlockAction action = new RetargetAddMemoryBlockAction(AddMemoryRenderingDialog.this.fSite, false);
                action.run();
                IMemoryBlock[] newBlocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks();
                IMemoryBlock mb = action.getLastMemoryBlock();
                if (mb == null) {
                    mb = this.findNewMemoryBlock(oldBlocks, newBlocks);
                }
                AddMemoryRenderingDialog.this.populateDialog(AddMemoryRenderingDialog.this.memoryBlock, AddMemoryRenderingDialog.this.fViewer, mb);
                action.dispose();
            }

            private IMemoryBlock findNewMemoryBlock(IMemoryBlock[] oldBlocks, IMemoryBlock[] newBlocks) {
                if (oldBlocks.length == newBlocks.length) {
                    return newBlocks[newBlocks.length - 1];
                }
                if (newBlocks.length > oldBlocks.length) {
                    int i = newBlocks.length - 1;
                    while (i >= 0) {
                        boolean found = false;
                        int j = 0;
                        while (j < oldBlocks.length) {
                            if (newBlocks[i] == oldBlocks[j]) {
                                found = true;
                            }
                            ++j;
                        }
                        if (!found) {
                            return newBlocks[i];
                        }
                        ++i;
                    }
                }
                return newBlocks[newBlocks.length - 1];
            }
        };
        this.addNew.addMouseListener(this.fMouseListener);
        this.fSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int idx = AddMemoryRenderingDialog.this.memoryBlock.getSelectionIndex();
                if (AddMemoryRenderingDialog.this.fMemoryBlocks == null) {
                    return;
                }
                AddMemoryRenderingDialog.this.fSelectedMemoryBlock = AddMemoryRenderingDialog.this.fMemoryBlocks[idx];
                AddMemoryRenderingDialog.this.fViewer.setInput((Object)AddMemoryRenderingDialog.this.fSelectedMemoryBlock);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.memoryBlock.addSelectionListener(this.fSelectionListener);
        Label renderingLabel = new Label(composite, 0);
        renderingLabel.setText(DebugUIMessages.AddMemoryRenderingDialog_Memory_renderings);
        GridData renderingLayout = new GridData();
        renderingLayout.horizontalAlignment = 1;
        renderingLayout.verticalAlignment = 2;
        renderingLayout.horizontalSpan = 3;
        renderingLabel.setLayoutData((Object)renderingLayout);
        this.fViewer = new ListViewer(composite);
        this.fViewer.setContentProvider((IContentProvider)new MemoryRenderingContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new MemoryRenderingLabelProvider());
        GridData listLayout = new GridData(1808);
        listLayout.horizontalSpan = 3;
        listLayout.heightHint = 140;
        this.fViewer.getControl().setLayoutData((Object)listLayout);
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AddMemoryRenderingDialog.this.okPressed();
            }
        });
        this.populateDialog(this.memoryBlock, this.fViewer, null);
        this.fSelectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = AddMemoryRenderingDialog.this.fViewer.getSelection();
                if (selection.isEmpty()) {
                    AddMemoryRenderingDialog.this.getButton(0).setEnabled(false);
                } else {
                    AddMemoryRenderingDialog.this.getButton(0).setEnabled(true);
                }
            }
        };
        this.fViewer.addSelectionChangedListener(this.fSelectionChangedListener);
        return composite;
    }

    public AddMemoryRenderingDialog(Shell parent, IMemoryRenderingSite site) {
        super(parent);
        super.setTitle(DebugUIMessages.AddMemoryRenderingDialog_Add_memory_rendering);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(DebugUIPlugin.getUniqueIdentifier()) + ".AddMemoryRenderingDialog_context");
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fSite = site;
    }

    private void populateDialog(Combo combo, ListViewer viewer, IMemoryBlock lastAdded) {
        IMemoryBlock currentBlock;
        combo.removeAll();
        if (lastAdded != null) {
            currentBlock = lastAdded;
        } else {
            ISelectionProvider selectionProvider = this.fSite.getSite().getSelectionProvider();
            ISelection selection = null;
            selection = selectionProvider != null ? selectionProvider.getSelection() : DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection("org.eclipse.debug.ui.MemoryView");
            IMemoryBlock element = this.getMemoryBlock(selection);
            if (!(element instanceof IMemoryBlock) || element == null) {
                ISelection debugSelection = DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection("org.eclipse.debug.ui.DebugView");
                if (!(debugSelection instanceof IStructuredSelection)) {
                    return;
                }
                if (debugSelection == null || debugSelection.isEmpty() || ((IStructuredSelection)debugSelection).size() > 1) {
                    return;
                }
                Object elem = ((IStructuredSelection)debugSelection).getFirstElement();
                if (!(elem instanceof IDebugElement)) {
                    return;
                }
                IMemoryBlock[] blocks = MemoryViewUtil.getMemoryBlockManager().getMemoryBlocks(((IDebugElement)elem).getDebugTarget());
                if (blocks.length <= 0) {
                    combo.add(DebugUIMessages.AddMemoryRenderingDialog_Add_New);
                    combo.select(0);
                    return;
                }
                currentBlock = blocks[0];
            } else {
                currentBlock = element;
            }
        }
        this.fMemoryBlocks = MemoryViewUtil.getMemoryBlockManager().getMemoryBlocks(currentBlock.getDebugTarget());
        int selectionIdx = -1;
        int i = 0;
        while (i < this.fMemoryBlocks.length) {
            ILabelDecorator decorator;
            String text = "";
            if (this.fMemoryBlocks[i] instanceof IMemoryBlockExtension) {
                try {
                    text = ((IMemoryBlockExtension)this.fMemoryBlocks[i]).getExpression();
                    if (text == null) {
                        text = DebugUIMessages.AddMemoryRenderingDialog_Unknown;
                    }
                    if (((IMemoryBlockExtension)this.fMemoryBlocks[i]).getBigBaseAddress() != null) {
                        text = String.valueOf(text) + " : 0x";
                        text = String.valueOf(text) + ((IMemoryBlockExtension)this.fMemoryBlocks[i]).getBigBaseAddress().toString(16);
                    }
                }
                catch (DebugException debugException) {
                    long address = this.fMemoryBlocks[i].getStartAddress();
                    text = Long.toHexString(address);
                }
            } else {
                long address = this.fMemoryBlocks[i].getStartAddress();
                text = Long.toHexString(address);
            }
            if (this.fMemoryBlocks[i] == currentBlock) {
                selectionIdx = i;
            }
            IMemoryBlock iMemoryBlock = this.fMemoryBlocks[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.jface.viewers.ILabelDecorator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((decorator = (ILabelDecorator)iMemoryBlock.getAdapter((Class)clazz)) != null) {
                text = decorator.decorateText(text, (Object)this.fMemoryBlocks[i]);
            }
            combo.add(text);
            ++i;
        }
        combo.select(selectionIdx);
        this.fSelectedMemoryBlock = currentBlock;
        viewer.setInput((Object)currentBlock);
    }

    private IMemoryBlock getMemoryBlock(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        if (selection == null || selection.isEmpty() || ((IStructuredSelection)selection).size() > 1) {
            return null;
        }
        Object elem = ((IStructuredSelection)selection).getFirstElement();
        if (elem instanceof IMemoryBlock) {
            return (IMemoryBlock)elem;
        }
        if (elem instanceof IMemoryRendering) {
            return ((IMemoryRendering)elem).getMemoryBlock();
        }
        return null;
    }

    public IMemoryBlock getMemoryBlock() {
        return this.fSelectedMemoryBlock;
    }

    class MemoryRenderingLabelProvider
    implements ILabelProvider {
        MemoryRenderingLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof IMemoryRenderingType) {
                String label = ((IMemoryRenderingType)element).getLabel();
                return label;
            }
            return element.toString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class MemoryRenderingContentProvider
    implements IStructuredContentProvider {
        MemoryRenderingContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] renderings = DebugUITools.getMemoryRenderingManager().getRenderingTypes((IMemoryBlock)inputElement);
            return renderings;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

