/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IInternalDebugUIConstants;
import org.eclipse.debug.internal.ui.viewers.AsynchronousTableViewerContentManager;
import org.eclipse.debug.internal.ui.viewers.IUpdatePolicy;
import org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousRequestMonitor;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.internal.ui.views.memory.renderings.AbstractAsyncTableRendering;
import org.eclipse.debug.internal.ui.views.memory.renderings.AsyncTableRenderingCellModifier;
import org.eclipse.debug.internal.ui.views.memory.renderings.AsyncTableRenderingUpdatePolicy;
import org.eclipse.debug.internal.ui.views.memory.renderings.AsyncVirtualContentTableViewer;
import org.eclipse.debug.internal.ui.views.memory.renderings.IContentChangeComputer;
import org.eclipse.debug.internal.ui.views.memory.renderings.IVirtualContentManager;
import org.eclipse.debug.internal.ui.views.memory.renderings.MemorySegment;
import org.eclipse.debug.internal.ui.views.memory.renderings.TableRenderingContentManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.progress.UIJob;

public class AsyncTableRenderingViewer
extends AsyncVirtualContentTableViewer {
    private AbstractAsyncTableRendering fRendering;
    private Object fPendingSelection;
    private Object fSelectionKey;
    private TableCursor fTableCursor;
    private KeyAdapter fCursorKeyAdapter;
    private TraverseListener fCursorTraverseListener;
    private MouseAdapter fCursorMouseListener;
    private SelectionAdapter fCursorSelectionListener;
    private TableEditor fCursorEditor;
    private FocusAdapter fEditorFocusListener;
    private KeyAdapter fEditorKeyListener;

    public AsyncTableRenderingViewer(AbstractAsyncTableRendering rendering, Composite parent, int style) {
        super(parent, style);
        this.fRendering = rendering;
        this.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                AsyncTableRenderingViewer.this.handleTableMouseEvent(e);
            }
        });
        this.createCursor(this.getTable());
    }

    public IUpdatePolicy createUpdatePolicy() {
        return new AsyncTableRenderingUpdatePolicy();
    }

    protected AsynchronousTableViewerContentManager createContentManager() {
        return new TableRenderingContentManager(this);
    }

    protected void setChildren(Widget widget, List children) {
        if (AsyncVirtualContentTableViewer.DEBUG_DYNAMIC_LOADING) {
            System.out.println("Set Children in AsyncTableRenderingViewer");
            Iterator iter = children.iterator();
            int i = 0;
            while (iter.hasNext()) {
                System.out.println(String.valueOf(i) + " " + ((MemorySegment)((Object)iter.next())).getAddress().toString(16));
                ++i;
            }
        }
        Object[] newContent = this.compare(children);
        ArrayList<Object> newList = new ArrayList<Object>();
        int i = 0;
        while (i < newContent.length) {
            newList.add(newContent[i]);
            ++i;
        }
        super.setChildren(widget, newList);
        if (widget == this.getTable()) {
            this.attemptSetKeySelection();
        }
    }

    private Object[] compare(List newContent) {
        IMemoryBlockExtension mbExt;
        IContentChangeComputer computer = null;
        if (this.getContentManager() instanceof IContentChangeComputer) {
            computer = (IContentChangeComputer)((Object)this.getContentManager());
        }
        if (computer == null) {
            return newContent.toArray();
        }
        if (computer.isEmpty()) {
            return newContent.toArray();
        }
        IMemoryBlock mb = this.fRendering.getMemoryBlock();
        if (mb instanceof IMemoryBlockExtension && (mbExt = (IMemoryBlockExtension)mb).supportsChangeManagement()) {
            return newContent.toArray();
        }
        Object[] content = computer.compare(newContent.toArray());
        return content;
    }

    public AbstractAsyncTableRendering getRendering() {
        return this.fRendering;
    }

    private void createCursor(Table table) {
        this.fTableCursor = new TableCursor(table, 0);
        Display display = this.fTableCursor.getDisplay();
        this.fTableCursor.setBackground(display.getSystemColor(26));
        this.fTableCursor.setForeground(display.getSystemColor(27));
        this.fTableCursor.setFont(JFaceResources.getFont((String)IInternalDebugUIConstants.FONT_NAME));
        this.fTableCursor.setFocus();
        this.fCursorKeyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                AsyncTableRenderingViewer.this.handleCursorKeyPressed(e);
            }
        };
        this.fTableCursor.addKeyListener((KeyListener)this.fCursorKeyAdapter);
        this.fCursorTraverseListener = new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                AsyncTableRenderingViewer.this.handleCursorTraverseEvt(e);
            }
        };
        this.fTableCursor.addTraverseListener(this.fCursorTraverseListener);
        this.fCursorMouseListener = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                AsyncTableRenderingViewer.this.handleCursorMouseEvent(e);
            }
        };
        this.fTableCursor.addMouseListener((MouseListener)this.fCursorMouseListener);
        this.fTableCursor.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (AsyncTableRenderingViewer.this.fTableCursor == null) {
                    return;
                }
                AsyncTableRenderingViewer.this.fTableCursor.removeTraverseListener(AsyncTableRenderingViewer.this.fCursorTraverseListener);
                AsyncTableRenderingViewer.this.fTableCursor.removeKeyListener((KeyListener)AsyncTableRenderingViewer.this.fCursorKeyAdapter);
                AsyncTableRenderingViewer.this.fTableCursor.removeMouseListener((MouseListener)AsyncTableRenderingViewer.this.fCursorMouseListener);
                AsyncTableRenderingViewer.this.fTableCursor.removeSelectionListener((SelectionListener)AsyncTableRenderingViewer.this.fCursorSelectionListener);
            }
        });
        this.fCursorSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AsyncTableRenderingViewer.this.handleCursorMoved();
            }
        };
        this.fTableCursor.addSelectionListener((SelectionListener)this.fCursorSelectionListener);
        this.fCursorEditor = new TableEditor(this.getTable());
    }

    private void handleCursorKeyPressed(KeyEvent event) {
        if (event.character == '\r' && event.getSource() instanceof TableCursor) {
            this.activateCellEditor(null);
            return;
        }
        if (MemoryViewUtil.isValidEditEvent(event.keyCode) && event.getSource() instanceof TableCursor) {
            String initialValue = String.valueOf(event.character);
            this.activateCellEditor(initialValue);
            return;
        }
    }

    private void handleCursorMouseEvent(MouseEvent e) {
        int col;
        if (e.button == 1 && (col = this.fTableCursor.getColumn()) > 0 && col <= this.getNumCol()) {
            this.activateCellEditor(null);
        }
    }

    private void handleCursorTraverseEvt(TraverseEvent e) {
        if (this.fTableCursor.getRow() == null) {
            return;
        }
        Table table = (Table)this.fTableCursor.getParent();
        int row = table.indexOf(this.fTableCursor.getRow());
        int col = this.fTableCursor.getColumn();
        if (col == this.getNumCol() && e.keyCode == 0x1000004) {
            if (row + 1 >= table.getItemCount()) {
                return;
            }
            col = 0;
            this.fTableCursor.setSelection(++row, col);
        }
        if (col <= 1 && e.keyCode == 0x1000003) {
            if (row - 1 < 0) {
                return;
            }
            col = this.getNumCol() + 1;
            this.fTableCursor.setSelection(--row, col);
        }
    }

    private synchronized void handleCursorMoved() {
        this.fSelectionKey = this.getSelectionKeyFromCursor();
        if (AsyncVirtualContentTableViewer.DEBUG_DYNAMIC_LOADING) {
            System.out.println(String.valueOf(Thread.currentThread().getName()) + " cursor moved selection is: " + ((BigInteger)this.fSelectionKey).toString(16));
        }
        this.handleScrollBarSelection();
        this.fireSelectionChanged(this.fSelectionKey);
    }

    private int getNumCol() {
        int bytesPerLine = this.fRendering.getBytesPerLine();
        int columnSize = this.fRendering.getBytesPerColumn();
        return bytesPerLine / columnSize;
    }

    public void setSelection(Object key) {
        this.fSelectionKey = key;
        this.fPendingSelection = key;
        this.attemptSetKeySelection();
    }

    public Object getSelectionKey() {
        return this.fSelectionKey;
    }

    private synchronized void attemptSetKeySelection() {
        Object remaining;
        if (this.fPendingSelection != null && (remaining = this.doAttemptSetKeySelection(this.fPendingSelection)) == null) {
            this.fPendingSelection = remaining;
        }
    }

    synchronized Object doAttemptSetKeySelection(Object key) {
        if (this.getBufferTopKey() == null || this.getBufferEndKey() == null) {
            return key;
        }
        final int row = this.indexOf(key);
        if (row == -1) {
            this.showTableCursor(false);
            return key;
        }
        Object element = this.getContentManager().getElement(row);
        final int col = this.columnOf(element, key);
        if (col == -1) {
            this.showTableCursor(false);
            return key;
        }
        UIJob uiJob = new UIJob("Set Cursor Selection"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    AsyncTableRenderingViewer.this.fTableCursor.setSelection(row, col);
                    AsyncTableRenderingViewer.this.showTableCursor(true);
                }
                catch (RuntimeException runtimeException) {
                    AsyncTableRenderingViewer.this.showTableCursor(false);
                }
                return Status.OK_STATUS;
            }
        };
        uiJob.setSystem(true);
        uiJob.schedule();
        return null;
    }

    private Object getSelectionKeyFromCursor() {
        int row = this.getContentManager().indexOfElement(this.getElement((Widget)this.fTableCursor.getRow()));
        int col = this.fTableCursor.getColumn();
        return this.getVirtualContentManager().getKey(row, col);
    }

    private Object getBufferTopKey() {
        return this.getKey(0);
    }

    private Object getBufferEndKey() {
        AsynchronousTableViewerContentManager mgr = this.getContentManager();
        return this.getKey(mgr.getElements().length - 1);
    }

    public int indexOf(Object key) {
        int idx = -1;
        AsynchronousTableViewerContentManager mgr = this.getContentManager();
        if (mgr instanceof IVirtualContentManager) {
            idx = ((IVirtualContentManager)((Object)mgr)).indexOf(key);
        }
        return idx;
    }

    private int columnOf(Object element, Object key) {
        int idx = -1;
        AsynchronousTableViewerContentManager mgr = this.getContentManager();
        if (mgr instanceof IVirtualContentManager) {
            idx = ((IVirtualContentManager)((Object)mgr)).columnOf(element, key);
        }
        return idx;
    }

    public Object getKey(int index) {
        AsynchronousTableViewerContentManager mgr = this.getContentManager();
        if (mgr instanceof IVirtualContentManager) {
            Object key = ((IVirtualContentManager)((Object)mgr)).getKey(index);
            return key;
        }
        return null;
    }

    public Object getKey(int row, int col) {
        return this.getVirtualContentManager().getKey(row, col);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void preservingSelection(Runnable updateCode) {
        if (this.getPendingSetTopIndexKey() == null) {
            Object oldTopIndexKey = null;
            Object oldSelectionKey = null;
            try {
                oldTopIndexKey = this.getTopIndexKey();
                if (AsyncVirtualContentTableViewer.DEBUG_DYNAMIC_LOADING) {
                    if (oldTopIndexKey != null) {
                        System.out.println("preserve top index: " + ((BigInteger)oldTopIndexKey).toString(16));
                    } else {
                        System.out.println("top index key is null, nothing to preserve");
                    }
                }
                oldSelectionKey = this.getSelectionKey();
                updateCode.run();
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (oldSelectionKey != null) {
                    this.setSelection(oldSelectionKey);
                }
                if (oldTopIndexKey == null) throw throwable;
                this.setTopIndex(oldTopIndexKey);
                if (!AsyncVirtualContentTableViewer.DEBUG_DYNAMIC_LOADING) throw throwable;
                System.out.println("finished top index: " + ((BigInteger)oldTopIndexKey).toString(16));
                throw throwable;
            }
            {
                Object var4_6 = null;
                if (oldSelectionKey != null) {
                    this.setSelection(oldSelectionKey);
                }
                if (oldTopIndexKey == null) return;
                this.setTopIndex(oldTopIndexKey);
                if (!AsyncVirtualContentTableViewer.DEBUG_DYNAMIC_LOADING) return;
                System.out.println("finished top index: " + ((BigInteger)oldTopIndexKey).toString(16));
                return;
            }
        }
        if (AsyncVirtualContentTableViewer.DEBUG_DYNAMIC_LOADING) {
            System.out.println("next top index should be: " + ((BigInteger)this.getPendingSetTopIndexKey()).toString(16));
        }
        updateCode.run();
    }

    public void dispose() {
        super.dispose();
        if (!this.fTableCursor.isDisposed()) {
            this.fCursorEditor.dispose();
            this.fTableCursor.removeTraverseListener(this.fCursorTraverseListener);
            this.fTableCursor.removeKeyListener((KeyListener)this.fCursorKeyAdapter);
            this.fTableCursor.removeMouseListener((MouseListener)this.fCursorMouseListener);
        }
    }

    public void showTableCursor(final boolean show) {
        Display display = DebugUIPlugin.getDefault().getWorkbench().getDisplay();
        if (Thread.currentThread() == display.getThread()) {
            if (!this.fTableCursor.isDisposed()) {
                this.fTableCursor.setVisible(show);
            }
        } else {
            UIJob job = new UIJob("show table cursor"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (!AsyncTableRenderingViewer.this.fTableCursor.isDisposed()) {
                        AsyncTableRenderingViewer.this.fTableCursor.setVisible(show);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    public void setLabels(Widget widget, String[] labels, ImageDescriptor[] imageDescriptors) {
        super.setLabels(widget, labels, imageDescriptors);
        if (widget == this.fTableCursor.getRow()) {
            this.fTableCursor.redraw();
        }
        if (!this.hasPendingUpdates()) {
            this.fPendingSelection = this.getSelectionKey();
            this.attemptSetKeySelection();
        }
    }

    private void handleTableMouseEvent(MouseEvent e) {
        TableItem[] tableItems = this.getTable().getItems();
        TableItem selectedRow = null;
        int colNum = -1;
        int numCol = this.getColumnProperties().length;
        int j = 0;
        while (j < tableItems.length) {
            TableItem item = tableItems[j];
            int i = 0;
            while (i < numCol) {
                Rectangle bound = item.getBounds(i);
                if (bound.contains(e.x, e.y)) {
                    colNum = i;
                    selectedRow = item;
                    break;
                }
                ++i;
            }
            ++j;
        }
        if (colNum < 1) {
            return;
        }
        if (selectedRow != null) {
            int row = this.getTable().indexOf(selectedRow);
            this.showTableCursor(true);
            this.fTableCursor.setSelection(row, colNum);
            this.handleCursorMoved();
            this.fTableCursor.setFocus();
        }
    }

    private void activateCellEditor(String initialValue) {
        int col = this.fTableCursor.getColumn();
        int row = this.indexOf(this.fSelectionKey);
        if (row < 0) {
            return;
        }
        if (col == 0 || col > this.getNumCol()) {
            return;
        }
        ICellModifier cellModifier = null;
        cellModifier = this.getCellModifier();
        TableItem tableItem = this.getTable().getItem(row);
        Object element = tableItem.getData();
        if (element != null) {
            Object property = this.getColumnProperties()[col];
            Object value = cellModifier.getValue(element, (String)property);
            ((AsyncTableRenderingCellModifier)cellModifier).setEditActionInvoked(true);
            boolean canEdit = cellModifier.canModify(element, (String)property);
            ((AsyncTableRenderingCellModifier)cellModifier).setEditActionInvoked(false);
            if (!canEdit) {
                return;
            }
            TextCellEditor selectedEditor = (TextCellEditor)this.getCellEditors()[col];
            if (cellModifier != null && selectedEditor != null && tableItem != null) {
                Text text = (Text)selectedEditor.getControl();
                String cellValue = null;
                cellValue = initialValue != null ? initialValue : (String)value;
                text.setText(cellValue);
                this.fCursorEditor.horizontalAlignment = 16384;
                this.fCursorEditor.grabHorizontal = true;
                this.fCursorEditor.setEditor((Control)text, tableItem, col);
                selectedEditor.setFocus();
                if (initialValue != null) {
                    text.clearSelection();
                }
                text.setFont(JFaceResources.getFont((String)IInternalDebugUIConstants.FONT_NAME));
                this.addListeners(text);
                this.fTableCursor.moveBelow((Control)text);
            }
        }
    }

    private void addListeners(Text text) {
        this.fEditorFocusListener = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                AsyncTableRenderingViewer.this.handleTableEditorFocusLost(e);
            }
        };
        text.addFocusListener((FocusListener)this.fEditorFocusListener);
        this.fEditorKeyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                AsyncTableRenderingViewer.this.handleKeyEventInEditor(e);
            }
        };
        text.addKeyListener((KeyListener)this.fEditorKeyListener);
    }

    private void handleTableEditorFocusLost(FocusEvent event) {
        final FocusEvent e = event;
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    int row = AsyncTableRenderingViewer.this.indexOf(AsyncTableRenderingViewer.this.fSelectionKey);
                    int col = AsyncTableRenderingViewer.this.fTableCursor.getColumn();
                    Text text = (Text)e.getSource();
                    AsyncTableRenderingViewer.this.removeListeners(text);
                    String newValue = text.getText();
                    AsyncTableRenderingViewer.this.modifyValue(row, col, newValue);
                    AsyncTableRenderingViewer.this.setSelection(AsyncTableRenderingViewer.this.fSelectionKey);
                    AsyncTableRenderingViewer.this.fTableCursor.moveAbove((Control)text);
                    AsyncTableRenderingViewer.this.fTableCursor.setVisible(true);
                }
                catch (NumberFormatException numberFormatException) {
                    MemoryViewUtil.openError(DebugUIMessages.MemoryViewCellModifier_failure_title, DebugUIMessages.MemoryViewCellModifier_data_is_invalid, null);
                }
            }
        });
    }

    private void handleKeyEventInEditor(KeyEvent event) {
        final KeyEvent e = event;
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Text text = (Text)e.getSource();
                int row = AsyncTableRenderingViewer.this.indexOf(AsyncTableRenderingViewer.this.fSelectionKey);
                int col = AsyncTableRenderingViewer.this.fTableCursor.getColumn();
                try {
                    switch (e.keyCode) {
                        case 0x1000001: {
                            if (row - 1 < 0) {
                                return;
                            }
                            AsyncTableRenderingViewer.this.modifyValue(row, col, text.getText());
                            AsyncTableRenderingViewer.this.fTableCursor.setSelection(--row, col);
                            AsyncTableRenderingViewer.this.handleCursorMoved();
                            AsyncTableRenderingViewer.this.removeListeners(text);
                            AsyncTableRenderingViewer.this.activateCellEditor(null);
                            break;
                        }
                        case 0x1000002: {
                            if (row + 1 >= AsyncTableRenderingViewer.this.getTable().getItemCount()) {
                                return;
                            }
                            AsyncTableRenderingViewer.this.modifyValue(row, col, text.getText());
                            AsyncTableRenderingViewer.this.fTableCursor.setSelection(++row, col);
                            AsyncTableRenderingViewer.this.handleCursorMoved();
                            AsyncTableRenderingViewer.this.removeListeners(text);
                            AsyncTableRenderingViewer.this.activateCellEditor(null);
                            break;
                        }
                        case 0: {
                            int numCharsPerByte = AsyncTableRenderingViewer.this.fRendering.getNumCharsPerByte();
                            if (numCharsPerByte > 0 && text.getText().length() > AsyncTableRenderingViewer.this.fRendering.getBytesPerColumn() * numCharsPerByte) {
                                String newValue = text.getText();
                                text.setText(newValue.substring(0, AsyncTableRenderingViewer.this.fRendering.getBytesPerColumn() * numCharsPerByte));
                                AsyncTableRenderingViewer.this.modifyValue(row, col, text.getText());
                                if (col >= AsyncTableRenderingViewer.this.getNumCol()) {
                                    col = 1;
                                    ++row;
                                } else {
                                    ++row;
                                }
                                AsyncTableRenderingViewer.this.fTableCursor.setSelection(row, col);
                                AsyncTableRenderingViewer.this.handleCursorMoved();
                                AsyncTableRenderingViewer.this.removeListeners(text);
                                AsyncTableRenderingViewer.this.activateCellEditor(newValue.substring(AsyncTableRenderingViewer.this.fRendering.getBytesPerColumn() * numCharsPerByte));
                            }
                            break;
                        }
                        case 27: {
                            AsyncTableRenderingViewer.this.fTableCursor.setSelection(row, col);
                            AsyncTableRenderingViewer.this.handleCursorMoved();
                            AsyncTableRenderingViewer.this.removeListeners(text);
                            AsyncTableRenderingViewer.this.fTableCursor.setFocus();
                            break;
                        }
                        default: {
                            int numCharsPerByte = AsyncTableRenderingViewer.this.fRendering.getNumCharsPerByte();
                            if (numCharsPerByte > 0 && text.getText().length() > AsyncTableRenderingViewer.this.fRendering.getBytesPerColumn() * numCharsPerByte) {
                                String newValue = text.getText();
                                text.setText(newValue.substring(0, AsyncTableRenderingViewer.this.fRendering.getBytesPerColumn() * numCharsPerByte));
                                AsyncTableRenderingViewer.this.modifyValue(row, col, text.getText());
                                if (col >= AsyncTableRenderingViewer.this.getNumCol()) {
                                    col = 1;
                                    ++row;
                                } else {
                                    ++col;
                                }
                                AsyncTableRenderingViewer.this.fTableCursor.setSelection(row, col);
                                AsyncTableRenderingViewer.this.handleCursorMoved();
                                AsyncTableRenderingViewer.this.removeListeners(text);
                                AsyncTableRenderingViewer.this.activateCellEditor(newValue.substring(AsyncTableRenderingViewer.this.fRendering.getBytesPerColumn() * numCharsPerByte));
                            }
                            break;
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    MemoryViewUtil.openError(DebugUIMessages.MemoryViewCellModifier_failure_title, DebugUIMessages.MemoryViewCellModifier_data_is_invalid, null);
                    AsyncTableRenderingViewer.this.fTableCursor.setSelection(row, col);
                    AsyncTableRenderingViewer.this.handleCursorMoved();
                    AsyncTableRenderingViewer.this.removeListeners(text);
                }
            }
        });
    }

    private void removeListeners(Text text) {
        text.removeFocusListener((FocusListener)this.fEditorFocusListener);
        text.removeKeyListener((KeyListener)this.fEditorKeyListener);
    }

    private void modifyValue(int row, int col, String newValue) throws NumberFormatException {
        if (newValue.length() == 0) {
            return;
        }
        TableItem tableItem = this.getTable().getItem(row);
        Object property = this.getColumnProperties()[col];
        this.getCellModifier().modify((Object)tableItem, (String)property, (Object)newValue);
    }

    public TableCursor getCursor() {
        return this.fTableCursor;
    }

    public IBaseLabelProvider getLabelProvider() {
        return new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                int idx = AsyncTableRenderingViewer.this.getContentManager().indexOfElement(element);
                if (idx >= 0) {
                    TableItem item = AsyncTableRenderingViewer.this.getTable().getItem(idx);
                    return item.getText(columnIndex);
                }
                return "";
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        };
    }

    public void formatViewer() {
        this.preservingSelection(new Runnable(){

            public void run() {
                AsynchronousTableViewerContentManager mgr = AsyncTableRenderingViewer.this.getContentManager();
                if (mgr instanceof IVirtualContentManager) {
                    ((IVirtualContentManager)((Object)mgr)).handleViewerChanged();
                }
            }
        });
    }

    private void fireSelectionChanged(Object selectionKey) {
        SelectionChangedEvent evt = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)new StructuredSelection(selectionKey));
        this.fireSelectionChanged(evt);
    }

    public void handlePresentationFailure(IAsynchronousRequestMonitor monitor, IStatus status) {
        super.handlePresentationFailure(monitor, status);
    }
}

