/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.views.memory.renderings.AbstractBaseTableRendering;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class CopyTableRenderingToClipboardAction
extends Action {
    private final String COLUMN_SEPERATOR = "  ";
    private AbstractBaseTableRendering fRendering;
    private StructuredViewer fViewer;

    public CopyTableRenderingToClipboardAction(AbstractBaseTableRendering rendering, StructuredViewer viewer) {
        this.fRendering = rendering;
        this.fViewer = viewer;
        this.setText(DebugUIMessages.CopyViewToClipboardAction_title);
        this.setToolTipText(DebugUIMessages.CopyViewToClipboardAction_tooltip);
        this.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_ELCL_COPY_VIEW_TO_CLIPBOARD"));
        this.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_LCL_COPY_VIEW_TO_CLIPBOARD"));
        this.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_DLCL_COPY_VIEW_TO_CLIPBOARD"));
    }

    private String concatenateTableAsString(TableItem[] itemList) {
        if (itemList.length == 0) {
            return null;
        }
        StringBuffer tableContents = new StringBuffer();
        Table table = (Table)this.fViewer.getControl();
        int numColumns = table.getColumnCount();
        ITableLabelProvider labelProvider = (ITableLabelProvider)this.fViewer.getLabelProvider();
        TableColumn[] columns = table.getColumns();
        String label = this.fRendering.getLabel();
        tableContents.append(label);
        tableContents.append(System.getProperty("line.separator"));
        tableContents.append("  ");
        int charsPerByte = this.fRendering.getNumCharsPerByte();
        if (charsPerByte < 0) {
            charsPerByte = 4;
        }
        int k = 0;
        while (k < numColumns) {
            StringBuffer columnLabel = new StringBuffer(columns[k].getText());
            int numBytes = 0;
            int numChars = 0;
            if (k > 0) {
                numBytes = this.fRendering.getBytesPerColumn();
                numChars = numBytes * charsPerByte;
            } else {
                IMemoryBlock memBlock = this.fRendering.getMemoryBlock();
                if (memBlock instanceof IMemoryBlockExtension) {
                    try {
                        numBytes = ((IMemoryBlockExtension)memBlock).getAddressSize();
                    }
                    catch (DebugException debugException) {
                        numBytes = 0;
                    }
                    if (numBytes <= 0) {
                        numBytes = 4;
                    }
                } else {
                    numBytes = 4;
                }
                numChars = numBytes * 2;
            }
            while (columnLabel.length() < numChars) {
                columnLabel.append(" ");
            }
            tableContents.append(columnLabel);
            tableContents.append("  ");
            ++k;
        }
        tableContents.append(System.getProperty("line.separator"));
        int i = 0;
        while (i < itemList.length) {
            int j = 0;
            while (j < numColumns) {
                tableContents.append("  ");
                StringBuffer temp = new StringBuffer(labelProvider.getColumnText(itemList[i].getData(), j));
                if (j > 0) {
                    int numBytes = this.fRendering.getBytesPerColumn();
                    int numChars = numBytes * charsPerByte;
                    while (temp.length() < numChars) {
                        temp.append(" ");
                    }
                }
                tableContents.append(temp);
                ++j;
            }
            tableContents.append(System.getProperty("line.separator"));
            ++i;
        }
        return tableContents.toString();
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 133->137)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

