/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.variables;

import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.internal.ui.model.viewers.AsynchronousTreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.TreePath;
import org.eclipse.debug.internal.ui.views.AbstractViewerState;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ViewerState
extends AbstractViewerState {
    public ViewerState(AsynchronousTreeModelViewer viewer) {
        super(viewer);
    }

    protected IPath encodeElement(TreeItem item) throws DebugException {
        StringBuffer path = new StringBuffer(item.getText());
        TreeItem parent = item.getParentItem();
        while (parent != null) {
            path.insert(0, String.valueOf(parent.getText()) + '/');
            parent = parent.getParentItem();
        }
        return new Path(path.toString());
    }

    protected TreePath decodePath(IPath path, AsynchronousTreeModelViewer viewer) throws DebugException {
        String[] names = path.segments();
        Tree tree = viewer.getTree();
        TreeItem[] items = tree.getItems();
        ArrayList<Object> elements = new ArrayList<Object>();
        elements.add(viewer.getInput());
        boolean pathFound = false;
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            TreeItem item = this.findItem(name, items);
            if (item != null) {
                pathFound = true;
                elements.add(item.getData());
                items = item.getItems();
            }
            ++i;
        }
        if (pathFound) {
            return new TreePath(elements.toArray());
        }
        return null;
    }

    private TreeItem findItem(String name, TreeItem[] items) {
        int i = 0;
        while (i < items.length) {
            TreeItem item = items[i];
            if (item.getText().equals(name)) {
                return item;
            }
            ++i;
        }
        return null;
    }
}

