/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.IOpenEventListener;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.history.IFileHistory;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.ITag;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.filehistory.CVSFileHistory;
import org.eclipse.team.internal.ccvs.core.filehistory.CVSFileRevision;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.ui.CVSHistoryFilterAction;
import org.eclipse.team.internal.ccvs.ui.CVSHistoryPage;
import org.eclipse.team.internal.ccvs.ui.CVSHistoryTableProvider;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.TextViewerAction;
import org.eclipse.team.internal.ccvs.ui.actions.CVSAction;
import org.eclipse.team.internal.ccvs.ui.actions.CompareRevisionAction;
import org.eclipse.team.internal.ccvs.ui.actions.MoveRemoteTagAction;
import org.eclipse.team.internal.ccvs.ui.actions.OpenRevisionAction;
import org.eclipse.team.internal.ccvs.ui.operations.ITagOperation;
import org.eclipse.team.internal.ccvs.ui.operations.TagInRepositoryOperation;
import org.eclipse.team.internal.ccvs.ui.operations.UpdateOperation;
import org.eclipse.team.internal.core.LocalFileRevision;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.history.DialogHistoryPageSite;
import org.eclipse.team.internal.ui.history.FileRevisionTypedElement;
import org.eclipse.team.internal.ui.history.TypedBufferedContent;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.team.ui.history.IHistoryCompareAdapter;
import org.eclipse.team.ui.history.IHistoryPageSite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class CVSHistoryPage
extends HistoryPage
implements IAdaptable,
IHistoryCompareAdapter {
    ICVSFile file;
    IFileRevision currentFileRevision;
    CVSFileHistory cvsFileHistory;
    IFileRevision[] entries;
    protected CVSHistoryTableProvider historyTableProvider;
    TableViewer tableViewer;
    protected TextViewer textViewer;
    protected TableViewer tagViewer;
    CompareRevisionAction compareAction;
    OpenRevisionAction openAction;
    private CVSHistoryFilterAction cvsHistoryFilter;
    private IAction toggleTextAction;
    private IAction toggleTextWrapAction;
    private IAction toggleListAction;
    private IAction toggleCompareAction;
    private IAction toggleOpenAction;
    private TextViewerAction copyAction;
    private TextViewerAction selectAllAction;
    private Action getContentsAction;
    private Action getRevisionAction;
    private Action refreshAction;
    private Action localHistoryFilterAction;
    private Action tagWithExistingAction;
    private SashForm sashForm;
    private SashForm innerSashForm;
    private Image branchImage;
    private Image versionImage;
    protected IFileRevision currentSelection;
    protected RefreshCVSFileHistory refreshCVSFileHistoryJob;
    private IHistoryPageSite parentSite;
    boolean shutdown = false;
    boolean localFilteredOut = false;
    private HistoryResourceListener resourceListener;
    public static final String PREF_GENERIC_HISTORYVIEW_SHOW_COMMENTS = "pref_generichistory_show_comments";
    public static final String PREF_GENERIC_HISTORYVIEW_WRAP_COMMENTS = "pref_generichistory_wrap_comments";
    public static final String PREF_GENERIC_HISTORYVIEW_SHOW_TAGS = "pref_generichistory_show_tags";
    public static final int COMPARE_CLICK = 0;
    public static final int OPEN_CLICK = 1;
    private int clickAction = 1;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CVSHistoryPage(Object object) {
        this.file = this.getCVSFile(object);
    }

    public void createControl(Composite parent) {
        this.initializeImages();
        this.sashForm = new SashForm(parent, 512);
        this.sashForm.setLayoutData((Object)new GridData(1808));
        this.tableViewer = this.createTable((Composite)this.sashForm);
        this.innerSashForm = new SashForm((Composite)this.sashForm, 256);
        this.tagViewer = this.createTagTable(this.innerSashForm);
        this.textViewer = this.createText(this.innerSashForm);
        this.sashForm.setWeights(new int[]{70, 30});
        this.innerSashForm.setWeights(new int[]{50, 50});
        this.contributeActions();
        this.setViewerVisibility();
        if (this.parentSite != null && this.parentSite instanceof DialogHistoryPageSite && this.tableViewer != null) {
            this.parentSite.setSelectionProvider((ISelectionProvider)this.tableViewer);
        }
        this.resourceListener = new HistoryResourceListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceListener, 1);
    }

    private TextViewer createText(SashForm parent) {
        TextViewer result = new TextViewer((Composite)parent, 2826);
        result.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CVSHistoryPage.this.copyAction.update();
            }
        });
        return result;
    }

    private TableViewer createTagTable(SashForm parent) {
        Table table = new Table((Composite)parent, 68352);
        TableViewer result = new TableViewer(table);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        table.setLayout((Layout)layout);
        result.setContentProvider((IContentProvider)new SimpleContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement == null) {
                    return new Object[0];
                }
                Object[] tags = (ITag[])inputElement;
                return tags;
            }
        });
        result.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element == null) {
                    return null;
                }
                ITag tag = (ITag)element;
                if (!(tag instanceof CVSTag)) {
                    return null;
                }
                switch (((CVSTag)tag).getType()) {
                    case 0: 
                    case 1: {
                        return CVSHistoryPage.this.branchImage;
                    }
                    case 2: {
                        return CVSHistoryPage.this.versionImage;
                    }
                }
                return null;
            }

            public String getText(Object element) {
                return ((ITag)element).getName();
            }
        });
        result.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                int type2;
                if (!(e1 instanceof ITag) || !(e2 instanceof ITag)) {
                    return super.compare(viewer, e1, e2);
                }
                CVSTag tag1 = (CVSTag)e1;
                CVSTag tag2 = (CVSTag)e2;
                int type1 = tag1.getType();
                if (type1 != (type2 = tag2.getType())) {
                    return type2 - type1;
                }
                return super.compare(viewer, (Object)tag1, (Object)tag2);
            }
        });
        return result;
    }

    public void setFocus() {
        this.sashForm.setFocus();
    }

    protected void contributeActions() {
        IActionBars actionBars;
        IMenuManager actionBarsMenu;
        CVSUIPlugin plugin = CVSUIPlugin.getPlugin();
        this.refreshAction = new Action(CVSUIMessages.HistoryView_refreshLabel, plugin.getImageDescriptor("elcl16/refresh.gif")){

            public void run() {
                CVSHistoryPage.this.refresh();
            }
        };
        this.refreshAction.setToolTipText(CVSUIMessages.HistoryView_refresh);
        this.refreshAction.setDisabledImageDescriptor(plugin.getImageDescriptor("dlcl16/refresh.gif"));
        this.refreshAction.setHoverImageDescriptor(plugin.getImageDescriptor("elcl16/refresh.gif"));
        this.localHistoryFilterAction = new Action("Local Filter", plugin.getImageDescriptor("elcl16/clear_co.gif")){

            public void run() {
                CVSHistoryPage.this.setLocalHistoryFilteredOut(this.isChecked());
            }
        };
        this.localHistoryFilterAction.setChecked(this.isLocalHistoryFilteredOut());
        this.localHistoryFilterAction.setToolTipText(CVSUIMessages.HistoryView_refresh);
        this.localHistoryFilterAction.setDisabledImageDescriptor(plugin.getImageDescriptor("dlcl16/clear_co.gif"));
        this.localHistoryFilterAction.setHoverImageDescriptor(plugin.getImageDescriptor("elcl16/clear_co.gif"));
        this.compareAction = new CompareRevisionAction();
        this.openAction = new OpenRevisionAction();
        OpenStrategy handler = new OpenStrategy((Control)this.tableViewer.getTable());
        handler.addOpenListener(new IOpenEventListener(){

            public void handleOpen(SelectionEvent e) {
                Object tableSelection = ((StructuredSelection)CVSHistoryPage.this.tableViewer.getSelection()).getFirstElement();
                if (CVSHistoryPage.this.clickAction == 0) {
                    StructuredSelection sel = new StructuredSelection(new Object[]{CVSHistoryPage.this.getCurrentFileRevision(), tableSelection});
                    CVSHistoryPage.this.compareAction.selectionChanged(null, (ISelection)sel);
                    CVSHistoryPage.this.compareAction.run(null);
                } else if (CVSHistoryPage.this.clickAction == 1) {
                    StructuredSelection sel = new StructuredSelection(new Object[]{tableSelection});
                    CVSHistoryPage.this.openAction.selectionChanged(null, (ISelection)sel);
                    CVSHistoryPage.this.openAction.run(null);
                }
            }
        });
        this.getContentsAction = this.getContextMenuAction(CVSUIMessages.HistoryView_getContentsAction, true, new IWorkspaceRunnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask(null, 100);
                try {
                    try {
                        if (CVSHistoryPage.this.confirmOverwrite()) {
                            IStorage currentStorage = CVSHistoryPage.this.currentSelection.getStorage((IProgressMonitor)new SubProgressMonitor(monitor, 50));
                            InputStream in = currentStorage.getContents();
                            ((IFile)CVSHistoryPage.this.file.getIResource()).setContents(in, false, true, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                        }
                    }
                    catch (TeamException e) {
                        throw new CoreException(e.getStatus());
                    }
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var4_7 = null;
                }
                monitor.done();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.getContentsAction, "org.eclipse.team.cvs.ui.get_file_contents_action_context");
        this.getRevisionAction = this.getContextMenuAction(CVSUIMessages.HistoryView_getRevisionAction, true, new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ICVSRemoteFile remoteFile = (ICVSRemoteFile)CVSWorkspaceRoot.getRemoteResourceFor((ICVSResource)((CVSFileRevision)CVSHistoryPage.this.currentSelection).getCVSRemoteFile());
                try {
                    if (CVSHistoryPage.this.confirmOverwrite()) {
                        CVSTag revisionTag = new CVSTag(remoteFile.getRevision(), 2);
                        if (CVSAction.checkForMixingTags(CVSHistoryPage.this.getSite().getShell(), new IResource[]{CVSHistoryPage.this.file.getIResource()}, revisionTag)) {
                            new UpdateOperation(null, new IResource[]{CVSHistoryPage.this.file.getIResource()}, new Command.LocalOption[]{Update.IGNORE_LOCAL_CHANGES}, revisionTag).run(monitor);
                            Display.getDefault().asyncExec(new Runnable(this){
                                final /* synthetic */ 11 this$1;
                                {
                                    this.this$1 = var1_1;
                                }

                                public void run() {
                                    11.access$0(this.this$1).refresh();
                                }
                            });
                        }
                    }
                }
                catch (InvocationTargetException e) {
                    CVSException.wrapException((Exception)e);
                }
                catch (InterruptedException interruptedException) {}
            }

            static /* synthetic */ CVSHistoryPage access$0(11 var0) {
                return var0.CVSHistoryPage.this;
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.getRevisionAction, "org.eclipse.team.cvs.ui.get_file_revision_action_context");
        MoveRemoteTagAction tagActionDelegate = new MoveRemoteTagAction(){

            protected ICVSResource[] getSelectedCVSResources() {
                ICVSResource[] resources = super.getSelectedCVSResources();
                if (resources == null || resources.length == 0) {
                    ArrayList<ICVSRemoteFile> logEntrieFiles = null;
                    IStructuredSelection selection = this.getSelection();
                    if (!selection.isEmpty()) {
                        logEntrieFiles = new ArrayList<ICVSRemoteFile>();
                        Iterator elements = selection.iterator();
                        while (elements.hasNext()) {
                            Object adapter;
                            Object next = elements.next();
                            if (next instanceof CVSFileRevision) {
                                logEntrieFiles.add(((CVSFileRevision)next).getCVSRemoteFile());
                                continue;
                            }
                            if (!(next instanceof IAdaptable)) continue;
                            IAdaptable a = (IAdaptable)next;
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("org.eclipse.team.internal.ccvs.core.ICVSResource");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (!((adapter = a.getAdapter((Class)clazz)) instanceof ICVSResource)) continue;
                            logEntrieFiles.add(((ILogEntry)adapter).getRemoteFile());
                        }
                    }
                    if (logEntrieFiles != null && !logEntrieFiles.isEmpty()) {
                        return logEntrieFiles.toArray(new ICVSResource[logEntrieFiles.size()]);
                    }
                }
                return resources;
            }

            protected ITagOperation createTagOperation() {
                return new TagInRepositoryOperation(this, this.getTargetPart(), this.getSelectedRemoteResources()){
                    final /* synthetic */ 13 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void execute(IProgressMonitor monitor) throws CVSException, InterruptedException {
                        super.execute(monitor);
                        Display.getDefault().asyncExec(new Runnable(this){
                            final /* synthetic */ 14 this$2;
                            {
                                this.this$2 = var1_1;
                            }

                            public void run() {
                                if (!14.access$0(this.this$2).wasCancelled()) {
                                    13.access$0(14.access$0(this.this$2)).refresh();
                                }
                            }
                        });
                    }

                    static /* synthetic */ 13 access$0(14 var0) {
                        return var0.this$1;
                    }
                };
            }

            static /* synthetic */ CVSHistoryPage access$0(13 var0) {
                return var0.CVSHistoryPage.this;
            }
        };
        this.tagWithExistingAction = this.getContextMenuAction(CVSUIMessages.HistoryView_tagWithExistingAction, false, new IWorkspaceRunnable((IActionDelegate)tagActionDelegate){
            private final /* synthetic */ IActionDelegate val$tagActionDelegate;
            {
                this.val$tagActionDelegate = iActionDelegate;
            }

            public void run(IProgressMonitor monitor) throws CoreException {
                this.val$tagActionDelegate.selectionChanged((IAction)CVSHistoryPage.this.tagWithExistingAction, CVSHistoryPage.this.tableViewer.getSelection());
                this.val$tagActionDelegate.run((IAction)CVSHistoryPage.this.tagWithExistingAction);
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.getRevisionAction, "org.eclipse.team.cvs.ui.tag_with_existing_action_context");
        final IPreferenceStore store = TeamUIPlugin.getPlugin().getPreferenceStore();
        this.toggleTextAction = new Action(TeamUIMessages.GenericHistoryView_ShowCommentViewer){

            public void run() {
                CVSHistoryPage.this.setViewerVisibility();
                store.setValue(CVSHistoryPage.PREF_GENERIC_HISTORYVIEW_SHOW_COMMENTS, CVSHistoryPage.this.toggleTextAction.isChecked());
            }
        };
        this.toggleTextAction.setChecked(store.getBoolean(PREF_GENERIC_HISTORYVIEW_SHOW_COMMENTS));
        this.toggleTextWrapAction = new Action(TeamUIMessages.GenericHistoryView_WrapComments){

            public void run() {
                CVSHistoryPage.this.setViewerVisibility();
                store.setValue(CVSHistoryPage.PREF_GENERIC_HISTORYVIEW_WRAP_COMMENTS, CVSHistoryPage.this.toggleTextWrapAction.isChecked());
            }
        };
        this.toggleTextWrapAction.setChecked(store.getBoolean(PREF_GENERIC_HISTORYVIEW_WRAP_COMMENTS));
        this.toggleListAction = new Action(TeamUIMessages.GenericHistoryView_ShowTagViewer){

            public void run() {
                CVSHistoryPage.this.setViewerVisibility();
                store.setValue(CVSHistoryPage.PREF_GENERIC_HISTORYVIEW_SHOW_TAGS, CVSHistoryPage.this.toggleListAction.isChecked());
            }
        };
        this.toggleListAction.setChecked(store.getBoolean(PREF_GENERIC_HISTORYVIEW_SHOW_TAGS));
        this.toggleCompareAction = new Action("Compare on selection"){

            public void run() {
                CVSHistoryPage.this.toggleOpenAction.setChecked(false);
                CVSHistoryPage.this.toggleCompareAction.setChecked(true);
                CVSHistoryPage.this.clickAction = 0;
            }
        };
        this.toggleCompareAction.setChecked(false);
        this.toggleOpenAction = new Action("Open on selection"){

            public void run() {
                CVSHistoryPage.this.toggleCompareAction.setChecked(false);
                CVSHistoryPage.this.toggleOpenAction.setChecked(true);
                CVSHistoryPage.this.clickAction = 1;
            }
        };
        this.toggleOpenAction.setChecked(true);
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)this.tableViewer.getTable());
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuMgr) {
                CVSHistoryPage.this.fillTableMenu(menuMgr);
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.tableViewer.getTable().setMenu(menu);
        if (!this.parentSite.isModal()) {
            this.parentSite.getWorkbenchPartSite().registerContextMenu(menuMgr, (ISelectionProvider)this.tableViewer);
        }
        if ((actionBarsMenu = (actionBars = this.parentSite.getActionBars()).getMenuManager()) != null) {
            actionBarsMenu.add(this.toggleCompareAction);
            actionBarsMenu.add(this.toggleOpenAction);
            actionBarsMenu.add((IContributionItem)new Separator());
            actionBarsMenu.add(this.toggleTextWrapAction);
            actionBarsMenu.add((IContributionItem)new Separator());
            actionBarsMenu.add(this.toggleTextAction);
            actionBarsMenu.add(this.toggleListAction);
        }
        this.cvsHistoryFilter = new CVSHistoryFilterAction(this);
        this.cvsHistoryFilter.setImageDescriptor(CVSUIPlugin.getPlugin().getImageDescriptor("elcl16/filter_history.gif"));
        this.cvsHistoryFilter.init(this.tableViewer);
        IToolBarManager tbm = actionBars.getToolBarManager();
        tbm.add((IAction)this.localHistoryFilterAction);
        tbm.add((IAction)this.cvsHistoryFilter);
        tbm.update(false);
        this.copyAction = new TextViewerAction((ITextViewer)this.textViewer, 4);
        this.copyAction.setText(CVSUIMessages.HistoryView_copy);
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.COPY, (IAction)this.copyAction);
        this.selectAllAction = new TextViewerAction((ITextViewer)this.textViewer, 7);
        this.selectAllAction.setText(CVSUIMessages.HistoryView_selectAll);
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.SELECT_ALL, (IAction)this.selectAllAction);
        actionBars.updateActionBars();
        menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuMgr) {
                CVSHistoryPage.this.fillTextMenu(menuMgr);
            }
        });
        StyledText text = this.textViewer.getTextWidget();
        menu = menuMgr.createContextMenu((Control)text);
        text.setMenu(menu);
    }

    private boolean isLocalHistoryFilteredOut() {
        return this.localFilteredOut;
    }

    private void setLocalHistoryFilteredOut(boolean flag) {
        this.localFilteredOut = flag;
        this.refreshHistory(false);
    }

    void fillTableMenu(IMenuManager manager) {
        IStructuredSelection tempSelection;
        ISelection sel;
        manager.add((IContributionItem)new Separator("group.file"));
        if (this.file != null && !(this.file instanceof RemoteFile) && !(sel = this.tableViewer.getSelection()).isEmpty() && sel instanceof IStructuredSelection && (tempSelection = (IStructuredSelection)sel).size() == 1) {
            manager.add((IAction)this.getContentsAction);
            if (!(tempSelection.getFirstElement() instanceof LocalFileRevision)) {
                manager.add((IAction)this.getRevisionAction);
                manager.add((IContributionItem)new Separator());
                if (!this.parentSite.isModal()) {
                    manager.add((IAction)this.tagWithExistingAction);
                }
            }
        }
        if (!this.parentSite.isModal()) {
            manager.add((IContributionItem)new Separator("additions"));
            manager.add((IAction)this.refreshAction);
            manager.add((IContributionItem)new Separator("additions-end"));
        }
    }

    private void fillTextMenu(IMenuManager manager) {
        manager.add((IAction)this.copyAction);
        manager.add((IAction)this.selectAllAction);
    }

    protected TableViewer createTable(Composite parent) {
        this.historyTableProvider = new CVSHistoryTableProvider();
        TableViewer viewer = this.historyTableProvider.createTable(parent);
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (CVSHistoryPage.this.entries != null) {
                    return CVSHistoryPage.this.entries;
                }
                if (!(inputElement instanceof IFileHistory)) {
                    return new Object[0];
                }
                IFileHistory fileHistory = (IFileHistory)inputElement;
                CVSHistoryPage.this.entries = fileHistory.getFileRevisions();
                return CVSHistoryPage.this.entries;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                CVSHistoryPage.this.entries = null;
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection == null || !(selection instanceof IStructuredSelection)) {
                    CVSHistoryPage.this.textViewer.setDocument((IDocument)new Document(""));
                    CVSHistoryPage.this.tagViewer.setInput(null);
                    return;
                }
                IStructuredSelection ss = (IStructuredSelection)selection;
                if (ss.size() != 1) {
                    CVSHistoryPage.this.textViewer.setDocument((IDocument)new Document(""));
                    CVSHistoryPage.this.tagViewer.setInput(null);
                    return;
                }
                IFileRevision entry = (IFileRevision)ss.getFirstElement();
                CVSHistoryPage.this.textViewer.setDocument((IDocument)new Document(entry.getComment()));
                CVSHistoryPage.this.tagViewer.setInput((Object)entry.getTags());
            }
        });
        return viewer;
    }

    private Action getContextMenuAction(String title, final boolean needsProgressDialog, final IWorkspaceRunnable action) {
        return new Action(title){

            public void run() {
                block8: {
                    try {
                        if (CVSHistoryPage.this.file == null) {
                            return;
                        }
                        ISelection selection = CVSHistoryPage.this.tableViewer.getSelection();
                        if (!(selection instanceof IStructuredSelection)) {
                            return;
                        }
                        IStructuredSelection ss = (IStructuredSelection)selection;
                        Object o = ss.getFirstElement();
                        CVSHistoryPage.this.currentSelection = (IFileRevision)o;
                        if (needsProgressDialog) {
                            PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(this, action){
                                final /* synthetic */ 26 this$1;
                                private final /* synthetic */ IWorkspaceRunnable val$action;
                                {
                                    this.this$1 = var1_1;
                                    this.val$action = iWorkspaceRunnable;
                                }

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    try {
                                        this.val$action.run(monitor);
                                    }
                                    catch (CoreException e) {
                                        throw new InvocationTargetException(e);
                                    }
                                }
                            });
                            break block8;
                        }
                        try {
                            action.run(null);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (InvocationTargetException e) {
                        CVSUIPlugin.openError(CVSHistoryPage.this.parentSite.getShell(), null, null, e, 12);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }

            public boolean isEnabled() {
                ISelection selection = CVSHistoryPage.this.tableViewer.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return false;
                }
                IStructuredSelection ss = (IStructuredSelection)selection;
                return ss.size() == 1;
            }
        };
    }

    private boolean confirmOverwrite() {
        if (this.file != null && this.file.getIResource().exists()) {
            try {
                if (this.file.isModified(null)) {
                    String title = CVSUIMessages.HistoryView_overwriteTitle;
                    String msg = CVSUIMessages.HistoryView_overwriteMsg;
                    final MessageDialog dialog = new MessageDialog(this.parentSite.getShell(), title, null, msg, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                    final int[] result = new int[1];
                    this.parentSite.getShell().getDisplay().syncExec(new Runnable(){

                        public void run() {
                            result[0] = dialog.open();
                        }
                    });
                    if (result[0] != 0) {
                        return false;
                    }
                }
            }
            catch (CVSException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
            }
        }
        return true;
    }

    public void refresh() {
        this.refreshHistory(true);
    }

    public boolean showHistory(Object object, boolean refetch) {
        ICVSFile cvsFile;
        this.clickAction = 1;
        this.currentFileRevision = null;
        this.file = cvsFile = this.getCVSFile(object);
        if (cvsFile == null) {
            return false;
        }
        this.cvsFileHistory = new CVSFileHistory(cvsFile);
        this.cvsFileHistory.includeLocalRevisions(true);
        if (this.refreshCVSFileHistoryJob == null) {
            this.refreshCVSFileHistoryJob = new RefreshCVSFileHistory();
        }
        this.refreshHistory(refetch);
        return true;
    }

    private void refreshHistory(boolean refetch) {
        if (this.refreshCVSFileHistoryJob.getState() != 0) {
            this.refreshCVSFileHistoryJob.cancel();
        }
        this.refreshCVSFileHistoryJob.setIncludeLocals(!this.isLocalHistoryFilteredOut());
        this.refreshCVSFileHistoryJob.setFileHistory(this.cvsFileHistory);
        this.refreshCVSFileHistoryJob.setRefetchHistory(refetch);
        Utils.schedule((Job)this.refreshCVSFileHistoryJob, (IWorkbenchSite)this.parentSite.getWorkbenchPartSite());
    }

    public void selectRevision(String revision) {
        if (this.entries == null) {
            return;
        }
        IFileRevision entry = null;
        int i = 0;
        while (i < this.entries.length) {
            if (this.entries[i].getContentIdentifier().equals(revision)) {
                entry = this.entries[i];
                break;
            }
            ++i;
        }
        if (entry != null) {
            StructuredSelection selection = new StructuredSelection(entry);
            this.tableViewer.setSelection((ISelection)selection, true);
        }
    }

    private ICVSFile getCVSFile(Object object) {
        if (object instanceof IFile) {
            return CVSWorkspaceRoot.getCVSFileFor((IFile)((IFile)object));
        }
        if (object instanceof ICVSRemoteFile) {
            return (ICVSRemoteFile)object;
        }
        return null;
    }

    void setViewerVisibility() {
        boolean showText = this.toggleTextAction.isChecked();
        boolean showList = this.toggleListAction.isChecked();
        if (this.parentSite.isModal()) {
            showText = false;
            showList = false;
        }
        if (showText && showList) {
            this.sashForm.setMaximizedControl(null);
            this.innerSashForm.setMaximizedControl(null);
        } else if (showText) {
            this.sashForm.setMaximizedControl(null);
            this.innerSashForm.setMaximizedControl((Control)this.textViewer.getTextWidget());
        } else if (showList) {
            this.sashForm.setMaximizedControl(null);
            this.innerSashForm.setMaximizedControl((Control)this.tagViewer.getTable());
        } else {
            this.sashForm.setMaximizedControl(this.tableViewer.getControl());
        }
        boolean wrapText = this.toggleTextWrapAction.isChecked();
        this.textViewer.getTextWidget().setWordWrap(wrapText);
    }

    private void initializeImages() {
        CVSUIPlugin plugin = CVSUIPlugin.getPlugin();
        this.versionImage = plugin.getImageDescriptor("obj16/prjversions_rep.gif").createImage();
        this.branchImage = plugin.getImageDescriptor("obj16/tag.gif").createImage();
    }

    public void dispose() {
        this.shutdown = true;
        if (this.resourceListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceListener);
            this.resourceListener = null;
        }
        if (this.branchImage != null) {
            this.branchImage.dispose();
            this.branchImage = null;
        }
        if (this.versionImage != null) {
            this.versionImage.dispose();
            this.versionImage = null;
        }
        if (this.refreshCVSFileHistoryJob != null && this.refreshCVSFileHistoryJob.getState() != 0) {
            this.refreshCVSFileHistoryJob.cancel();
        }
    }

    private IFileRevision getCurrentFileRevision() {
        if (this.currentFileRevision != null) {
            return this.currentFileRevision;
        }
        if (this.file != null) {
            try {
                if (this.file instanceof RemoteFile) {
                    RemoteFile remote = (RemoteFile)this.file;
                    this.currentFileRevision = this.cvsFileHistory.getFileRevision(remote.getContentIdentifier());
                    return this.currentFileRevision;
                }
                IFile localFile = (IFile)this.file.getIResource();
                if (localFile != null) {
                    this.currentFileRevision = new LocalFileRevision(localFile);
                } else if (this.file.getSyncInfo() != null) {
                    this.currentFileRevision = this.cvsFileHistory.getFileRevision(this.file.getSyncInfo().getRevision());
                }
                return this.currentFileRevision;
            }
            catch (CVSException cVSException) {
            }
            catch (TeamException teamException) {}
        }
        return null;
    }

    public Control getControl() {
        return this.sashForm;
    }

    public boolean canShowHistoryFor(Object object) {
        RepositoryProvider provider;
        return object instanceof IResource ? (provider = RepositoryProvider.getProvider((IProject)((IResource)object).getProject())) instanceof CVSTeamProvider : object instanceof ICVSRemoteResource;
    }

    public String getName() {
        if (this.file != null) {
            return this.file.getName();
        }
        return "";
    }

    public void setSite(IHistoryPageSite historySite) {
        this.parentSite = historySite;
    }

    public void setSorter(boolean localDisplayed) {
        this.historyTableProvider.setLocalRevisionsDisplayed(localDisplayed);
    }

    public IHistoryPageSite getHistoryPageSite() {
        return this.parentSite;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.team.ui.history.IHistoryCompareAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this;
        }
        return null;
    }

    public ICompareInput getCompareInput(Object object) {
        Object o;
        IStructuredSelection ss;
        if (object != null && object instanceof IStructuredSelection && (ss = (IStructuredSelection)object).size() == 1 && (o = ss.getFirstElement()) instanceof IFileRevision) {
            IFileRevision selectedFileRevision = (IFileRevision)o;
            TypedBufferedContent left = new TypedBufferedContent((IFile)this.file.getIResource());
            FileRevisionTypedElement right = new FileRevisionTypedElement(selectedFileRevision);
            DiffNode node = new DiffNode((ITypedElement)left, (ITypedElement)right);
            return node;
        }
        return null;
    }

    public void setClickAction(int clickAction) {
        switch (clickAction) {
            case 0: {
                this.toggleCompareAction.run();
                break;
            }
            case 1: {
                this.toggleOpenAction.run();
            }
        }
    }

    private class RefreshCVSFileHistory
    extends Job {
        private CVSFileHistory fileHistory;

        public RefreshCVSFileHistory() {
            super(CVSUIMessages.HistoryView_fetchHistoryJob);
        }

        public void setIncludeLocals(boolean flag) {
            if (this.fileHistory != null) {
                this.fileHistory.includeLocalRevisions(flag);
            }
        }

        public void setRefetchHistory(boolean refetch) {
            if (this.fileHistory != null) {
                this.fileHistory.setRefetchRevisions(refetch);
            }
        }

        public void setFileHistory(CVSFileHistory fileHistory) {
            this.fileHistory = fileHistory;
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                if (this.fileHistory != null && !CVSHistoryPage.this.shutdown) {
                    this.fileHistory.refresh(monitor);
                    Utils.asyncExec((Runnable)new Runnable(this){
                        final /* synthetic */ RefreshCVSFileHistory this$1;
                        {
                            this.this$1 = refreshCVSFileHistory;
                        }

                        public void run() {
                            RefreshCVSFileHistory.access$1((RefreshCVSFileHistory)this.this$1).historyTableProvider.setLocalRevisionsDisplayed(RefreshCVSFileHistory.access$0(this.this$1).getIncludesExists());
                            RefreshCVSFileHistory.access$1((RefreshCVSFileHistory)this.this$1).historyTableProvider.setFile((IFileHistory)RefreshCVSFileHistory.access$0(this.this$1), RefreshCVSFileHistory.access$1((RefreshCVSFileHistory)this.this$1).file);
                            RefreshCVSFileHistory.access$1((RefreshCVSFileHistory)this.this$1).tableViewer.setInput((Object)RefreshCVSFileHistory.access$0(this.this$1));
                        }
                    }, (StructuredViewer)CVSHistoryPage.this.tableViewer);
                }
                return Status.OK_STATUS;
            }
            catch (TeamException e) {
                return e.getStatus();
            }
        }

        static /* synthetic */ CVSFileHistory access$0(RefreshCVSFileHistory refreshCVSFileHistory) {
            return refreshCVSFileHistory.fileHistory;
        }

        static /* synthetic */ CVSHistoryPage access$1(RefreshCVSFileHistory refreshCVSFileHistory) {
            return refreshCVSFileHistory.CVSHistoryPage.this;
        }
    }

    private class SimpleContentProvider
    implements IStructuredContentProvider {
        public void dispose() {
        }

        public Object[] getElements(Object element) {
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class HistoryResourceListener
    implements IResourceChangeListener {
        HistoryResourceListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta root = event.getDelta();
            if (CVSHistoryPage.this.file == null || CVSHistoryPage.this.file.getIResource() == null) {
                return;
            }
            IResourceDelta resourceDelta = root.findMember(((IFile)CVSHistoryPage.this.file.getIResource()).getFullPath());
            if (resourceDelta != null) {
                Display.getDefault().asyncExec(new Runnable(this){
                    final /* synthetic */ HistoryResourceListener this$1;
                    {
                        this.this$1 = historyResourceListener;
                    }

                    public void run() {
                        HistoryResourceListener.access$0(this.this$1).refresh();
                    }
                });
            }
        }

        static /* synthetic */ CVSHistoryPage access$0(HistoryResourceListener historyResourceListener) {
            return historyResourceListener.CVSHistoryPage.this;
        }
    }
}

