/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.actions.TeamAction;
import org.eclipse.team.internal.ui.history.FileRevisionEditorInput;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;

public class OpenRevisionAction
extends TeamAction {
    public void run(IAction action) {
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    IStructuredSelection structSel = OpenRevisionAction.this.getSelection();
                    Object[] objArray = structSel.toArray();
                    int i = 0;
                    while (i < objArray.length) {
                        IFileRevision revision = (IFileRevision)objArray[i];
                        if (!revision.exists()) {
                            MessageDialog.openError((Shell)OpenRevisionAction.this.getShell(), (String)TeamUIMessages.OpenRevisionAction_DeletedRevisionTitle, (String)TeamUIMessages.OpenRevisionAction_DeletedRevisionMessage);
                        } else {
                            IStorage file = revision.getStorage(monitor);
                            String id = OpenRevisionAction.this.getEditorID(file.getName(), file.getContents());
                            OpenRevisionAction.this.getTargetPage().openEditor((IEditorInput)new FileRevisionEditorInput(revision), id);
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }
        }, TeamUIMessages.ConfigureProjectAction_configureProject, 2);
    }

    protected boolean isEnabled() throws TeamException {
        return true;
    }

    String getEditorID(String fileName, InputStream contents) {
        IEditorDescriptor descriptor;
        IWorkbench workbench = TeamUIPlugin.getPlugin().getWorkbench();
        IEditorRegistry registry = workbench.getEditorRegistry();
        workbench.getActiveWorkbenchWindow().getActivePage();
        IContentType type = null;
        if (contents != null) {
            try {
                type = Platform.getContentTypeManager().findContentTypeFor(contents, fileName);
            }
            catch (IOException iOException) {}
        }
        if (type == null) {
            type = Platform.getContentTypeManager().findContentTypeFor(fileName);
        }
        String id = (descriptor = registry.getDefaultEditor(fileName, type)) == null ? "org.eclipse.ui.DefaultTextEditor" : descriptor.getId();
        return id;
    }
}

