/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.mappings;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffVisitor;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.diff.ITwoWayDiff;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.mappings.CVSModelProviderAction;
import org.eclipse.team.internal.ccvs.ui.wizards.GenerateDiffFileWizard;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class CreatePatchAction
extends CVSModelProviderAction {
    public CreatePatchAction(ISynchronizePageConfiguration configuration) {
        super(configuration);
    }

    protected boolean isEnabledForSelection(IStructuredSelection selection) {
        try {
            IResource[] resources = this.getVisibleResources(selection);
            return resources.length > 0;
        }
        catch (CoreException e) {
            CVSUIPlugin.log(e);
            return false;
        }
    }

    private IResource[] getVisibleResources(IStructuredSelection selection) throws CoreException {
        final HashSet resources = new HashSet();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            ResourceMapping mapping = Utils.getResourceMapping(element);
            if (mapping == null) continue;
            ResourceTraversal[] traversals = mapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, null);
            final IResourceDiffTree diffTree = this.getSynchronizationContext().getDiffTree();
            diffTree.accept(new IDiffVisitor(){

                public boolean visit(IDiff delta) throws CoreException {
                    IThreeWayDiff twd;
                    ITwoWayDiff local;
                    IResource resource = diffTree.getResource(delta);
                    if (resource.getType() == 1 && delta instanceof IThreeWayDiff && (local = (twd = (IThreeWayDiff)delta).getLocalChange()) != null && local.getKind() != 0) {
                        resources.add(resource);
                    }
                    return true;
                }
            }, traversals);
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    protected String getBundleKeyPrefix() {
        return "GenerateDiffFileAction.";
    }

    public void run() {
        try {
            IResource[] resources = this.getVisibleResources(this.getStructuredSelection());
            GenerateDiffFileWizard.run(this.getConfiguration().getSite().getPart(), resources, false);
        }
        catch (CoreException e) {
            CVSUIPlugin.openError(this.getConfiguration().getSite().getShell(), null, null, e);
        }
    }
}

