/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.mappings;

import java.util.ResourceBundle;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.MergeContext;
import org.eclipse.team.core.mapping.provider.SynchronizationContext;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberScopeManager;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.actions.BranchAction;
import org.eclipse.team.internal.ccvs.ui.actions.IgnoreAction;
import org.eclipse.team.internal.ccvs.ui.actions.SetKeywordSubstitutionAction;
import org.eclipse.team.internal.ccvs.ui.actions.ShowAnnotationAction;
import org.eclipse.team.internal.ccvs.ui.actions.ShowResourceInHistoryAction;
import org.eclipse.team.internal.ccvs.ui.mappings.CommitAction;
import org.eclipse.team.internal.ccvs.ui.mappings.CreatePatchAction;
import org.eclipse.team.internal.ccvs.ui.mappings.WorkspaceCommitAction;
import org.eclipse.team.internal.ccvs.ui.mappings.WorkspaceSubscriberContext;
import org.eclipse.team.internal.ccvs.ui.subscriber.CVSActionDelegateWrapper;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipantActionGroup;

public class WorkspaceModelParticipant
extends ModelSynchronizeParticipant {
    public static final String VIEWER_ID = "org.eclipse.team.cvs.ui.workspaceSynchronization";
    public static final String CONTEXT_MENU_UPDATE_GROUP_1 = "update";
    public static final String CONTEXT_MENU_COMMIT_GROUP_1 = "commit";
    public static final String CONTEXT_MENU_CONTRIBUTION_GROUP_2 = "overrideActions";
    public static final String CONTEXT_MENU_CONTRIBUTION_GROUP_3 = "otherActions1";
    public static final String CONTEXT_MENU_CONTRIBUTION_GROUP_4 = "otherActions2";
    public static final String ID = "org.eclipse.team.cvs.ui.workspace-participant";

    public WorkspaceModelParticipant() {
    }

    public WorkspaceModelParticipant(SynchronizationContext context) {
        super(context);
        try {
            this.setInitializationData(TeamUI.getSynchronizeManager().getParticipantDescriptor(ID));
        }
        catch (CoreException e) {
            TeamUIPlugin.log((CoreException)e);
        }
        this.setSecondaryId(Long.toString(System.currentTimeMillis()));
    }

    protected void initializeConfiguration(ISynchronizePageConfiguration configuration) {
        configuration.setProperty("org.eclipse.team.ui.P_VIEWER_ID", (Object)VIEWER_ID);
        super.initializeConfiguration(configuration);
    }

    protected ModelSynchronizeParticipantActionGroup createMergeActionGroup() {
        return new WorkspaceMergeActionGroup();
    }

    protected MergeContext restoreContext(ISynchronizationScopeManager manager) {
        return WorkspaceSubscriberContext.createContext(manager, 3);
    }

    protected ISynchronizationScopeManager createScopeManager(ResourceMapping[] mappings) {
        return new SubscriberScopeManager(mappings, (Subscriber)CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber(), true);
    }

    public class WorkspaceMergeActionGroup
    extends ModelSynchronizeParticipantActionGroup {
        private WorkspaceCommitAction commitToolbar;

        public void initialize(ISynchronizePageConfiguration configuration) {
            super.initialize(configuration);
            int modes = configuration.getSupportedModes();
            if ((modes & 6) != 0) {
                this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", WorkspaceModelParticipant.CONTEXT_MENU_COMMIT_GROUP_1, (IAction)new CommitAction(configuration));
                this.commitToolbar = new WorkspaceCommitAction(configuration);
                Utils.initAction((IAction)this.commitToolbar, (String)"WorkspaceToolbarCommitAction.", (ResourceBundle)Policy.getActionBundle());
                this.appendToGroup("org.eclipse.team.ui.P_TOOLBAR_MENU", "merge", (IAction)this.commitToolbar);
                this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", WorkspaceModelParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_3, (IAction)new CVSActionDelegateWrapper(new IgnoreAction(), configuration));
            }
            if (!configuration.getSite().isModal()) {
                this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", WorkspaceModelParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_3, (IAction)new CreatePatchAction(configuration));
                this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", WorkspaceModelParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_3, (IAction)new CVSActionDelegateWrapper(new BranchAction(), configuration));
                this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", WorkspaceModelParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_3, (IAction)new CVSActionDelegateWrapper(new ShowAnnotationAction(), configuration));
                this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", WorkspaceModelParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_3, (IAction)new CVSActionDelegateWrapper(new ShowResourceInHistoryAction(), configuration));
                this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", WorkspaceModelParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_3, (IAction)new CVSActionDelegateWrapper(new SetKeywordSubstitutionAction(), configuration));
            }
        }

        protected void configureMergeAction(String mergeActionId, Action action) {
            if (mergeActionId == "org.eclipse.team.ui.mergeAction") {
                Utils.initAction((IAction)action, (String)"WorkspaceUpdateAction.", (ResourceBundle)Policy.getActionBundle());
            } else if (mergeActionId == "org.eclipse.team.ui.overwriteAction") {
                Utils.initAction((IAction)action, (String)"OverrideAndUpdateAction.", (ResourceBundle)Policy.getActionBundle());
            } else if (mergeActionId == "org.eclipse.team.ui.markAsMergeAction") {
                Utils.initAction((IAction)action, (String)"ConfirmMergedAction.", (ResourceBundle)Policy.getActionBundle());
            } else if (mergeActionId == "org.eclipse.team.ui.mergeAll") {
                Utils.initAction((IAction)action, (String)"WorkspaceToolbarUpdateAction.", (ResourceBundle)Policy.getActionBundle());
            } else {
                super.configureMergeAction(mergeActionId, action);
            }
        }

        protected void addToContextMenu(String mergeActionId, Action action, IMenuManager manager) {
            IContributionItem group = null;
            if (mergeActionId == "org.eclipse.team.ui.mergeAction") {
                group = manager.find(WorkspaceModelParticipant.CONTEXT_MENU_UPDATE_GROUP_1);
            } else if (mergeActionId == "org.eclipse.team.ui.overwriteAction") {
                group = manager.find(WorkspaceModelParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_2);
            } else if (mergeActionId == "org.eclipse.team.ui.markAsMergeAction") {
                group = manager.find(WorkspaceModelParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_2);
            } else {
                super.addToContextMenu(mergeActionId, action, manager);
                return;
            }
            if (group != null) {
                manager.appendToGroup(group.getId(), (IAction)action);
            } else {
                manager.add((IAction)action);
            }
        }
    }
}

