/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.ICVSRunnable;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.connection.CVSServerException;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.MutableFolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.actions.CVSAction;
import org.eclipse.team.internal.ccvs.ui.operations.RepositoryProviderOperation;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryManager;
import org.eclipse.team.internal.ccvs.ui.tags.BranchPromptDialog;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class BranchOperation
extends RepositoryProviderOperation {
    private boolean update;
    private CVSTag rootVersionTag;
    private CVSTag branchTag;

    public BranchOperation(IWorkbenchPart part, ResourceMapping[] mappers) {
        super(part, mappers);
    }

    public void setTags(CVSTag rootVersionTag, CVSTag branchTag, boolean updateToBranch) {
        this.rootVersionTag = rootVersionTag;
        this.branchTag = branchTag;
        this.update = updateToBranch;
    }

    protected boolean shouldRun() {
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        BranchOperation.this.buildScope(monitor);
                    }
                    catch (CVSException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e1) {
            CVSUIPlugin.openError(this.getShell(), null, null, e1);
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException();
        }
        IResource[] resources = this.getTraversalRoots();
        boolean allSticky = this.areAllResourcesSticky(resources);
        String initialVersionName = this.calculateInitialVersionName(resources, allSticky);
        BranchPromptDialog dialog = new BranchPromptDialog(this.getShell(), CVSUIMessages.BranchWizard_title, resources, allSticky, initialVersionName);
        if (dialog.open() != 0) {
            return false;
        }
        String tagString = dialog.getBranchTagName();
        this.update = dialog.getUpdate();
        this.branchTag = new CVSTag(tagString, 1);
        String versionString = dialog.getVersionTagName();
        if (!(versionString == null || initialVersionName != null && versionString.equals(initialVersionName))) {
            this.rootVersionTag = new CVSTag(versionString, 2);
        }
        if (this.update) {
            try {
                if (!CVSAction.checkForMixingTags(this.getShell(), resources, this.branchTag)) {
                    return false;
                }
            }
            catch (CVSException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
            }
        }
        return super.shouldRun();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute(CVSTeamProvider provider, IResource[] providerResources, boolean recurse, IProgressMonitor monitor) throws CVSException, InterruptedException {
        try {
            try {
                monitor.beginTask(null, 100);
                this.makeBranch(provider, providerResources, this.rootVersionTag, this.branchTag, this.update, recurse, Policy.subMonitorFor(monitor, 90));
                this.updateRememberedTags(providerResources);
                if (this.update) {
                    this.updateWorkspaceSubscriber(provider, this.getCVSArguments(providerResources), recurse, Policy.subMonitorFor(monitor, 10));
                }
                this.collectStatus(Status.OK_STATUS);
            }
            catch (TeamException e) {
                this.collectStatus(e.getStatus());
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void makeBranch(CVSTeamProvider provider, IResource[] resources, CVSTag versionTag, CVSTag branchTag, boolean moveToBranch, boolean recurse, IProgressMonitor monitor) throws TeamException {
        int totalWork = (versionTag != null ? 60 : 40) + (moveToBranch ? 20 : 0);
        monitor.beginTask(CVSUIMessages.CVSTeamProvider_makeBranch, totalWork);
        try {
            IStatus status;
            block14: {
                Command.LocalOption[] localOptions;
                ICVSResource[] arguments;
                block15: {
                    Object var13_18;
                    arguments = this.getCVSArguments(resources);
                    localOptions = this.getLocalOptions(recurse);
                    status = null;
                    if (versionTag == null) break block15;
                    Session session = new Session(this.getRemoteLocation(provider), this.getLocalRoot(provider), true);
                    session.open(Policy.subMonitorFor(monitor, 5), true);
                    try {
                        status = Command.CUSTOM_TAG.execute(session, Command.NO_GLOBAL_OPTIONS, localOptions, versionTag, arguments, null, Policy.subMonitorFor(monitor, 35));
                    }
                    catch (Throwable throwable) {
                        Object var13_17 = null;
                        session.close();
                        throw throwable;
                    }
                    {
                        var13_18 = null;
                    }
                    session.close();
                    if (!status.isOK()) break block14;
                    session = new Session(this.getRemoteLocation(provider), this.getLocalRoot(provider), true);
                    session.open(Policy.subMonitorFor(monitor, 5), true);
                    try {
                        status = Command.CUSTOM_TAG.execute(session, Command.NO_GLOBAL_OPTIONS, localOptions, branchTag, arguments, null, Policy.subMonitorFor(monitor, 15));
                    }
                    catch (Throwable throwable) {
                        var13_18 = null;
                        session.close();
                        throw throwable;
                    }
                    {
                        var13_18 = null;
                        session.close();
                        break block14;
                    }
                }
                Session session = new Session(this.getRemoteLocation(provider), this.getLocalRoot(provider), true);
                session.open(Policy.subMonitorFor(monitor, 5), true);
                try {
                    status = Command.CUSTOM_TAG.execute(session, Command.NO_GLOBAL_OPTIONS, localOptions, branchTag, arguments, null, Policy.subMonitorFor(monitor, 35));
                }
                catch (Throwable throwable) {
                    Object var13_19 = null;
                    session.close();
                    throw throwable;
                }
                {
                    Object var13_20 = null;
                }
                session.close();
            }
            if (!status.isOK()) {
                throw new CVSServerException(status);
            }
            if (moveToBranch) {
                this.setTag(provider, resources, branchTag, recurse, Policy.subMonitorFor(monitor, 20));
            }
        }
        catch (Throwable throwable) {
            Object var15_22 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var15_23 = null;
        }
        monitor.done();
    }

    private void setTag(final CVSTeamProvider provider, final IResource[] resources, final CVSTag tag, final boolean recurse, IProgressMonitor monitor) throws TeamException {
        this.getLocalRoot(provider).run(new ICVSRunnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor progress) throws CVSException {
                try {
                    progress.beginTask(null, 100);
                    IProgressMonitor monitor = Policy.infiniteSubMonitorFor(progress, 100);
                    monitor.beginTask(NLS.bind((String)CVSUIMessages.CVSTeamProvider_folderInfo, (Object[])new String[]{provider.getProject().getName()}), 512);
                    int i = 0;
                    while (i < resources.length) {
                        CVSWorkspaceRoot.getCVSResourceFor((IResource)resources[i]).accept(new ICVSResourceVisitor(this, monitor, tag){
                            final /* synthetic */ 2 this$1;
                            private final /* synthetic */ IProgressMonitor val$monitor;
                            private final /* synthetic */ CVSTag val$tag;
                            {
                                this.this$1 = var1_1;
                                this.val$monitor = iProgressMonitor;
                                this.val$tag = cVSTag;
                            }

                            public void visitFile(ICVSFile file) throws CVSException {
                                this.val$monitor.worked(1);
                                byte[] syncBytes = file.getSyncBytes();
                                if (syncBytes != null) {
                                    this.val$monitor.subTask(NLS.bind((String)CVSUIMessages.CVSTeamProvider_updatingFile, (Object[])new String[]{file.getName()}));
                                    file.setSyncBytes(ResourceSyncInfo.setTag((byte[])syncBytes, (CVSTag)this.val$tag), 0);
                                }
                            }

                            public void visitFolder(ICVSFolder folder) throws CVSException {
                                this.val$monitor.worked(1);
                                FolderSyncInfo info = folder.getFolderSyncInfo();
                                if (info != null) {
                                    this.val$monitor.subTask(NLS.bind((String)CVSUIMessages.CVSTeamProvider_updatingFolder, (Object[])new String[]{info.getRepository()}));
                                    MutableFolderSyncInfo newInfo = info.cloneMutable();
                                    newInfo.setTag(this.val$tag);
                                    folder.setFolderSyncInfo((FolderSyncInfo)newInfo);
                                }
                            }
                        }, recurse);
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    progress.done();
                    throw throwable;
                }
                {
                    Object var4_6 = null;
                }
                progress.done();
            }
        }, monitor);
    }

    private void updateRememberedTags(IResource[] providerResources) throws CVSException {
        if (this.rootVersionTag != null || this.update) {
            int i = 0;
            while (i < providerResources.length) {
                ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)providerResources[i]);
                RepositoryManager manager = CVSUIPlugin.getPlugin().getRepositoryManager();
                if (this.rootVersionTag != null) {
                    manager.addTags(cvsResource, new CVSTag[]{this.rootVersionTag});
                }
                if (this.update) {
                    manager.addTags(cvsResource, new CVSTag[]{this.branchTag});
                }
                ++i;
            }
        }
    }

    protected String getTaskName() {
        return CVSUIMessages.BranchOperation_0;
    }

    protected String getTaskName(CVSTeamProvider provider) {
        return NLS.bind((String)CVSUIMessages.BranchOperation_1, (Object[])new String[]{provider.getProject().getName()});
    }

    private boolean areAllResourcesSticky(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            if (!this.hasStickyTag(resources[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean hasStickyTag(IResource resource) {
        try {
            int tagType;
            CVSTag tag;
            ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
            if (cvsResource.isFolder()) {
                FolderSyncInfo folderInfo = ((ICVSFolder)cvsResource).getFolderSyncInfo();
                tag = folderInfo.getTag();
            } else {
                ResourceSyncInfo info = cvsResource.getSyncInfo();
                tag = info.getTag();
            }
            if (tag != null && (tagType = tag.getType()) == 2) {
                return true;
            }
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
            return false;
        }
        return false;
    }

    private String calculateInitialVersionName(IResource[] resources, boolean allSticky) {
        String versionName = "";
        try {
            if (allSticky) {
                IResource stickyResource = resources[0];
                if (stickyResource.getType() == 1) {
                    ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)((IFile)stickyResource));
                    versionName = cvsFile.getSyncInfo().getTag().getName();
                } else {
                    ICVSFolder cvsFolder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)((IContainer)stickyResource));
                    versionName = cvsFolder.getFolderSyncInfo().getTag().getName();
                }
            }
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
            versionName = "";
        }
        return versionName;
    }
}

