/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Diff;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.listeners.DiffListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.SingleCommandOperation;
import org.eclipse.ui.IWorkbenchPart;

public abstract class DiffOperation
extends SingleCommandOperation {
    private static final int UNIFIED_FORMAT = 0;
    private static final int CONTEXT_FORMAT = 1;
    private static final int STANDARD_FORMAT = 2;
    protected boolean isMultiPatch;
    protected boolean includeFullPathInformation;
    protected PrintStream stream;
    protected IPath patchRoot;
    protected boolean patchHasContents;
    protected boolean patchHasNewFiles;

    public DiffOperation(IWorkbenchPart part, ResourceMapping[] mappings, Command.LocalOption[] options, boolean isMultiPatch, boolean includeFullPathInformation, IPath patchRoot) {
        super(part, mappings, options);
        this.isMultiPatch = isMultiPatch;
        this.includeFullPathInformation = includeFullPathInformation;
        this.patchRoot = patchRoot;
        this.patchHasContents = false;
        this.patchHasNewFiles = false;
    }

    /*
     * Exception decompiling
     */
    public void execute(IProgressMonitor monitor) throws CVSException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 55->59)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected abstract PrintStream openStream() throws CVSException;

    protected void execute(CVSTeamProvider provider, IResource[] resources, boolean recurse, IProgressMonitor monitor) throws CVSException, InterruptedException {
        IProject project;
        final HashSet newFiles = new HashSet();
        final HashSet existingFiles = new HashSet();
        monitor.beginTask(null, 100);
        final IProgressMonitor subMonitor = Policy.subMonitorFor(monitor, 10);
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
            cvsResource.accept(new ICVSResourceVisitor(){

                public void visitFile(ICVSFile file) throws CVSException {
                    if (!file.isIgnored()) {
                        if (!file.isManaged() || file.getSyncInfo().isAdded()) {
                            if (file.exists()) {
                                newFiles.add(file);
                            }
                        } else if (file.isModified(subMonitor)) {
                            existingFiles.add(file.getIResource());
                        }
                    }
                }

                public void visitFolder(ICVSFolder folder) throws CVSException {
                    if (!folder.exists() || folder.isIgnored()) {
                        return;
                    }
                    folder.acceptChildren((ICVSResourceVisitor)this);
                }
            }, recurse);
            ++i;
        }
        subMonitor.done();
        int format = 2;
        Command.LocalOption[] localoptions = this.getLocalOptions(recurse);
        int i2 = 0;
        while (i2 < localoptions.length) {
            Command.LocalOption option = localoptions[i2];
            if (option.equals((Object)Diff.UNIFIED_FORMAT) || this.isMultiPatch) {
                format = 0;
            } else if (option.equals((Object)Diff.CONTEXT_FORMAT)) {
                format = 1;
            }
            ++i2;
        }
        boolean haveAddedProjectHeader = false;
        if (!existingFiles.isEmpty()) {
            if (this.isMultiPatch && !haveAddedProjectHeader) {
                haveAddedProjectHeader = true;
                project = resources[0].getProject();
                this.stream.println("#P " + project.getName());
            }
            try {
                super.execute(provider, existingFiles.toArray(new IResource[existingFiles.size()]), recurse, Policy.subMonitorFor(monitor, 90));
            }
            catch (CVSException cVSException) {}
        }
        if (!newFiles.isEmpty() && Diff.INCLUDE_NEWFILES.isElementOf((Command.Option[])localoptions)) {
            this.patchHasNewFiles = true;
            if (this.isMultiPatch && !haveAddedProjectHeader) {
                haveAddedProjectHeader = true;
                project = resources[0].getProject();
                this.stream.println("#P " + project.getName());
            }
            Iterator iter = newFiles.iterator();
            while (iter.hasNext()) {
                ICVSFile cvsFile = (ICVSFile)iter.next();
                this.addFileToDiff(CVSWorkspaceRoot.getCVSFolderFor((IContainer)cvsFile.getIResource().getProject()), cvsFile, this.stream, format);
            }
        }
        monitor.done();
    }

    protected IStatus executeCommand(Session session, CVSTeamProvider provider, ICVSResource[] resources, boolean recurse, IProgressMonitor monitor) throws CVSException, InterruptedException {
        DiffListener diffListener = new DiffListener(this.stream);
        Command.DIFF.execute(session, Command.NO_GLOBAL_OPTIONS, this.getLocalOptions(recurse), resources, (ICommandOutputListener)diffListener, monitor);
        if (!this.patchHasContents) {
            this.patchHasContents = diffListener.wroteToStream();
        }
        return OK;
    }

    protected String getTaskName(CVSTeamProvider provider) {
        return NLS.bind((String)CVSUIMessages.DiffOperation_0, (Object[])new String[]{provider.getProject().getName()});
    }

    protected String getTaskName() {
        return CVSUIMessages.DiffOperation_1;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addFileToDiff(ICVSFolder cmdRoot, ICVSFile file, PrintStream printStream, int format) throws CVSException {
        Object var13_18;
        String nullFilePrefix = "";
        String newFilePrefix = "";
        String positionInfo = "";
        String linePrefix = "";
        String pathString = "";
        pathString = file.getRelativePath(cmdRoot);
        int lines = 0;
        BufferedReader fileReader = new BufferedReader(new InputStreamReader(file.getContents()));
        try {
            try {
                while (fileReader.readLine() != null) {
                    ++lines;
                }
            }
            catch (IOException e) {
                throw CVSException.wrapException((IResource)file.getIResource(), (String)NLS.bind((String)CVSMessages.CVSTeamProvider_errorAddingFileToDiff, (Object[])new String[]{pathString}), (IOException)e);
            }
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            try {
                fileReader.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            var13_18 = null;
        }
        try {}
        catch (IOException iOException) {}
        fileReader.close();
        if (lines == 0) {
            return;
        }
        switch (format) {
            case 0: {
                nullFilePrefix = "--- ";
                newFilePrefix = "+++ ";
                positionInfo = "@@ -0,0 +1," + lines + " @@";
                linePrefix = "+";
                break;
            }
            case 1: {
                nullFilePrefix = "*** ";
                newFilePrefix = "--- ";
                positionInfo = "--- 1," + lines + " ----";
                linePrefix = "+ ";
                break;
            }
            default: {
                positionInfo = "0a1," + lines;
                linePrefix = "> ";
            }
        }
        fileReader = new BufferedReader(new InputStreamReader(file.getContents()));
        try {
            try {
                printStream.println("Index: " + pathString);
                printStream.println("===================================================================");
                printStream.println("RCS file: " + pathString);
                printStream.println("diff -N " + pathString);
                if (format != 2) {
                    printStream.println(String.valueOf(nullFilePrefix) + "/dev/null\t1 Jan 1970 00:00:00 -0000");
                    printStream.println(String.valueOf(newFilePrefix) + pathString + "\t1 Jan 1970 00:00:00 -0000");
                }
                if (format == 1) {
                    printStream.println("***************");
                    printStream.println("*** 0 ****");
                }
                printStream.println(positionInfo);
                int i = 0;
                while (i < lines) {
                    printStream.print(linePrefix);
                    printStream.println(fileReader.readLine());
                    ++i;
                }
            }
            catch (IOException e) {
                throw CVSException.wrapException((IResource)file.getIResource(), (String)NLS.bind((String)CVSMessages.CVSTeamProvider_errorAddingFileToDiff, (Object[])new String[]{pathString}), (IOException)e);
            }
        }
        catch (Throwable throwable) {
            var13_18 = null;
            try {
                fileReader.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            var13_18 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        fileReader.close();
    }

    public void setStream(PrintStream stream) {
        this.stream = stream;
    }

    protected void reportEmptyDiff() {
        CVSUIPlugin.openDialog(this.getShell(), new CVSUIPlugin.IOpenableInShell(){

            public void open(Shell shell) {
                MessageDialog.openInformation((Shell)shell, (String)CVSUIMessages.GenerateCVSDiff_noDiffsFoundTitle, (String)CVSUIMessages.GenerateCVSDiff_noDiffsFoundMsg);
            }
        }, 1);
    }

    protected ICVSFolder getLocalRoot(CVSTeamProvider provider) throws CVSException {
        if (!this.isMultiPatch && !this.includeFullPathInformation) {
            Object patchFolder = null;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            patchFolder = this.patchRoot.segmentCount() > 1 ? root.getFolder(this.patchRoot) : root.getProject(this.patchRoot.toString());
            ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)patchFolder);
            if (!cvsResource.isFolder()) {
                cvsResource = cvsResource.getParent();
            }
            return (ICVSFolder)cvsResource;
        }
        return super.getLocalRoot(provider);
    }

    public boolean consultModelsForMappings() {
        return false;
    }
}

