/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.subscriber;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.actions.BranchAction;
import org.eclipse.team.internal.ccvs.ui.actions.IgnoreAction;
import org.eclipse.team.internal.ccvs.ui.actions.SetKeywordSubstitutionAction;
import org.eclipse.team.internal.ccvs.ui.actions.ShowAnnotationAction;
import org.eclipse.team.internal.ccvs.ui.actions.ShowResourceInHistoryAction;
import org.eclipse.team.internal.ccvs.ui.subscriber.CVSActionDelegateWrapper;
import org.eclipse.team.internal.ccvs.ui.subscriber.CVSChangeSetCapability;
import org.eclipse.team.internal.ccvs.ui.subscriber.CVSParticipant;
import org.eclipse.team.internal.ccvs.ui.subscriber.CVSParticipantLabelDecorator;
import org.eclipse.team.internal.ccvs.ui.subscriber.CommitSetDialog;
import org.eclipse.team.internal.ccvs.ui.subscriber.ConfirmMergedAction;
import org.eclipse.team.internal.ccvs.ui.subscriber.CreatePatchAction;
import org.eclipse.team.internal.ccvs.ui.subscriber.OverrideAndCommitAction;
import org.eclipse.team.internal.ccvs.ui.subscriber.OverrideAndUpdateAction;
import org.eclipse.team.internal.ccvs.ui.subscriber.RefreshDirtyStateAction;
import org.eclipse.team.internal.ccvs.ui.subscriber.WorkspaceCommitAction;
import org.eclipse.team.internal.ccvs.ui.subscriber.WorkspaceUpdateAction;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.SubscriberChangeSetCollector;
import org.eclipse.team.internal.ui.synchronize.ChangeSetCapability;
import org.eclipse.team.internal.ui.synchronize.IChangeSetProvider;
import org.eclipse.team.internal.ui.synchronize.ScopableSubscriberParticipant;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantDescriptor;
import org.eclipse.team.ui.synchronize.ISynchronizeScope;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;

public class WorkspaceSynchronizeParticipant
extends ScopableSubscriberParticipant
implements IChangeSetProvider {
    public static final String ID = "org.eclipse.team.cvs.ui.cvsworkspace-participant";
    public static final String TOOLBAR_CONTRIBUTION_GROUP = "toolbar_group_1";
    public static final String CONTEXT_MENU_CONTRIBUTION_GROUP_1 = "context_group_1";
    public static final String CONTEXT_MENU_CONTRIBUTION_GROUP_2 = "context_group_2";
    public static final String CONTEXT_MENU_CONTRIBUTION_GROUP_3 = "context_group_3";
    public static final String CONTEXT_MENU_CONTRIBUTION_GROUP_4 = "context_group_4";
    private WorkspaceChangeSetCapability capability;

    public WorkspaceSynchronizeParticipant() {
    }

    public WorkspaceSynchronizeParticipant(ISynchronizeScope scope) {
        super(scope);
        this.setSubscriber((Subscriber)CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber());
    }

    public void init(String secondaryId, IMemento memento) throws PartInitException {
        super.init(secondaryId, memento);
        this.setSubscriber((Subscriber)CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber());
    }

    protected void initializeConfiguration(ISynchronizePageConfiguration configuration) {
        super.initializeConfiguration(configuration);
        ILabelDecorator labelDecorator = this.getLabelDecorator(configuration);
        configuration.addLabelDecorator(labelDecorator);
        configuration.addMenuGroup("org.eclipse.team.ui.P_TOOLBAR_MENU", TOOLBAR_CONTRIBUTION_GROUP);
        configuration.addActionContribution((SynchronizePageActionGroup)new WorkspaceActionContribution());
        configuration.setSupportedModes(15);
        configuration.setMode(4);
        configuration.addMenuGroup("org.eclipse.team.ui.P_CONTEXT_MENU", CONTEXT_MENU_CONTRIBUTION_GROUP_1);
        configuration.addMenuGroup("org.eclipse.team.ui.P_CONTEXT_MENU", CONTEXT_MENU_CONTRIBUTION_GROUP_2);
        configuration.addMenuGroup("org.eclipse.team.ui.P_CONTEXT_MENU", CONTEXT_MENU_CONTRIBUTION_GROUP_3);
        configuration.addMenuGroup("org.eclipse.team.ui.P_CONTEXT_MENU", CONTEXT_MENU_CONTRIBUTION_GROUP_4);
    }

    protected ILabelDecorator getLabelDecorator(ISynchronizePageConfiguration configuration) {
        return new CVSParticipantLabelDecorator(configuration);
    }

    protected ISynchronizeParticipantDescriptor getDescriptor() {
        return TeamUI.getSynchronizeManager().getParticipantDescriptor(ID);
    }

    public void prepareCompareInput(ISynchronizeModelElement element, CompareConfiguration config, IProgressMonitor monitor) throws TeamException {
        monitor.beginTask(null, 100);
        CVSParticipant.deriveBaseContentsFromLocal(element, Policy.subMonitorFor(monitor, 10));
        super.prepareCompareInput(element, config, Policy.subMonitorFor(monitor, 80));
        CVSParticipant.updateLabelsForCVS(element, config, Policy.subMonitorFor(monitor, 10));
        monitor.done();
    }

    public PreferencePage[] getPreferencePages() {
        return CVSParticipant.addCVSPreferencePages(super.getPreferencePages());
    }

    public ChangeSetCapability getChangeSetCapability() {
        if (this.capability == null) {
            this.capability = new WorkspaceChangeSetCapability();
        }
        return this.capability;
    }

    protected boolean isViewerContributionsSupported() {
        return true;
    }

    public void refresh(IResource[] resources, IWorkbenchPartSite site) {
        this.refresh(resources, this.getShortTaskName(), this.getLongTaskName(resources), (IWorkbenchSite)site);
    }

    public class WorkspaceActionContribution
    extends SynchronizePageActionGroup {
        private WorkspaceCommitAction commitToolbar;
        private WorkspaceUpdateAction updateToolbar;

        public void initialize(ISynchronizePageConfiguration configuration) {
            super.initialize(configuration);
            this.updateToolbar = new WorkspaceUpdateAction(configuration, this.getVisibleRootsSelectionProvider(), "WorkspaceToolbarUpdateAction.");
            this.updateToolbar.setPromptBeforeUpdate(true);
            this.appendToGroup("org.eclipse.team.ui.P_TOOLBAR_MENU", WorkspaceSynchronizeParticipant.TOOLBAR_CONTRIBUTION_GROUP, (IAction)this.updateToolbar);
            this.commitToolbar = new WorkspaceCommitAction(configuration, this.getVisibleRootsSelectionProvider(), "WorkspaceToolbarCommitAction.");
            this.appendToGroup("org.eclipse.team.ui.P_TOOLBAR_MENU", WorkspaceSynchronizeParticipant.TOOLBAR_CONTRIBUTION_GROUP, (IAction)this.commitToolbar);
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", WorkspaceSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_1, (IAction)new WorkspaceUpdateAction(configuration));
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", WorkspaceSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_1, (IAction)new WorkspaceCommitAction(configuration));
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", WorkspaceSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_2, (IAction)new OverrideAndUpdateAction(configuration));
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", WorkspaceSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_2, (IAction)new OverrideAndCommitAction(configuration));
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", WorkspaceSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_2, (IAction)new ConfirmMergedAction(configuration));
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", WorkspaceSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_3, (IAction)new CVSActionDelegateWrapper(new IgnoreAction(), configuration));
            if (!configuration.getSite().isModal()) {
                this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", WorkspaceSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_3, (IAction)new CreatePatchAction(configuration));
                this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", WorkspaceSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_3, (IAction)new CVSActionDelegateWrapper(new BranchAction(), configuration));
                this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", WorkspaceSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_3, (IAction)new CVSActionDelegateWrapper(new ShowAnnotationAction(), configuration));
                this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", WorkspaceSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_3, (IAction)new CVSActionDelegateWrapper(new ShowResourceInHistoryAction(), configuration));
                this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", WorkspaceSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_3, (IAction)new CVSActionDelegateWrapper(new SetKeywordSubstitutionAction(), configuration));
            }
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", WorkspaceSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_4, (IAction)new RefreshDirtyStateAction(configuration));
        }
    }

    public class WorkspaceChangeSetCapability
    extends CVSChangeSetCapability {
        public ActiveChangeSet createChangeSet(ISynchronizePageConfiguration configuration, SyncInfo[] infos) {
            ActiveChangeSet set = this.getActiveChangeSetManager().createSet(CVSUIMessages.WorkspaceChangeSetCapability_1, new SyncInfo[0]);
            CommitSetDialog dialog = new CommitSetDialog(configuration.getSite().getShell(), set, this.getResources(infos), CVSUIMessages.WorkspaceChangeSetCapability_2, CVSUIMessages.WorkspaceChangeSetCapability_3);
            dialog.open();
            if (dialog.getReturnCode() != 0) {
                return null;
            }
            set.add(infos);
            return set;
        }

        private IResource[] getResources(SyncInfo[] infos) {
            IResource[] resources = new IResource[infos.length];
            int i = 0;
            while (i < resources.length) {
                resources[i] = infos[i].getLocal();
                ++i;
            }
            return resources;
        }

        public void editChangeSet(ISynchronizePageConfiguration configuration, ActiveChangeSet set) {
            CommitSetDialog dialog = new CommitSetDialog(configuration.getSite().getShell(), set, set.getResources(), CVSUIMessages.WorkspaceChangeSetCapability_7, CVSUIMessages.WorkspaceChangeSetCapability_8);
            dialog.open();
            if (dialog.getReturnCode() != 0) {
                return;
            }
        }

        public SubscriberChangeSetCollector getActiveChangeSetManager() {
            return CVSUIPlugin.getPlugin().getChangeSetManager();
        }
    }
}

