/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text2;

import java.text.Collator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.search2.internal.ui.text2.IFileSorter;

public class FlatFileSorter
implements IFileSorter {
    private Collator fCollator;
    private Comparator fComparator;

    public FlatFileSorter(Collator collator) {
        this.fCollator = collator;
        this.fComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                return this.compareResources((IResource)o1, (IResource)o2);
            }

            private int compareResources(IResource r1, IResource r2) {
                if (r1 == r2) {
                    return 0;
                }
                if (r1 == null) {
                    return -1;
                }
                if (r2 == null) {
                    return 1;
                }
                int cmp = FlatFileSorter.this.fCollator.compare(r1.getName(), r2.getName());
                if (cmp == 0) {
                    cmp = this.compare(r1.getParent(), r2.getParent());
                }
                return cmp;
            }
        };
    }

    public void sortFiles(IFile[] files) {
        Collections.sort(Arrays.asList(files), this.fComparator);
    }
}

