/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text2;

import java.util.Properties;
import java.util.regex.Pattern;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.search2.internal.ui.text2.IRetrieverKeys;
import org.eclipse.search2.internal.ui.text2.RetrieverFilter;
import org.eclipse.search2.internal.ui.text2.RetrieverPage;
import org.eclipse.search2.internal.ui.text2.SearchMatchInformationProviderRegistry;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class RetrieverFilterTab
implements IRetrieverKeys {
    private RetrieverPage fView;
    private boolean fEnable;
    private boolean fEnableLocation;
    private boolean fEnableString;
    private Button fUseLocationFilter;
    private Button fCommentFilter;
    private Button fStringFilter;
    private Button fIncludeFilter;
    private Button fPrepFilter;
    private Button fFunctionFilter;
    private Button fOtherFilter;
    private Button fUseStringFilter;
    private Combo fFilterString;
    private Button fHideMatching;
    private Button fRegularExpressionFilter;
    private Control[][] fEnableDisable;

    RetrieverFilterTab(RetrieverPage view) {
        this.fView = view;
    }

    public void createControl(Composite parent) {
        int indent = 15;
        Composite outer = new Composite(parent, 0);
        outer.setLayoutData((Object)new GridData(768));
        GridLayout gl = new GridLayout(1, false);
        outer.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.verticalSpacing = 2;
        this.fUseLocationFilter = new Button(outer, 32);
        this.fUseLocationFilter.setText(SearchMessages.RetrieverFilterTab_LocationFilter_text);
        this.fUseLocationFilter.setLayoutData((Object)new GridData());
        Composite locationGroup = new Composite(outer, 0);
        GridData gd = new GridData(32);
        locationGroup.setLayoutData((Object)gd);
        gd.horizontalIndent = indent;
        gl = new GridLayout(3, false);
        locationGroup.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.verticalSpacing = 0;
        this.fCommentFilter = new Button(locationGroup, 32);
        this.fCommentFilter.setText(SearchMessages.RetrieverFilterTab_Comment_text);
        this.fIncludeFilter = new Button(locationGroup, 32);
        this.fIncludeFilter.setText(SearchMessages.RetrieverFilterTab_Import_text);
        SearchMatchInformationProviderRegistry registry = SearchPlugin.getDefault().getSearchMatchInformationProviderRegistry();
        if (registry.hasPreprocessorSupport()) {
            this.fPrepFilter = new Button(locationGroup, 32);
            this.fPrepFilter.setText(SearchMessages.RetrieverFilterTab_Preprocessor_text);
        } else {
            new Label(locationGroup, 0);
        }
        this.fStringFilter = new Button(locationGroup, 32);
        this.fStringFilter.setText(SearchMessages.RetrieverFilterTab_String_text);
        if (registry.hasFunctionSupport()) {
            this.fFunctionFilter = new Button(locationGroup, 32);
            this.fFunctionFilter.setText(SearchMessages.RetrieverFilterTab_FunctionBody_text);
        }
        this.fOtherFilter = new Button(locationGroup, 32);
        this.fOtherFilter.setText(SearchMessages.RetrieverFilterTab_OtherLocation_text);
        Label separator2 = new Label(outer, 258);
        separator2.setLayoutData((Object)new GridData(256));
        gd = new GridData();
        new Label(outer, 0).setLayoutData((Object)gd);
        gd.heightHint = 5;
        Composite indepAlign = new Composite(outer, 0);
        indepAlign.setLayoutData((Object)new GridData(768));
        gl = new GridLayout(2, false);
        indepAlign.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.fUseStringFilter = new Button(indepAlign, 32);
        this.fUseStringFilter.setLayoutData((Object)new GridData());
        this.fUseStringFilter.setText(SearchMessages.RetrieverFilterTab_TextFilter_text);
        this.fFilterString = new Combo(indepAlign, 0);
        this.fFilterString.setVisibleItemCount(8);
        gd = new GridData(768);
        this.fFilterString.setLayoutData((Object)gd);
        gd.widthHint = 20;
        indepAlign = new Composite(outer, 0);
        indepAlign.setLayoutData((Object)new GridData(128));
        gl = new GridLayout(2, false);
        indepAlign.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.fRegularExpressionFilter = new Button(indepAlign, 32);
        this.fRegularExpressionFilter.setText(SearchMessages.RetrieverFindTab_regularExpression);
        this.fHideMatching = new Button(indepAlign, 32);
        this.fHideMatching.setText(SearchMessages.RetrieverFilterTab_HideMatching_text);
        this.fEnableDisable = new Control[][]{{this.fCommentFilter, this.fStringFilter, this.fIncludeFilter, this.fPrepFilter, this.fFunctionFilter, this.fOtherFilter}, {this.fFilterString, this.fHideMatching, this.fRegularExpressionFilter}};
    }

    void createListeners() {
        SelectionAdapter s = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RetrieverFilterTab.this.onEnableFilter();
            }
        };
        this.fUseLocationFilter.addSelectionListener((SelectionListener)s);
        this.fUseStringFilter.addSelectionListener((SelectionListener)s);
        this.fFilterString.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.character == '\n' || e.character == '\r') {
                    RetrieverFilterTab.this.onFilter();
                    RetrieverFilterTab.this.selectStringFilter();
                }
            }
        });
        this.fFilterString.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                RetrieverFilterTab.this.onFilter();
            }
        });
        SelectionAdapter onFilter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RetrieverFilterTab.this.onFilter();
            }
        };
        this.fHideMatching.addSelectionListener((SelectionListener)onFilter);
        this.fRegularExpressionFilter.addSelectionListener((SelectionListener)onFilter);
        this.fStringFilter.addSelectionListener((SelectionListener)onFilter);
        this.fCommentFilter.addSelectionListener((SelectionListener)onFilter);
        this.fIncludeFilter.addSelectionListener((SelectionListener)onFilter);
        if (this.fPrepFilter != null) {
            this.fPrepFilter.addSelectionListener((SelectionListener)onFilter);
        }
        if (this.fFunctionFilter != null) {
            this.fFunctionFilter.addSelectionListener((SelectionListener)onFilter);
        }
        this.fOtherFilter.addSelectionListener((SelectionListener)onFilter);
    }

    protected void onEnableFilter() {
        boolean el = this.fUseLocationFilter.getSelection();
        boolean es = this.fUseStringFilter.getSelection();
        boolean bl = this.fEnable = el || es;
        if (this.fEnable) {
            this.fEnableLocation = el;
            this.fEnableString = es;
        }
        this.fView.onEnableToolbarFilter(this.fEnable);
    }

    protected void onFilter() {
        this.storeValues();
        this.fView.onFilterTabChanged();
    }

    public RetrieverFilter getFilter() {
        if (this.fEnable) {
            return new RetrieverFilter(this.fView, this.getAcceptedLocations(), this.getFilterText(), this.fRegularExpressionFilter.getSelection(), this.fHideMatching.getSelection(), this.hashCode());
        }
        return new RetrieverFilter();
    }

    private int getAcceptedLocations() {
        int acceptLocations = 63;
        if (this.fUseLocationFilter.getSelection()) {
            acceptLocations = 0;
            if (this.fStringFilter.getSelection()) {
                acceptLocations |= 2;
            }
            if (this.fCommentFilter.getSelection()) {
                acceptLocations |= 4;
            }
            if (this.fIncludeFilter.getSelection()) {
                acceptLocations |= 8;
            }
            if (this.fPrepFilter == null || this.fPrepFilter.getSelection()) {
                acceptLocations |= 0x10;
            }
            if (this.fFunctionFilter == null || this.fFunctionFilter.getSelection()) {
                acceptLocations |= 0x20;
            }
            if (this.fOtherFilter.getSelection()) {
                acceptLocations |= 1;
            }
        }
        return acceptLocations;
    }

    private String getFilterText() {
        return this.fUseStringFilter.getSelection() ? this.fFilterString.getText() : null;
    }

    void storeValues() {
        this.fView.storeValue(this.fEnableString, "use-filter-pattern");
        this.fView.storeValue(this.fEnableLocation, "use-location-filter");
        this.fView.storeComboContent(this.fFilterString, "filter-pattern", 8);
        this.fView.storeButton(this.fHideMatching, "filter-invert");
        this.fView.storeButton(this.fRegularExpressionFilter, "filter-regexp");
        this.fView.storeButton(this.fCommentFilter, "filter-comment");
        this.fView.storeButton(this.fStringFilter, "filter-string");
        this.fView.storeButton(this.fIncludeFilter, "filter-include");
        this.fView.storeButton(this.fPrepFilter, "filter-prep");
        this.fView.storeButton(this.fFunctionFilter, "filter-function");
        this.fView.storeButton(this.fOtherFilter, "filter-elsewhere");
    }

    void restoreValues(boolean filterEnabled) {
        this.fEnable = filterEnabled;
        this.fEnableLocation = this.fView.restoreValue("use-location-filter", true);
        this.fEnableString = this.fView.restoreValue("use-filter-pattern", false);
        this.fUseLocationFilter.setSelection(this.fEnable && this.fEnableLocation);
        this.fUseStringFilter.setSelection(this.fEnable && this.fEnableString);
        this.fView.restoreCombo(this.fFilterString, "filter-pattern", "");
        this.fView.restoreButton(this.fHideMatching, "filter-invert", false);
        this.fView.restoreButton(this.fRegularExpressionFilter, "filter-regexp", false);
        this.fView.restoreButton(this.fCommentFilter, "filter-comment", true);
        this.fView.restoreButton(this.fStringFilter, "filter-string", true);
        this.fView.restoreButton(this.fIncludeFilter, "filter-include", true);
        this.fView.restoreButton(this.fPrepFilter, "filter-prep", true);
        this.fView.restoreButton(this.fFunctionFilter, "filter-function", true);
        this.fView.restoreButton(this.fOtherFilter, "filter-elsewhere", true);
        this.updateEnablement();
    }

    private void updateEnablement() {
        this.enableAll(this.fEnableDisable[0], this.fEnable && this.fEnableLocation);
        this.enableAll(this.fEnableDisable[1], this.fEnable && this.fEnableString);
    }

    private void enableAll(Control[] controls, boolean enable) {
        int i = 0;
        while (i < controls.length) {
            Control control = controls[i];
            if (control != null) {
                control.setEnabled(enable);
            }
            ++i;
        }
    }

    public void onEnableToolbarFilter(boolean enable) {
        this.fEnable = enable;
        this.fUseLocationFilter.setSelection(this.fEnable && this.fEnableLocation);
        this.fUseStringFilter.setSelection(this.fEnable && this.fEnableString);
        this.updateEnablement();
        this.selectStringFilter();
    }

    public void onSelected() {
        this.selectStringFilter();
    }

    private void selectStringFilter() {
        if (this.fFilterString.isEnabled()) {
            this.fFilterString.setFocus();
            this.fFilterString.setSelection(new Point(0, this.fFilterString.getText().length()));
        }
    }

    public void getProperties(Properties props) {
        if (this.fEnable) {
            props.setProperty("filter-action", String.valueOf(true));
            this.getProperty(props, "filter-comment", this.fCommentFilter);
            this.getProperty(props, "filter-elsewhere", this.fOtherFilter);
            this.getProperty(props, "filter-pattern", this.fFilterString);
            this.getProperty(props, "filter-function", this.fFunctionFilter);
            this.getProperty(props, "filter-include", this.fIncludeFilter);
            this.getProperty(props, "filter-invert", this.fHideMatching);
            this.getProperty(props, "filter-prep", this.fPrepFilter);
            this.getProperty(props, "filter-regexp", this.fRegularExpressionFilter);
            this.getProperty(props, "filter-string", this.fStringFilter);
        }
    }

    private void getProperty(Properties props, String key, Button button) {
        if (button != null) {
            props.setProperty(key, String.valueOf(button.getSelection()));
        }
    }

    private void getProperty(Properties props, String key, Combo text) {
        props.setProperty(key, text.getText());
    }

    public void setProperties(Properties props) {
        if (Boolean.valueOf(props.getProperty("filter-action")).booleanValue()) {
            this.fEnable = true;
            this.setProperty(props, "filter-comment", this.fCommentFilter);
            this.setProperty(props, "filter-include", this.fIncludeFilter);
            this.setProperty(props, "filter-prep", this.fPrepFilter);
            this.setProperty(props, "filter-string", this.fStringFilter);
            this.setProperty(props, "filter-function", this.fFunctionFilter);
            this.setProperty(props, "filter-elsewhere", this.fOtherFilter);
            this.setProperty(props, "filter-pattern", this.fFilterString);
            this.setProperty(props, "filter-invert", this.fHideMatching);
            this.setProperty(props, "filter-regexp", this.fRegularExpressionFilter);
        } else {
            this.fEnable = false;
        }
        this.updateEnablement();
    }

    private void setProperty(Properties props, String key, Combo combo) {
        String property = props.getProperty(key);
        if (property != null) {
            combo.setText(property);
        }
    }

    private void setProperty(Properties props, String key, Button button) {
        String property;
        if (button != null && (property = props.getProperty(key)) != null) {
            button.setSelection(Boolean.valueOf(property).booleanValue());
        }
    }

    public boolean restoreFromResult(RetrieverFilter filter) {
        if (filter.getOriginatorsHash() == this.hashCode()) {
            return this.fEnable;
        }
        int loc = filter.getAcceptedLocations();
        Pattern pattern = filter.getPattern();
        boolean el = loc != 63;
        boolean es = pattern != null;
        boolean bl = this.fEnable = el || es;
        if (this.fEnable) {
            this.fEnableLocation = el;
            this.fEnableString = es;
        } else {
            es = false;
            el = false;
        }
        this.fUseLocationFilter.setSelection(el);
        this.fUseStringFilter.setSelection(es);
        if (el) {
            this.setButton(this.fCommentFilter, loc, 2);
            this.setButton(this.fStringFilter, loc, 1);
            this.setButton(this.fIncludeFilter, loc, 3);
            this.setButton(this.fPrepFilter, loc, 4);
            this.setButton(this.fFunctionFilter, loc, 5);
            this.setButton(this.fOtherFilter, loc, 0);
        }
        if (es) {
            this.fEnableString = true;
            this.fUseStringFilter.setSelection(true);
            this.fFilterString.setText(filter.getFilterString());
            this.fRegularExpressionFilter.setSelection(filter.getIsRegex());
            this.fHideMatching.setSelection(filter.getHideMatching());
        }
        this.updateEnablement();
        return this.fEnable;
    }

    private void setButton(Button button, int allowedLoc, int loc) {
        if (button != null) {
            button.setSelection((allowedLoc & 1 << loc) != 0);
        }
    }
}

