/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text2;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.search.internal.ui.util.SWTUtil;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.search2.internal.ui.text2.FilePatternSelectionDialog;
import org.eclipse.search2.internal.ui.text2.IRetrieverKeys;
import org.eclipse.search2.internal.ui.text2.IScopeDescription;
import org.eclipse.search2.internal.ui.text2.RetrieverPage;
import org.eclipse.search2.internal.ui.text2.RetrieverQuery;
import org.eclipse.search2.internal.ui.text2.RetrieverResult;
import org.eclipse.search2.internal.ui.text2.SelectedResourcesScopeDescription;
import org.eclipse.search2.internal.ui.text2.SimpleResourceSelectionDialog;
import org.eclipse.search2.internal.ui.text2.WindowWorkingSetScopeDescription;
import org.eclipse.search2.internal.ui.text2.WorkingSetScopeDescription;
import org.eclipse.search2.internal.ui.text2.WorkspaceScopeDescription;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class RetrieverFindTab
implements IRetrieverKeys {
    private RetrieverPage fView;
    private Combo fWorkingSetCombo;
    private Button fChooseWorkingSetButton;
    private Combo fSearchString;
    private Button fCaseSensitive;
    private Button fRegularExpression;
    private Button fWholeWord;
    private Button fSearchButton;
    private Combo fFilePatterns;
    private Button fFilePatternButton;
    private Control[] fEnableDisable;
    private Map fScopeMap = new HashMap();
    private int fPermanentScopeCount;

    RetrieverFindTab(RetrieverPage view) {
        this.fView = view;
    }

    public void createControl(Composite group) {
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(3, false));
        this.fSearchString = new Combo(group, 0);
        GridData gd = new GridData(256);
        this.fSearchString.setLayoutData((Object)gd);
        this.fSearchString.setVisibleItemCount(8);
        gd.horizontalSpan = 2;
        gd.widthHint = 20;
        this.fSearchButton = new Button(group, 8);
        this.fSearchButton.setText(SearchMessages.RetrieverFindTab_search);
        gd = new GridData(256);
        this.fSearchButton.setLayoutData((Object)gd);
        gd.horizontalSpan = 1;
        SWTUtil.setButtonDimensionHint(this.fSearchButton);
        Composite comp = new Composite(group, 0);
        gd = new GridData(32);
        comp.setLayoutData((Object)gd);
        gd.horizontalSpan = 3;
        GridLayout gl = new GridLayout(3, false);
        comp.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.fCaseSensitive = new Button(comp, 32);
        this.fCaseSensitive.setText(SearchMessages.RetrieverFindTab_caseSensitive);
        this.fRegularExpression = new Button(comp, 32);
        this.fRegularExpression.setText(SearchMessages.RetrieverFindTab_regularExpression);
        this.fWholeWord = new Button(comp, 32);
        this.fWholeWord.setText(SearchMessages.RetrieverFindTab_wholeWord);
        Label separator = new Label(group, 258);
        gd = new GridData(256);
        separator.setLayoutData((Object)gd);
        gd.horizontalSpan = 3;
        gd = new GridData();
        new Label(group, 0).setLayoutData((Object)gd);
        gd.horizontalSpan = 3;
        gd.heightHint = 0;
        Label scopeLabel = new Label(group, 0);
        scopeLabel.setText(SearchMessages.RetrieverFindTab_searchScope);
        this.fWorkingSetCombo = new Combo(group, 2056);
        this.fWorkingSetCombo.setVisibleItemCount(8);
        gd = new GridData(768);
        this.fWorkingSetCombo.setLayoutData((Object)gd);
        gd.widthHint = 20;
        this.fChooseWorkingSetButton = new Button(group, 8);
        this.fChooseWorkingSetButton.setText(SearchMessages.RetrieverFindTab_choose);
        this.fChooseWorkingSetButton.setLayoutData((Object)new GridData(256));
        SWTUtil.setButtonDimensionHint(this.fChooseWorkingSetButton);
        Label filePatternLabel = new Label(group, 0);
        filePatternLabel.setText(SearchMessages.RetrieverFindTab_filePatterns);
        this.fFilePatterns = new Combo(group, 0);
        this.fFilePatterns.setVisibleItemCount(8);
        gd = new GridData(768);
        this.fFilePatterns.setLayoutData((Object)gd);
        gd.widthHint = 20;
        this.fFilePatternButton = new Button(group, 8);
        this.fFilePatternButton.setText(SearchMessages.RetrieverFindTab_choose);
        this.fFilePatternButton.setLayoutData((Object)new GridData(256));
        SWTUtil.setButtonDimensionHint(this.fFilePatternButton);
        this.fEnableDisable = new Control[]{this.fSearchString, this.fSearchButton, this.fCaseSensitive, this.fRegularExpression, this.fWholeWord, scopeLabel, this.fWorkingSetCombo, this.fChooseWorkingSetButton, filePatternLabel, this.fFilePatterns, this.fFilePatternButton};
        this.setupScopeCombo();
    }

    public void setFocus() {
        this.fSearchString.setSelection(new Point(0, this.fSearchString.getText().length()));
        this.fSearchString.setFocus();
    }

    public void dispose() {
    }

    void storeValues() {
        IScopeDescription scope = this.getSearchScope();
        this.fView.storeComboContent(this.fFilePatterns, "file-patterns", 8);
        this.fView.storeComboContent(this.fSearchString, "search-string", 8);
        this.fView.storeButton(this.fCaseSensitive, "case-sensitive");
        this.fView.storeButton(this.fRegularExpression, "regular-expression");
        this.fView.storeButton(this.fWholeWord, "whole-word");
        this.storeScopeCombo();
        RetrieverPage.sLastFilePatterns = this.fFilePatterns.getText();
        RetrieverPage.sLastSearchPattern = this.fSearchString.getText();
        RetrieverPage.sLastIsCaseSensitive = this.fCaseSensitive.getSelection();
        RetrieverPage.sLastIsRegularExpression = this.fRegularExpression.getSelection();
        RetrieverPage.sLastIsWholeWord = this.fWholeWord.getSelection();
        RetrieverPage.sLastScope = scope;
    }

    private void storeScopeCombo() {
        String[] names = this.fWorkingSetCombo.getItems();
        this.fView.storeValue(names, "scope-history");
        int i = this.fPermanentScopeCount;
        while (i < names.length) {
            String name = names[i];
            IScopeDescription scope = (IScopeDescription)this.fScopeMap.get(name);
            if (scope != null) {
                this.fView.storeScope(scope, "scope-history-" + name);
            }
            ++i;
        }
        IScopeDescription scope = this.getSearchScope();
        this.fView.storeScope(scope, "search-scope");
    }

    void restoreValues() {
        this.fView.restoreCombo(this.fFilePatterns, "file-patterns", "*.c,*.ci,*.h,*.java");
        this.fView.restoreCombo(this.fSearchString, "search-string", null);
        this.fView.restoreButton(this.fCaseSensitive, "case-sensitive", true);
        this.fView.restoreButton(this.fRegularExpression, "regular-expression", false);
        this.fView.restoreButton(this.fWholeWord, "whole-word", true);
        this.fFilePatterns.clearSelection();
        this.setupScopeCombo();
    }

    private void setupScopeCombo() {
        this.fWorkingSetCombo.removeAll();
        this.fPermanentScopeCount = 3;
        this.addScopeToCombo(new WorkspaceScopeDescription(), false);
        this.addScopeToCombo(new WindowWorkingSetScopeDescription(), false);
        this.addScopeToCombo(new SelectedResourcesScopeDescription(), false);
        String[] names = this.fView.restoreValue("scope-history", null);
        if (names != null) {
            int i = names.length - 1;
            while (i >= 0) {
                String name = names[i];
                IScopeDescription scope = this.fView.restoreScope("scope-history-" + name);
                if (scope != null) {
                    this.addScopeToCombo(scope, false);
                }
                --i;
            }
        }
        IScopeDescription scope = this.fView.restoreScope("search-scope");
        this.addScopeToCombo(scope, false);
    }

    void createListeners() {
        this.fSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RetrieverFindTab.this.onSearch();
            }
        });
        this.fSearchString.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                String text = RetrieverFindTab.this.fSearchString.getText();
                if ((e.character == '\n' || e.character == '\r') && text.length() > 0) {
                    RetrieverFindTab.this.onSearch();
                }
                RetrieverPage.sLastSearchPattern = text;
            }
        });
        this.fChooseWorkingSetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RetrieverFindTab.this.onChooseButtonSelectWorkingSet();
            }
        });
        this.fFilePatternButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RetrieverFindTab.this.onChooseButtonSelectFilePatterns();
            }
        });
        this.fSearchString.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RetrieverPage.sLastSearchPattern = RetrieverFindTab.this.fSearchString.getText();
            }
        });
        this.fCaseSensitive.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RetrieverPage.sLastIsCaseSensitive = RetrieverFindTab.this.fCaseSensitive.getSelection();
            }
        });
        this.fRegularExpression.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RetrieverPage.sLastIsRegularExpression = RetrieverFindTab.this.fRegularExpression.getSelection();
            }
        });
        this.fWholeWord.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RetrieverPage.sLastIsWholeWord = RetrieverFindTab.this.fWholeWord.getSelection();
            }
        });
        this.fFilePatterns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RetrieverPage.sLastFilePatterns = RetrieverFindTab.this.fFilePatterns.getText();
            }
        });
        this.fWorkingSetCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RetrieverPage.sLastScope = RetrieverFindTab.this.getSearchScope();
            }
        });
    }

    protected void onSearch() {
        String searchText = this.fSearchString.getText();
        if (searchText.length() == 0) {
            this.fView.showError(SearchMessages.RetrieverFindTab_Error_emptySearchString);
            return;
        }
        if (this.fRegularExpression.getSelection()) {
            boolean cont;
            Pattern pattern = null;
            try {
                pattern = Pattern.compile(searchText);
            }
            catch (Exception e) {
                this.fView.showError(String.valueOf(SearchMessages.RetrieverFindTab_Error_invalidRegex) + e.getMessage());
                return;
            }
            if (pattern.matcher("").find() && !(cont = this.fView.showQuestion(SearchMessages.RetrieverFindTab_Question_regexMatchesEmptyString))) {
                return;
            }
        }
        this.fView.storeValues();
        RetrieverQuery query = new RetrieverQuery(this.fView.getSite().getPage());
        query.setSearchString(RetrieverPage.sLastSearchPattern);
        query.setIsCaseSensitive(RetrieverPage.sLastIsCaseSensitive);
        query.setIsRegularExpression(RetrieverPage.sLastIsRegularExpression);
        query.setIsWholeWord(RetrieverPage.sLastIsWholeWord);
        query.setSearchScope(RetrieverPage.sLastScope, RetrieverPage.sLastConsiderDerivedResources);
        query.setFilePatterns(RetrieverPage.sLastFilePatterns, RetrieverPage.sLastUseCaseSensitiveFilePatterns);
        query.setSearchOrder(this.fView.getPreferredSearchOrder());
        RetrieverResult result = (RetrieverResult)query.getSearchResult();
        this.fView.initFilter(result);
        this.fView.storeValues();
        NewSearchUI.runQueryInBackground(query, this.fView.getViewPart());
    }

    private IScopeDescription getSearchScope() {
        String scopeLabel = this.fWorkingSetCombo.getText();
        IScopeDescription result = (IScopeDescription)this.fScopeMap.get(scopeLabel);
        return result == null ? new WorkspaceScopeDescription() : result;
    }

    protected void onChooseButtonSelectWorkingSet() {
        IScopeDescription scope = this.getSearchScope();
        if (scope instanceof SelectedResourcesScopeDescription) {
            this.adjustSelectedResources((SelectedResourcesScopeDescription)scope);
        } else {
            IScopeDescription use = WorkingSetScopeDescription.createWithDialog(this.fView.getSite().getPage(), scope);
            if (use != null) {
                this.addScopeToCombo(use, false);
            }
        }
    }

    private void adjustSelectedResources(SelectedResourcesScopeDescription scope) {
        Object[] selection;
        SimpleResourceSelectionDialog dlg = new SimpleResourceSelectionDialog(this.fView.getSite().getShell(), SearchMessages.RetrieverFindTab_selectedResourcesTitle, SearchMessages.RetrieverFindTab_selectedResourcesMessage);
        dlg.setInitialSelections(scope.getRoots(null));
        if (dlg.open() == 0 && (selection = dlg.getResult()) != null) {
            scope.setSelection(Arrays.asList(selection).toArray(new IResource[selection.length]));
        }
    }

    protected void onChooseButtonSelectFilePatterns() {
        FilePatternSelectionDialog dlg = new FilePatternSelectionDialog(this.fView.getSite().getShell(), this.fFilePatterns.getText());
        if (dlg.open() == 0) {
            this.setCombo(this.fFilePatterns, dlg.getFilePatterns(), 0, 8, false);
        }
    }

    void updateEnablement(boolean searchInProgress) {
        int i = 0;
        while (i < this.fEnableDisable.length) {
            this.fEnableDisable[i].setEnabled(!searchInProgress);
            ++i;
        }
    }

    public void onSelected() {
        this.setFocus();
    }

    public void storeValues(Properties props) {
        props.setProperty("file-patterns", this.fFilePatterns.getText());
        props.setProperty("search-string", this.fSearchString.getText());
        this.storeButton(props, "case-sensitive", this.fCaseSensitive);
        this.storeButton(props, "regular-expression", this.fRegularExpression);
        this.storeButton(props, "whole-word", this.fWholeWord);
        this.storeScope(props, this.getSearchScope());
    }

    private void storeScope(Properties props, IScopeDescription searchScope) {
        props.setProperty("scope-descriptor-class", searchScope.getClass().getName());
        searchScope.store(props, "search-scope");
    }

    private void storeButton(Properties props, String key, Button button) {
        props.setProperty(key, String.valueOf(button.getSelection()));
    }

    public void restoreValues(Properties props) {
        this.restoreComboText(props, "file-patterns", this.fFilePatterns);
        this.restoreComboText(props, "search-string", this.fSearchString);
        this.restoreButton(props, "case-sensitive", this.fCaseSensitive);
        this.restoreButton(props, "regular-expression", this.fRegularExpression);
        this.restoreButton(props, "whole-word", this.fWholeWord);
        IScopeDescription scope = this.restoreScope(props);
        this.addScopeToCombo(scope, false);
    }

    private IScopeDescription restoreScope(Properties props) {
        IScopeDescription scope = null;
        try {
            String scopeDescClass = props.getProperty("scope-descriptor-class");
            scope = (IScopeDescription)Class.forName(scopeDescClass).newInstance();
            scope.restore(props, "search-scope");
        }
        catch (Exception exception) {
            scope = new WorkspaceScopeDescription();
        }
        return scope;
    }

    private void restoreComboText(Properties props, String key, Combo combo) {
        String property = props.getProperty(key);
        if (property != null) {
            combo.setText(property);
        }
    }

    private void restoreButton(Properties props, String key, Button button) {
        String property = props.getProperty(key);
        if (property != null) {
            button.setSelection(Boolean.valueOf(property).booleanValue());
        }
    }

    public void restoreFromQuery(RetrieverQuery rq) {
        this.fCaseSensitive.setSelection(rq.isCaseSensitive());
        this.fRegularExpression.setSelection(rq.isRegularExpression());
        this.fWholeWord.setSelection(rq.isWholeWord());
        String searchFor = rq.getSearchText();
        if (searchFor != null && searchFor.length() > 0) {
            this.setCombo(this.fSearchString, rq.getSearchText(), 0, 8, true);
        }
        this.setCombo(this.fFilePatterns, rq.getFilePatterns(), 0, 8, true);
        this.addScopeToCombo(rq.getScopeDescription(), true);
    }

    private void addScopeToCombo(IScopeDescription scope, boolean moveExisting) {
        String scopeLabel = scope.getLabelForCombo();
        this.fScopeMap.put(scopeLabel, scope);
        this.setCombo(this.fWorkingSetCombo, scope.getLabelForCombo(), this.fPermanentScopeCount, 8, moveExisting);
        RetrieverPage.sLastScope = scope;
    }

    private void setCombo(Combo combo, String value, int insertPos, int maxItems, boolean moveExisting) {
        int idx = combo.indexOf(value);
        if (idx < 0) {
            insertPos = Math.min(combo.getItemCount(), insertPos);
            combo.add(value, insertPos);
            int itemCount = combo.getItemCount();
            if (itemCount > maxItems) {
                combo.remove(maxItems, itemCount - 1);
            }
            idx = insertPos;
        } else if (moveExisting && idx > insertPos) {
            combo.remove(idx);
            combo.add(value, insertPos);
        }
        combo.setText(value);
    }
}

