/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text2;

import java.util.Properties;
import java.util.regex.Pattern;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.internal.ui.util.SWTUtil;
import org.eclipse.search2.internal.ui.InternalSearchUI;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.search2.internal.ui.text2.IRetrieverKeys;
import org.eclipse.search2.internal.ui.text2.ReplaceAction;
import org.eclipse.search2.internal.ui.text2.RetrieverLabelProvider;
import org.eclipse.search2.internal.ui.text2.RetrieverLine;
import org.eclipse.search2.internal.ui.text2.RetrieverMatch;
import org.eclipse.search2.internal.ui.text2.RetrieverPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RetrieverReplaceTab
implements IRetrieverKeys {
    private RetrieverPage fView;
    private Combo fReplacementCombo;
    private Button fNextButton;
    private Button fReplaceNextButton;
    private Button fRestoreNextButton;
    private Button fReplaceRestoreButton;
    private Button fReplaceAllButton;
    private Button fRestoreAllButton;
    private Text fPreviewLine;
    private Pattern fSearchPattern;
    private boolean fSearchInProgress;
    private RetrieverMatch fMatchOfPreview;

    public RetrieverReplaceTab(RetrieverPage view) {
        this.fView = view;
    }

    public void createControl(Composite parent) {
        Composite group = new Composite(parent, 0);
        group.setLayoutData((Object)new GridData(768));
        GridLayout gl = new GridLayout(2, false);
        group.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        Label l = new Label(group, 0);
        l.setText(SearchMessages.RetrieverReplaceTab_ReplaceWith_label);
        this.fReplacementCombo = new Combo(group, 0);
        this.fReplacementCombo.setVisibleItemCount(8);
        GridData gd = new GridData(768);
        this.fReplacementCombo.setLayoutData((Object)gd);
        gd.widthHint = 20;
        group = new Composite(parent, 0);
        group.setLayoutData((Object)new GridData(128));
        gl = new GridLayout(1, true);
        group.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        Composite lg = new Composite(group, 0);
        lg.setLayoutData((Object)new GridData(256));
        gl = new GridLayout(3, true);
        lg.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.horizontalSpacing = 2;
        gl.verticalSpacing = 2;
        this.fNextButton = new Button(lg, 0);
        this.fNextButton.setText(SearchMessages.RetrieverReplaceTab_Find_text);
        this.fNextButton.setLayoutData((Object)new GridData(256));
        SWTUtil.setButtonDimensionHint(this.fNextButton);
        this.fReplaceNextButton = new Button(lg, 0);
        this.fReplaceNextButton.setText(SearchMessages.RetrieverReplaceTab_ReplaceFind_text);
        this.fReplaceNextButton.setLayoutData((Object)new GridData(256));
        SWTUtil.setButtonDimensionHint(this.fReplaceNextButton);
        this.fRestoreNextButton = new Button(lg, 0);
        this.fRestoreNextButton.setText(SearchMessages.RetrieverReplaceTab_RestoreFind_text);
        this.fRestoreNextButton.setLayoutData((Object)new GridData(256));
        SWTUtil.setButtonDimensionHint(this.fRestoreNextButton);
        this.fReplaceRestoreButton = new Button(lg, 0);
        this.fReplaceRestoreButton.setText(SearchMessages.RetrieverReplaceTab_Replace_text);
        this.fReplaceRestoreButton.setLayoutData((Object)new GridData(256));
        SWTUtil.setButtonDimensionHint(this.fReplaceRestoreButton);
        this.fReplaceAllButton = new Button(lg, 0);
        this.fReplaceAllButton.setText(SearchMessages.RetrieverReplaceTab_ReplaceAll_text);
        this.fReplaceAllButton.setLayoutData((Object)new GridData(256));
        SWTUtil.setButtonDimensionHint(this.fReplaceAllButton);
        this.fRestoreAllButton = new Button(lg, 0);
        this.fRestoreAllButton.setText(SearchMessages.RetrieverReplaceTab_RestoreAll_text);
        this.fRestoreAllButton.setLayoutData((Object)new GridData(256));
        SWTUtil.setButtonDimensionHint(this.fRestoreAllButton);
        group = new Composite(parent, 0);
        group.setLayoutData((Object)new GridData(256));
        gl = new GridLayout(1, true);
        group.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.verticalSpacing = 2;
        l = new Label(group, 0);
        l.setText(SearchMessages.RetrieverReplaceTab_Preview_label);
        this.fPreviewLine = new Text(group, 2056);
        this.fPreviewLine.setLayoutData((Object)new GridData(768));
    }

    void createListeners(Viewer resultViewer) {
        resultViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RetrieverReplaceTab.this.onSelectionChanged((IStructuredSelection)event.getSelection());
            }
        });
        this.fReplacementCombo.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                RetrieverReplaceTab.this.onReplacementChange();
            }
        });
        this.fReplacementCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RetrieverReplaceTab.this.onReplacementChange();
            }
        });
        this.fNextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RetrieverReplaceTab.this.fView.gotoNextMatch();
            }
        });
        this.fReplaceRestoreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RetrieverReplaceTab.this.fMatchOfPreview != null) {
                    RetrieverReplaceTab.this.onReplace(!RetrieverReplaceTab.this.fMatchOfPreview.isReplaced(), false, RetrieverReplaceTab.this.fReplaceRestoreButton.getText());
                }
            }
        });
        this.fReplaceNextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RetrieverReplaceTab.this.onReplace(true, true, RetrieverReplaceTab.this.fReplaceNextButton.getText());
            }
        });
        this.fRestoreNextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RetrieverReplaceTab.this.onReplace(false, true, RetrieverReplaceTab.this.fRestoreNextButton.getText());
            }
        });
        this.fReplaceAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RetrieverReplaceTab.this.onReplaceAll(true, RetrieverReplaceTab.this.fReplaceAllButton.getText());
            }
        });
        this.fRestoreAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RetrieverReplaceTab.this.onReplaceAll(false, RetrieverReplaceTab.this.fRestoreAllButton.getText());
            }
        });
    }

    void createActions() {
    }

    protected void onReplacementChange() {
        this.updatePreview((ISelection)this.fView.getSelection());
    }

    protected void updatePreview(ISelection sel) {
        this.fMatchOfPreview = (RetrieverMatch)this.fView.getCurrentMatch();
        if (this.fMatchOfPreview == null) {
            this.fMatchOfPreview = this.getMatchOfSelection(sel);
        }
        String preview = null;
        if (this.fMatchOfPreview != null) {
            preview = this.computePreview(this.fMatchOfPreview);
        }
        if (preview == null) {
            preview = "";
        }
        this.fPreviewLine.setText(preview);
    }

    private RetrieverMatch getMatchOfSelection(ISelection sel) {
        RetrieverMatch[] matches;
        Object element;
        if (sel instanceof IStructuredSelection && (element = ((IStructuredSelection)sel).getFirstElement()) instanceof RetrieverLine && (matches = ((RetrieverLine)element).getDisplayedMatches()).length > 0) {
            return matches[0];
        }
        return null;
    }

    protected void onSelectionChanged(IStructuredSelection sel) {
        this.updatePreview((ISelection)sel);
        if (this.fSearchInProgress) {
            this.fReplaceRestoreButton.setEnabled(false);
            this.fReplaceNextButton.setEnabled(false);
            this.fRestoreNextButton.setEnabled(false);
            this.fReplaceAllButton.setEnabled(false);
            this.fRestoreAllButton.setEnabled(false);
            return;
        }
        if (this.fMatchOfPreview != null) {
            boolean replaced = this.fMatchOfPreview.isReplaced();
            this.fReplaceRestoreButton.setEnabled(true);
            this.fReplaceRestoreButton.setText(replaced ? SearchMessages.RetrieverReplaceTab_Restore_text : SearchMessages.RetrieverReplaceTab_Replace_text);
            this.fReplaceNextButton.setEnabled(!replaced);
            this.fRestoreNextButton.setEnabled(replaced);
        }
        this.fReplaceAllButton.setEnabled(true);
        this.fRestoreAllButton.setEnabled(true);
    }

    private String computePreview(RetrieverMatch match) {
        String post;
        String pre;
        RetrieverLine line = match.getLine();
        IFile file = line.getParent();
        IDocument doc = null;
        if (file != null) {
            IPath path = file.getFullPath();
            ITextFileBuffer txfbuf = FileBuffers.getTextFileBufferManager().getTextFileBuffer(path);
            if (txfbuf != null) {
                doc = txfbuf.getDocument();
            }
        }
        if (doc != null) {
            String matchstr;
            int offset1 = match.getOffset();
            int offset2 = offset1 + match.getLength();
            Position pos = InternalSearchUI.getInstance().getPositionTracker().getCurrentPosition(match);
            if (pos != null) {
                offset1 = pos.offset;
                offset2 = offset1 + pos.length;
            }
            if (offset1 < 0 || offset1 > offset2 || offset2 > doc.getLength()) {
                return null;
            }
            try {
                int offset0 = offset1;
                int min = Math.max(0, offset1 - 1024);
                while (offset0 > min) {
                    char c = doc.getChar(offset0 - 1);
                    if (c == '\n' || c == '\r') break;
                    --offset0;
                }
                int offset3 = offset2;
                int max = Math.min(doc.getLength(), offset2 + 1024);
                while (offset3 < max) {
                    char c = doc.getChar(offset3);
                    if (c == '\n' || c == '\r') break;
                    ++offset3;
                }
                if (offset3 > offset2 && doc.getChar(offset3 - 1) == '\r') {
                    --offset3;
                }
                pre = doc.get(offset0, offset1 - offset0);
                matchstr = doc.get(offset1, offset2 - offset1);
                post = doc.get(offset2, offset3 - offset2);
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
            if (!matchstr.equals(match.getCurrentText())) {
                return null;
            }
        } else {
            pre = line.getPreString(match);
            post = line.getPostString(match);
        }
        StringBuffer result = new StringBuffer();
        result.append(pre);
        if (match.isReplaced()) {
            result.append(match.getOriginal());
        } else {
            String unescapedReplacement = this.getUnescapedReplacementString();
            String replacement = match.computeReplacement(this.fSearchPattern, unescapedReplacement);
            if (replacement == null) {
                return null;
            }
            result.append(replacement);
        }
        result.append(post);
        return RetrieverLabelProvider.convertChars(result);
    }

    private String getUnescapedReplacementString() {
        return this.unescapeWhitespace(this.fReplacementCombo.getText());
    }

    private String unescapeWhitespace(String input) {
        StringBuffer result = new StringBuffer(input.length());
        int i = 0;
        while (i < input.length() - 1) {
            char c = input.charAt(i);
            ++i;
            if (c == '\\') {
                c = input.charAt(i);
                ++i;
                switch (c) {
                    case 't': {
                        result.append('\t');
                        break;
                    }
                    case 'r': {
                        result.append('\r');
                        break;
                    }
                    case 'n': {
                        result.append('\n');
                        break;
                    }
                    case '\\': {
                        result.append('\\');
                        result.append('\\');
                        break;
                    }
                    default: {
                        result.append('\\');
                        result.append(c);
                        break;
                    }
                }
                continue;
            }
            result.append(c);
        }
        if (i < input.length()) {
            result.append(input.charAt(i));
        }
        return result.toString();
    }

    protected void onReplace(boolean replace, boolean moveOn, String actionLabel) {
        this.storeValues();
        if (this.fMatchOfPreview != null) {
            ReplaceAction op = new ReplaceAction(this.fView, actionLabel, replace, this.fMatchOfPreview);
            op.setReplacement(this.fSearchPattern, this.getUnescapedReplacementString());
            op.run();
            if (this.fView.getCurrentMatch() == null) {
                this.fView.gotoNextMatch();
            }
            if (moveOn && op.wasSuccessful()) {
                this.fView.gotoNextMatch();
            } else {
                this.onSelectionChanged(this.fView.getSelection());
            }
        }
    }

    protected void onReplaceAll(boolean replace, String actionLabel) {
        this.storeValues();
        ReplaceAction op = new ReplaceAction(this.fView, actionLabel, replace);
        op.setReplacement(this.fSearchPattern, this.getUnescapedReplacementString());
        op.run();
    }

    void storeValues() {
        this.fView.storeComboContent(this.fReplacementCombo, "replacement-string", 8);
    }

    void restoreValues() {
        this.fView.restoreCombo(this.fReplacementCombo, "replacement-string", "");
        this.updateEnablement(true);
    }

    public void setPattern(Pattern pattern) {
        this.fSearchPattern = pattern;
    }

    public void updateEnablement(boolean searchInProgress) {
        if (this.fSearchInProgress != searchInProgress) {
            this.fSearchInProgress = searchInProgress;
            this.onSelectionChanged(this.fView.getSelection());
        }
    }

    public void onSelected() {
        this.fReplacementCombo.setFocus();
    }

    public void getProperties(Properties props) {
        props.setProperty("replacement-string", this.fReplacementCombo.getText());
    }

    public void setProperties(Properties props) {
        String property = props.getProperty("replacement-string");
        if (property != null) {
            this.fReplacementCombo.setText(property);
            this.onReplacementChange();
        }
    }

    public void fillContextMenu(IMenuManager mgr) {
        ReplaceAction restoreAction;
        ReplaceAction replaceAction;
        IStructuredSelection sel = (IStructuredSelection)this.fView.getTreeViewer().getSelection();
        String replacement = this.getUnescapedReplacementString();
        if (sel != null && !sel.isEmpty()) {
            replaceAction = new ReplaceAction(this.fView, SearchMessages.RetrieverReplaceTab_ReplaceSelected_text, true, sel);
            if (replaceAction.isEnabled()) {
                replaceAction.setReplacement(this.fSearchPattern, replacement);
                mgr.appendToGroup("group.reorganize", (IAction)replaceAction);
            }
            if ((restoreAction = new ReplaceAction(this.fView, SearchMessages.RetrieverReplaceTab_RestoreSelected_text, false, sel)).isEnabled()) {
                mgr.appendToGroup("group.reorganize", (IAction)restoreAction);
            }
        }
        if ((replaceAction = new ReplaceAction(this.fView, SearchMessages.RetrieverReplaceTab_ReplaceAll_text, true)).isEnabled()) {
            replaceAction.setReplacement(this.fSearchPattern, replacement);
            mgr.appendToGroup("group.reorganize", (IAction)replaceAction);
        }
        if ((restoreAction = new ReplaceAction(this.fView, SearchMessages.RetrieverReplaceTab_RestoreAll_text, false)).isEnabled()) {
            mgr.appendToGroup("group.reorganize", (IAction)restoreAction);
        }
    }
}

