/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.ui.text.SearchMatchInformationProvider;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.search2.internal.ui.text2.LineNumberScanner;

public class SearchMatchInformationProviderRegistry {
    private static final String EXTENSION_POINT_ID = "org.eclipse.search.textSearchMatchInformationProvider";
    private static final String ATTRIBUTE_SEPARATOR = ",";
    private static final String ATTRIBUTE_FILE_EXTENSIONS = "fileExtensions";
    private static final String ATTRIBUTE_CONTENT_TYPE_IDS = "contentTypeIDs";
    private static final String ATTRIBUTE_COMMENT_SUPPORT = "supportsComments";
    private static final String ATTRIBUTE_STRING_SUPPORT = "supportsStrings";
    private static final String ATTRIBUTE_INCLUDE_SUPPORT = "supportsIncludes";
    private static final String ATTRIBUTE_PREPROCESSOR_SUPPORT = "supportsPreprocessor";
    private static final String ATTRIBUTE_FUNCTION_SUPPORT = "supportsFunctions";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String NODE_NAME = "textSearchMatchInformationProvider";
    private static final ScannerProxyChain NULL_CHAIN = new ScannerProxyChain();
    private HashMap fContentTypeMap = new HashMap();
    private HashMap fExtensionsMap = new HashMap();
    private SearchMatchInformationProvider fLineNumberScanner = new LineNumberScanner();
    private int fAvailableLocations;

    public SearchMatchInformationProviderRegistry() {
        this.registerExtensions();
    }

    private void registerExtensions() {
        this.fAvailableLocations = 0;
        IConfigurationElement[] extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement elem = extensions[i];
            if (NODE_NAME.equals(elem.getName())) {
                String contentTypeIDs = elem.getAttribute(ATTRIBUTE_CONTENT_TYPE_IDS);
                String fileExtensions = elem.getAttribute(ATTRIBUTE_FILE_EXTENSIONS);
                int locationSupport = this.getLocationSupport(elem);
                this.fAvailableLocations |= locationSupport;
                ScannerProxy proxy = new ScannerProxy(elem, locationSupport);
                this.registerProxy(contentTypeIDs, proxy, this.fContentTypeMap);
                this.registerProxy(fileExtensions, proxy, this.fExtensionsMap);
            }
            ++i;
        }
        this.sortProxyChains(this.fContentTypeMap.values());
        this.sortProxyChains(this.fExtensionsMap.values());
    }

    private void sortProxyChains(Collection chains) {
        Iterator iter = chains.iterator();
        while (iter.hasNext()) {
            ScannerProxyChain chain = (ScannerProxyChain)iter.next();
            chain.sort();
        }
    }

    private int getLocationSupport(IConfigurationElement elem) {
        int result = 0;
        result |= this.hasSupport(elem, ATTRIBUTE_COMMENT_SUPPORT, 4);
        result |= this.hasSupport(elem, ATTRIBUTE_STRING_SUPPORT, 2);
        result |= this.hasSupport(elem, ATTRIBUTE_INCLUDE_SUPPORT, 8);
        result |= this.hasSupport(elem, ATTRIBUTE_PREPROCESSOR_SUPPORT, 16);
        return result |= this.hasSupport(elem, ATTRIBUTE_FUNCTION_SUPPORT, 32);
    }

    private int hasSupport(IConfigurationElement elem, String attrib, int value) {
        String aval = elem.getAttribute(attrib);
        if (aval != null && Boolean.valueOf(aval).booleanValue()) {
            return value;
        }
        return 0;
    }

    private void registerProxy(String idList, ScannerProxy proxy, HashMap map) {
        if (idList != null) {
            String[] ids = idList.split(ATTRIBUTE_SEPARATOR);
            int k = 0;
            while (k < ids.length) {
                String id = ids[k].trim();
                if (id.length() > 0) {
                    ScannerProxyChain chain = (ScannerProxyChain)map.get(id);
                    if (chain == null) {
                        chain = new ScannerProxyChain();
                        map.put(id, chain);
                    }
                    chain.add(proxy);
                }
                ++k;
            }
        }
    }

    public SearchMatchInformationProvider findScanner(IFile file) {
        ScannerProxyChain chain = NULL_CHAIN;
        if (file != null) {
            IProject prj = file.getProject();
            try {
                IContentType ct = prj.getContentTypeMatcher().findContentTypeFor(file.getName());
                if (ct != null) {
                    chain = this.findScanner(ct);
                }
            }
            catch (CoreException e) {
                SearchPlugin.log(e.getStatus());
            }
            if (chain == NULL_CHAIN) {
                chain = this.findScanner(file.getName());
            }
        }
        return chain.getScanner();
    }

    private ScannerProxyChain findScanner(IContentType ct) {
        String id = ct.getId();
        ScannerProxyChain chain = (ScannerProxyChain)this.fContentTypeMap.get(id);
        if (chain != null && (chain == NULL_CHAIN || chain.computeScanner() != null)) {
            return chain;
        }
        chain = (ct = ct.getBaseType()) == null ? NULL_CHAIN : this.findScanner(ct);
        this.fContentTypeMap.put(id, chain);
        return chain;
    }

    private ScannerProxyChain findScanner(String name) {
        int idx = 0;
        while (true) {
            ScannerProxyChain chain;
            if ((chain = (ScannerProxyChain)this.fExtensionsMap.get(name)) != null) {
                if (chain.computeScanner() != null) {
                    return chain;
                }
                this.fExtensionsMap.remove(name);
            }
            if ((idx = name.indexOf(46, 1)) < 0) {
                return NULL_CHAIN;
            }
            name = name.substring(idx);
        }
    }

    public SearchMatchInformationProvider getLineNumberScanner() {
        return this.fLineNumberScanner;
    }

    private static boolean supportsLocation(int locations, int location) {
        return (locations & 1 << location) != 0;
    }

    public boolean hasPreprocessorSupport() {
        return SearchMatchInformationProviderRegistry.supportsLocation(this.fAvailableLocations, 4);
    }

    public boolean hasFunctionSupport() {
        return SearchMatchInformationProviderRegistry.supportsLocation(this.fAvailableLocations, 5);
    }

    private static class ScannerProxyChain {
        private ArrayList fProxies = new ArrayList();
        private SearchMatchInformationProvider fScanner = null;

        ScannerProxyChain() {
        }

        public void sort() {
            Collections.sort(this.fProxies);
        }

        public void add(ScannerProxy proxy) {
            this.fProxies.add(proxy);
        }

        public SearchMatchInformationProvider getScanner() {
            return this.fScanner;
        }

        public SearchMatchInformationProvider computeScanner() {
            if (this.fScanner == null) {
                Iterator iter = this.fProxies.iterator();
                while (this.fScanner == null && iter.hasNext()) {
                    ScannerProxy proxy = (ScannerProxy)iter.next();
                    if (proxy.isDisabled()) {
                        iter.remove();
                        continue;
                    }
                    this.fScanner = proxy.createScanner();
                }
            }
            return this.fScanner;
        }
    }

    private static class ScannerProxy
    implements Comparable {
        public static final ScannerProxy NULL_PROXY = new ScannerProxy(null, 0);
        private IConfigurationElement fConfigElem;
        private int fPriority;
        private boolean fIsDisabled = false;

        public ScannerProxy(IConfigurationElement elem, int locationSupport) {
            this.fConfigElem = elem;
            this.fPriority = this.getPriority(locationSupport);
        }

        public SearchMatchInformationProvider createScanner() {
            SearchMatchInformationProvider[] holder = new SearchMatchInformationProvider[1];
            SafeRunnable code = new SafeRunnable(this, SearchMessages.TextFileScannerRegistry_error_instanciateScanner, holder){
                final /* synthetic */ ScannerProxy this$1;
                private final /* synthetic */ SearchMatchInformationProvider[] val$holder;
                {
                    this.this$1 = scannerProxy;
                    this.val$holder = searchMatchInformationProviderArray;
                }

                public void run() throws Exception {
                    this.val$holder[0] = (SearchMatchInformationProvider)ScannerProxy.access$0(this.this$1).createExecutableExtension("class");
                }

                public void handleException(Throwable e) {
                    this.this$1.disable();
                }
            };
            Platform.run((ISafeRunnable)code);
            return holder[0];
        }

        public int getPriority(int locations) {
            int priority = 0;
            if (SearchMatchInformationProviderRegistry.supportsLocation(locations, 2)) {
                priority += 3;
            }
            if (SearchMatchInformationProviderRegistry.supportsLocation(locations, 1)) {
                priority += 3;
            }
            if (SearchMatchInformationProviderRegistry.supportsLocation(locations, 4)) {
                ++priority;
            }
            if (SearchMatchInformationProviderRegistry.supportsLocation(locations, 3)) {
                priority += 2;
            }
            if (SearchMatchInformationProviderRegistry.supportsLocation(locations, 5)) {
                ++priority;
            }
            return priority;
        }

        public int compareTo(Object o) {
            return -(this.fPriority - ((ScannerProxy)o).fPriority);
        }

        public boolean isDisabled() {
            return this.fIsDisabled;
        }

        public void disable() {
            this.fIsDisabled = true;
        }

        static /* synthetic */ IConfigurationElement access$0(ScannerProxy scannerProxy) {
            return scannerProxy.fConfigElem;
        }
    }
}

