/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.search2.internal.ui.text2.RetrieverViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SimpleResourceSelectionDialog
extends SelectionDialog {
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 400;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 300;
    private String fMessage;
    private CheckboxTreeViewer fTree;

    protected SimpleResourceSelectionDialog(Shell parentShell, String title, String message) {
        super(parentShell);
        this.setTitle(title);
        this.fMessage = message;
    }

    protected Control createDialogArea(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(256));
        Label label = new Label(composite, 64);
        label.setText(this.fMessage);
        GridData data = new GridData(772);
        label.setLayoutData((Object)data);
        label.setFont(font);
        this.fTree = new CheckboxTreeViewer(composite);
        this.fTree.setUseHashlookup(true);
        WorkbenchContentProvider treeContentProvider = new WorkbenchContentProvider();
        this.fTree.setContentProvider((IContentProvider)treeContentProvider);
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
        this.fTree.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)labelProvider, PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.fTree.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.fTree.setSorter((ViewerSorter)new RetrieverViewerSorter((ILabelProvider)labelProvider));
        data = new GridData(1808);
        data.heightHint = 300;
        data.widthHint = 400;
        this.fTree.getControl().setLayoutData((Object)data);
        this.fTree.getControl().setFont(font);
        this.fTree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                SimpleResourceSelectionDialog.this.handleCheckStateChange(event);
            }
        });
        this.fTree.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                Object element = event.getElement();
                if (!SimpleResourceSelectionDialog.this.fTree.getGrayed(element)) {
                    BusyIndicator.showWhile((Display)SimpleResourceSelectionDialog.this.getShell().getDisplay(), (Runnable)new Runnable(this, element){
                        final /* synthetic */ 2 this$1;
                        private final /* synthetic */ Object val$element;
                        {
                            this.this$1 = var1_1;
                            this.val$element = object;
                        }

                        public void run() {
                            SimpleResourceSelectionDialog.access$2(2.access$0(this.this$1), (IContainer)this.val$element, SimpleResourceSelectionDialog.access$1(2.access$0(this.this$1)).getChecked(this.val$element), false);
                        }
                    });
                }
            }

            static /* synthetic */ SimpleResourceSelectionDialog access$0(2 var0) {
                return var0.SimpleResourceSelectionDialog.this;
            }
        });
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayout((Layout)new GridLayout(2, false));
        buttonComposite.setLayoutData((Object)new GridData(256));
        Button selectAllButton = new Button(buttonComposite, 8);
        selectAllButton.setText(SearchMessages.SimpleResourceSelectionDialog_selectAll);
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter((ITreeContentProvider)treeContentProvider){
            private final /* synthetic */ ITreeContentProvider val$treeContentProvider;
            {
                this.val$treeContentProvider = iTreeContentProvider;
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                SimpleResourceSelectionDialog.this.fTree.setGrayedElements(new Object[0]);
                SimpleResourceSelectionDialog.this.fTree.setCheckedElements(this.val$treeContentProvider.getElements(SimpleResourceSelectionDialog.this.fTree.getInput()));
                SimpleResourceSelectionDialog.this.validateInput();
            }
        });
        selectAllButton.setFont(font);
        this.setButtonLayoutData(selectAllButton);
        Button deselectAllButton = new Button(buttonComposite, 8);
        deselectAllButton.setText(SearchMessages.SimpleResourceSelectionDialog_deselectAll);
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SimpleResourceSelectionDialog.this.fTree.setGrayedElements(new Object[0]);
                SimpleResourceSelectionDialog.this.fTree.setCheckedElements(new Object[0]);
                SimpleResourceSelectionDialog.this.validateInput();
            }
        });
        deselectAllButton.setFont(font);
        this.setButtonLayoutData(deselectAllButton);
        this.initializeCheckedState();
        return composite;
    }

    private void handleCheckStateChange(final CheckStateChangedEvent event) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IResource resource = (IResource)event.getElement();
                boolean state = event.getChecked();
                SimpleResourceSelectionDialog.this.fTree.setGrayed((Object)resource, false);
                if (resource instanceof IContainer) {
                    SimpleResourceSelectionDialog.this.setSubtreeChecked((IContainer)resource, state, true);
                }
                SimpleResourceSelectionDialog.this.updateParentState(resource);
                SimpleResourceSelectionDialog.this.validateInput();
            }
        });
    }

    private void setSubtreeChecked(IContainer container, boolean state, boolean checkExpandedState) {
        if (!container.isAccessible() || !this.fTree.getExpandedState((Object)container) && state && checkExpandedState) {
            return;
        }
        IResource[] members = null;
        try {
            members = container.members();
        }
        catch (CoreException ex) {
            SearchPlugin.log(ex.getStatus());
        }
        int i = members.length - 1;
        while (i >= 0) {
            boolean elementGrayChecked;
            IResource element = members[i];
            boolean bl = elementGrayChecked = this.fTree.getGrayed((Object)element) || this.fTree.getChecked((Object)element);
            if (state) {
                this.fTree.setChecked((Object)element, true);
                this.fTree.setGrayed((Object)element, false);
            } else {
                this.fTree.setGrayChecked((Object)element, false);
            }
            if (element instanceof IContainer && (state || elementGrayChecked)) {
                this.setSubtreeChecked((IContainer)element, state, true);
            }
            --i;
        }
    }

    private void updateParentState(IResource child) {
        if (child == null || child.getParent() == null) {
            return;
        }
        IContainer parent = child.getParent();
        boolean childChecked = false;
        IResource[] members = null;
        try {
            members = parent.members();
        }
        catch (CoreException ex) {
            SearchPlugin.log(ex.getStatus());
        }
        int i = members.length - 1;
        while (i >= 0) {
            if (this.fTree.getChecked((Object)members[i]) || this.fTree.getGrayed((Object)members[i])) {
                childChecked = true;
                break;
            }
            --i;
        }
        this.fTree.setGrayChecked((Object)parent, childChecked);
        this.updateParentState((IResource)parent);
    }

    private void initializeCheckedState() {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                List list = SimpleResourceSelectionDialog.this.getInitialElementSelections();
                Object[] items = list.toArray(new IResource[list.size()]);
                SimpleResourceSelectionDialog.this.fTree.setCheckedElements(items);
                int i = 0;
                while (i < items.length) {
                    Object resource = items[i];
                    IContainer container = null;
                    if (resource instanceof IContainer) {
                        container = (IContainer)resource;
                    }
                    if (container != null) {
                        SimpleResourceSelectionDialog.this.setSubtreeChecked(container, true, true);
                    }
                    if (resource != null && !resource.isAccessible()) {
                        IProject project = resource.getProject();
                        if (!SimpleResourceSelectionDialog.this.fTree.getChecked((Object)project)) {
                            SimpleResourceSelectionDialog.this.fTree.setGrayChecked((Object)project, true);
                        }
                    } else {
                        SimpleResourceSelectionDialog.this.updateParentState((IResource)resource);
                    }
                    ++i;
                }
            }
        });
    }

    protected void validateInput() {
    }

    protected void okPressed() {
        Object[] checked = this.fTree.getCheckedElements();
        HashSet<Object> gray = new HashSet<Object>(Arrays.asList(this.fTree.getGrayedElements()));
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < checked.length) {
            Object object = checked[i];
            if (!gray.contains(object)) {
                result.add(object);
            }
            ++i;
        }
        this.setResult(result);
        super.okPressed();
    }
}

