/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.text.bundle;

import java.util.Iterator;
import java.util.TreeMap;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.internal.core.text.bundle.ManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.PackageFriend;
import org.eclipse.pde.internal.core.text.bundle.PackageObject;

public class ExportPackageObject
extends PackageObject {
    private static final String INTERNAL = "x-internal";
    private static final String FRIENDS = "x-friends";
    private static final long serialVersionUID = 1L;
    private TreeMap fFriends = new TreeMap();

    public ExportPackageObject(ManifestHeader header, ManifestElement element, String versionAttribute) {
        super(header, element, versionAttribute);
        this.processFriends();
    }

    public ExportPackageObject(ManifestHeader header, IPackageFragment fragment, String versionAttribute) {
        super(header, fragment.getElementName(), null, versionAttribute);
    }

    protected void processFriends() {
        String[] friends = this.getDirectives(FRIENDS);
        if (friends != null) {
            int i = 0;
            while (i < friends.length) {
                this.fFriends.put(friends[i], new PackageFriend(this, friends[i]));
                ++i;
            }
        }
    }

    public boolean isInternal() {
        return "true".equals(this.getDirective(INTERNAL)) || this.getDirective(FRIENDS) != null;
    }

    public void setInternal(boolean internal) {
        boolean old = this.isInternal();
        if (!internal) {
            this.setDirective(INTERNAL, null);
            this.setDirective(FRIENDS, null);
        } else if (this.fFriends.size() == 0) {
            this.setDirective(INTERNAL, "true");
        } else {
            Iterator iter = this.fFriends.keySet().iterator();
            while (iter.hasNext()) {
                this.addDirective(FRIENDS, iter.next().toString());
            }
        }
        this.fHeader.update();
        this.firePropertyChanged(this, INTERNAL, Boolean.toString(old), Boolean.toString(internal));
    }

    public PackageFriend[] getFriends() {
        return this.fFriends.values().toArray(new PackageFriend[this.fFriends.size()]);
    }

    public void addFriend(PackageFriend friend) {
        this.fFriends.put(friend.getName(), friend);
        this.addDirective(FRIENDS, friend.getName());
        this.setDirective(INTERNAL, null);
        this.fHeader.update();
        this.fireStructureChanged(friend, 1);
    }

    public void removeFriend(PackageFriend friend) {
        this.fFriends.remove(friend.getName());
        this.setDirective(FRIENDS, null);
        if (this.fFriends.size() == 0) {
            this.setDirective(INTERNAL, "true");
        } else {
            Iterator iter = this.fFriends.keySet().iterator();
            while (iter.hasNext()) {
                this.addDirective(FRIENDS, iter.next().toString());
            }
        }
        this.fHeader.update();
        this.fireStructureChanged(friend, 2);
    }

    public boolean hasFriend(String name) {
        return this.fFriends.containsKey(name);
    }

    public boolean hasSameVisibility(ExportPackageObject object) {
        if (object.isInternal() != this.isInternal()) {
            return false;
        }
        if (this.fFriends.size() != object.fFriends.size()) {
            return false;
        }
        Iterator iter = this.fFriends.keySet().iterator();
        while (iter.hasNext()) {
            if (object.fFriends.containsKey(iter.next())) continue;
            return false;
        }
        return true;
    }
}

