/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.history;

import java.text.DateFormat;
import java.util.Date;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class FileRevisionEditorInput
implements IWorkbenchAdapter,
IStorageEditorInput {
    private IFileRevision file;
    private IStorage storage;
    static /* synthetic */ Class class$0;

    public FileRevisionEditorInput(IFileRevision file) {
        this.file = file;
        try {
            this.storage = file.getStorage((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            TeamUIPlugin.log(e);
        }
    }

    public FileRevisionEditorInput(IFileState state) {
        this.storage = state;
        this.file = null;
    }

    public IStorage getStorage() throws CoreException {
        return this.storage;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        if (this.file != null) {
            return NLS.bind((String)TeamUIMessages.nameAndRevision, (Object[])new String[]{this.file.getName(), this.file.getContentIdentifier()});
        }
        if (this.storage != null) {
            return String.valueOf(this.storage.getName()) + " " + DateFormat.getInstance().format(new Date(((IFileState)this.storage).getModificationTime()));
        }
        return "";
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        if (this.file != null) {
            return this.file.getContentIdentifier();
        }
        return "";
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this;
        }
        return null;
    }

    public Object[] getChildren(Object o) {
        return new Object[0];
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        if (this.file != null) {
            return this.file.getName();
        }
        if (this.storage != null) {
            return this.storage.getName();
        }
        return "";
    }

    public Object getParent(Object o) {
        return null;
    }
}

