/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.mapping.IModelCompareInput;
import org.eclipse.team.ui.mapping.ISaveableCompareModel;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISaveableModel;
import org.eclipse.ui.ISaveableModelSource;

public class ModelCompareEditorInput
extends CompareEditorInput
implements ISaveableModelSource,
IPropertyListener {
    private final ModelSynchronizeParticipant participant;
    private final ICompareInput input;
    private final ISaveableModel model;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ModelCompareEditorInput(ModelSynchronizeParticipant participant, ICompareInput input) {
        super(new CompareConfiguration());
        Assert.isNotNull((Object)participant);
        Assert.isNotNull((Object)input);
        this.participant = participant;
        this.input = input;
        this.model = this.asSaveableModel(input);
        this.setDirty(this.model.isDirty());
    }

    private ISaveableModel asSaveableModel(ICompareInput input) {
        IModelCompareInput mci;
        ISaveableCompareModel compareModel;
        if (input instanceof IModelCompareInput && (compareModel = (mci = (IModelCompareInput)input).getCompareModel()) != null) {
            return compareModel;
        }
        return new ISaveableModel(){

            public boolean isDirty() {
                return ModelCompareEditorInput.this.isSaveNeeded();
            }

            public void doSave(IProgressMonitor monitor) {
                try {
                    ModelCompareEditorInput.this.saveChanges(monitor);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageDescriptor.createFromImage((Image)ModelCompareEditorInput.this.getTitleImage());
            }

            public String getToolTipText() {
                return ModelCompareEditorInput.this.getToolTipText();
            }

            public String getName() {
                return ModelCompareEditorInput.this.getTitle();
            }
        };
    }

    public Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        if (this.model instanceof ISaveableCompareModel) {
            final ISaveableCompareModel scm = (ISaveableCompareModel)this.model;
            scm.addPropertyListener(this);
            control.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    scm.removePropertyListener(ModelCompareEditorInput.this);
                }
            });
        }
        return control;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.setTitle(this.getTitle());
        monitor.beginTask(TeamUIMessages.SyncInfoCompareInput_3, 100);
        monitor.setTaskName(TeamUIMessages.SyncInfoCompareInput_3);
        try {
            try {
                IModelCompareInput adapter = this.asModelCompareInput(this.input);
                if (adapter != null) {
                    adapter.prepareInput(this.getCompareConfiguration(), Policy.subMonitorFor(monitor, 100));
                }
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var3_6 = null;
        }
        monitor.done();
        return this.input;
    }

    private IModelCompareInput asModelCompareInput(ICompareInput input) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.team.ui.mapping.IModelCompareInput");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IModelCompareInput)Utils.getAdapter(input, clazz);
    }

    public boolean matches(Object object) {
        ICompareInput input = this.participant.asCompareInput(object);
        if (input != null) {
            return input.equals(this.input);
        }
        return false;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ModelCompareEditorInput) {
            ModelCompareEditorInput otherInput = (ModelCompareEditorInput)((Object)other);
            return this.input.equals(otherInput.input);
        }
        return false;
    }

    public ISaveableModel[] getModels() {
        return new ISaveableModel[]{this.model};
    }

    public ISaveableModel[] getActiveModels() {
        return new ISaveableModel[]{this.model};
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 257) {
            this.setDirty(this.model.isDirty());
        }
    }

    public Object getAdapter(Class adapter) {
        IResource resource;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter) && (resource = Utils.getResource(this.input)) instanceof IFile) {
            return resource;
        }
        return super.getAdapter(adapter);
    }
}

