/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.ui.mapping.ISaveableCompareModel;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public abstract class ModelProviderAction
extends BaseSelectionListenerAction {
    private final ISynchronizePageConfiguration configuration;

    public ModelProviderAction(String text, ISynchronizePageConfiguration configuration) {
        super(text);
        this.configuration = configuration;
        this.initialize(configuration);
    }

    private void initialize(ISynchronizePageConfiguration configuration) {
        configuration.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
        configuration.getPage().getViewer().getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ModelProviderAction.this.getConfiguration().getSite().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)ModelProviderAction.this);
            }
        });
    }

    protected ISynchronizePageConfiguration getConfiguration() {
        return this.configuration;
    }

    public void selectionChanged(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            super.selectionChanged((IStructuredSelection)selection);
        } else {
            super.selectionChanged((IStructuredSelection)StructuredSelection.EMPTY);
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        super.updateSelection(selection);
        return this.isEnabledForSelection(selection);
    }

    protected abstract boolean isEnabledForSelection(IStructuredSelection var1);

    protected ISynchronizationContext getSynchronizationContext() {
        return (ISynchronizationContext)this.getConfiguration().getProperty("org.eclipse.team.ui.synchronizationContext");
    }

    protected boolean isVisible(IDiff node) {
        ISynchronizePageConfiguration configuration = this.getConfiguration();
        if (configuration.getComparisonType() == "three-way" && node instanceof IThreeWayDiff) {
            IThreeWayDiff twd = (IThreeWayDiff)node;
            int mode = configuration.getMode();
            switch (mode) {
                case 1: {
                    if (twd.getDirection() != 768 && twd.getDirection() != 512) break;
                    return true;
                }
                case 2: {
                    if (twd.getDirection() != 768 && twd.getDirection() != 256) break;
                    return true;
                }
                case 8: {
                    if (twd.getDirection() != 768) break;
                    return true;
                }
                case 4: {
                    return true;
                }
            }
        }
        return false;
    }

    protected void handleBufferChange() throws InvocationTargetException, InterruptedException {
        final ISaveableCompareModel targetBuffer = this.getTargetBuffer();
        final ISaveableCompareModel currentBuffer = this.getActiveBuffer();
        if (currentBuffer != null && currentBuffer.isDirty()) {
            PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        ModelProviderAction.handleBufferChange(ModelProviderAction.this.configuration.getSite().getShell(), targetBuffer, currentBuffer, true, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        this.setActiveBuffer(targetBuffer);
    }

    public static void handleBufferChange(Shell shell, ISaveableCompareModel targetBuffer, ISaveableCompareModel currentBuffer, boolean allowCancel, IProgressMonitor monitor) throws CoreException, InterruptedException {
        if (currentBuffer != null && targetBuffer != currentBuffer && currentBuffer.isDirty()) {
            if (ModelProviderAction.promptToSaveChanges(shell, currentBuffer, allowCancel)) {
                currentBuffer.doSave(monitor);
            } else {
                currentBuffer.doRevert(monitor);
            }
        }
    }

    public static boolean promptToSaveChanges(final Shell shell, final ISaveableCompareModel buffer, final boolean allowCancel) throws InterruptedException {
        final int[] result = new int[1];
        Runnable runnable = new Runnable(){

            public void run() {
                String[] options = allowCancel ? new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL} : new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};
                MessageDialog dialog = new MessageDialog(shell, "Save Changes", null, NLS.bind((String)"{0} has unsaved changes. Do you want to save them?", (Object)buffer.getName()), 3, options, result[0]);
                result[0] = dialog.open();
            }
        };
        shell.getDisplay().syncExec(runnable);
        if (result[0] == 2) {
            throw new InterruptedException();
        }
        return result[0] == 0;
    }

    protected ISaveableCompareModel getActiveBuffer() {
        return ((ModelSynchronizeParticipant)this.configuration.getParticipant()).getActiveModel();
    }

    protected void setActiveBuffer(ISaveableCompareModel buffer) {
        ((ModelSynchronizeParticipant)this.configuration.getParticipant()).setActiveModel(buffer);
    }

    protected ISaveableCompareModel getTargetBuffer() {
        return null;
    }
}

