/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.mapping.SynchronizationContentProvider;
import org.eclipse.ui.model.WorkbenchContentProvider;

public class ResourceModelContentProvider
extends SynchronizationContentProvider {
    private WorkbenchContentProvider provider;

    protected ITreeContentProvider getDelegateContentProvider() {
        if (this.provider == null) {
            this.provider = new WorkbenchContentProvider();
        }
        return this.provider;
    }

    protected String getModelProviderId() {
        return "org.eclipse.core.resources.modelProvider";
    }

    protected Object getModelRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected boolean isInScope(ISynchronizationScope scope, Object parent, Object object) {
        if (object instanceof IResource) {
            IResource resource = (IResource)object;
            if (resource == null) {
                return false;
            }
            if (scope.contains(resource)) {
                return true;
            }
            if (this.hasChildrenInScope(scope, object, resource)) {
                return true;
            }
        }
        return false;
    }

    private boolean hasChildrenInScope(ISynchronizationScope scope, Object object, IResource resource) {
        IResource[] roots = scope.getRoots();
        int i = 0;
        while (i < roots.length) {
            IResource root = roots[i];
            if (resource.getFullPath().isPrefixOf(root.getFullPath())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void dispose() {
        this.provider.dispose();
        super.dispose();
    }

    protected Object[] getChildrenInContext(ISynchronizationContext context, Object parent, Object[] children) {
        if (parent instanceof IResource) {
            IResource resource = (IResource)parent;
            HashSet<Object> result = new HashSet<Object>();
            int i = 0;
            while (i < children.length) {
                Object object = children[i];
                result.add(object);
                ++i;
            }
            IPath[] childPaths = context.getDiffTree().getChildren(resource.getFullPath());
            int i2 = 0;
            while (i2 < childPaths.length) {
                IPath path = childPaths[i2];
                IDiff delta = context.getDiffTree().getDiff(path);
                Object child = delta == null ? (path.segmentCount() == 1 ? ((IWorkspaceRoot)resource).getProject(path.lastSegment()) : ((IContainer)resource).getFolder((IPath)new Path(path.lastSegment()))) : context.getDiffTree().getResource(delta);
                if (this.isInScope(context.getScope(), parent, child)) {
                    result.add(child);
                }
                ++i2;
            }
            return super.getChildrenInContext(context, parent, result.toArray(new Object[result.size()]));
        }
        return super.getChildrenInContext(context, parent, children);
    }

    protected ResourceTraversal[] getTraversals(ISynchronizationContext context, Object object) {
        ISynchronizationScope scope = context.getScope();
        ResourceMapping mapping = scope.getMapping(object);
        if (mapping != null) {
            return scope.getTraversals(mapping);
        }
        if (object instanceof IResource) {
            IResource resource = (IResource)object;
            if (scope.contains(resource)) {
                ArrayList<ResourceTraversal> result = new ArrayList<ResourceTraversal>();
                ResourceTraversal[] traversals = scope.getTraversals();
                int i = 0;
                while (i < traversals.length) {
                    ResourceTraversal traversal = traversals[i];
                    if (traversal.contains(resource)) {
                        boolean include = false;
                        int depth = traversal.getDepth();
                        if (depth == 2) {
                            include = true;
                        } else {
                            IResource[] roots = traversal.getResources();
                            int j = 0;
                            while (j < roots.length) {
                                IResource root = roots[j];
                                if (root.equals((Object)resource)) {
                                    include = true;
                                    break;
                                }
                                if (root.getFullPath().equals((Object)resource.getFullPath().removeLastSegments(1)) && depth == 1) {
                                    include = true;
                                    depth = 0;
                                    break;
                                }
                                ++j;
                            }
                        }
                        if (include) {
                            result.add(new ResourceTraversal(new IResource[]{resource}, depth, 0));
                        }
                    }
                    ++i;
                }
                return result.toArray(new ResourceTraversal[result.size()]);
            }
            ResourceMapping[] mappings = scope.getMappings("org.eclipse.core.resources.modelProvider");
            ArrayList<ResourceTraversal> result = new ArrayList<ResourceTraversal>();
            int i = 0;
            while (i < mappings.length) {
                ResourceMapping resourceMapping = mappings[i];
                if (resourceMapping.getModelObject() instanceof IResource) {
                    IResource root = (IResource)resourceMapping.getModelObject();
                    if (resource.getFullPath().isPrefixOf(root.getFullPath()) && (mapping = scope.getMapping((Object)root)) != null) {
                        ResourceTraversal[] traversals = scope.getTraversals(mapping);
                        result.addAll(Arrays.asList(traversals));
                    }
                }
                ++i;
            }
            return result.toArray(new ResourceTraversal[result.size()]);
        }
        return new ResourceTraversal[0];
    }

    protected boolean hasChildrenInContext(ISynchronizationContext context, Object element) {
        if (element instanceof IContainer) {
            IResourceDiffTree tree;
            IContainer container = (IContainer)element;
            if (context != null && (tree = context.getDiffTree()).getChildren(container.getFullPath()).length > 0) {
                return true;
            }
        }
        return false;
    }

    public void propertyChanged(int property, final IPath[] paths) {
        Utils.syncExec(new Runnable(){

            public void run() {
                Object[] resources;
                ISynchronizationContext context = ResourceModelContentProvider.this.getContext();
                if (context != null && (resources = ResourceModelContentProvider.this.getResources(paths)).length > 0) {
                    ((AbstractTreeViewer)ResourceModelContentProvider.this.getViewer()).update(resources, null);
                }
            }
        }, (StructuredViewer)this.getViewer());
    }

    private IResource[] getResources(IPath[] paths) {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        int i = 0;
        while (i < paths.length) {
            IPath path = paths[i];
            IResource resource = this.getResource(path);
            if (resource != null) {
                resources.add(resource);
            }
            ++i;
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    private IResource getResource(IPath path) {
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (resource != null) {
            return resource;
        }
        ISynchronizationContext context = this.getContext();
        if (context != null) {
            IResourceDiffTree diffTree = context.getDiffTree();
            IDiff node = diffTree.getDiff(path);
            if (node != null) {
                return diffTree.getResource(node);
            }
            if (diffTree.getChildren(path).length > 0) {
                if (path.segmentCount() == 1) {
                    return ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
                }
                if (path.segmentCount() > 1) {
                    return ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
                }
            }
        }
        return null;
    }

    protected StructuredViewer getStructuredViewer() {
        return (StructuredViewer)this.getViewer();
    }
}

