/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.core.diff.FastDiffFilter;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.mapping.SynchronizationOperation;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public abstract class ResourceModelProviderOperation
extends SynchronizationOperation {
    protected ResourceModelProviderOperation(ISynchronizePageConfiguration configuration, Object[] elements) {
        super(configuration, elements);
    }

    protected IDiff[] getFileDeltas(Object[] elements) {
        HashSet<IDiff> result = new HashSet<IDiff>();
        int j = 0;
        while (j < elements.length) {
            Object element = elements[j];
            IDiff[] diffs = this.getFileDeltas(element);
            int i = 0;
            while (i < diffs.length) {
                IDiff node = diffs[i];
                result.add(node);
                ++i;
            }
            ++j;
        }
        return result.toArray(new IDiff[result.size()]);
    }

    private IDiff[] getFileDeltas(Object o) {
        IResource resource = Utils.getResource(o);
        if (resource != null) {
            ISynchronizationContext context = this.getContext();
            IResourceDiffTree diffTree = context.getDiffTree();
            if (resource.getType() == 1) {
                IDiff delta = diffTree.getDiff(resource);
                if (this.getDiffFilter().select(delta)) {
                    return new IDiff[]{delta};
                }
            } else {
                ResourceTraversal[] traversals = this.getTraversals(o);
                IDiff[] diffs = diffTree.getDiffs(traversals);
                ArrayList<IDiff> result = new ArrayList<IDiff>();
                int i = 0;
                while (i < diffs.length) {
                    IDiff node = diffs[i];
                    if (this.isVisible(node) && this.getDiffFilter().select(node)) {
                        result.add(node);
                    }
                    ++i;
                }
                return result.toArray(new IDiff[result.size()]);
            }
        }
        return new IDiff[0];
    }

    protected boolean isVisible(IDiff node) {
        ISynchronizePageConfiguration configuration = this.getConfiguration();
        if (configuration.getComparisonType() == "three-way" && node instanceof IThreeWayDiff) {
            IThreeWayDiff twd = (IThreeWayDiff)node;
            int mode = configuration.getMode();
            switch (mode) {
                case 1: {
                    if (twd.getDirection() != 768 && twd.getDirection() != 512) break;
                    return true;
                }
                case 2: {
                    if (twd.getDirection() != 768 && twd.getDirection() != 256) break;
                    return true;
                }
                case 8: {
                    if (twd.getDirection() != 768) break;
                    return true;
                }
                case 4: {
                    return true;
                }
            }
        }
        return false;
    }

    private ResourceTraversal[] getTraversals(Object o) {
        ResourceMapping mapping = Utils.getResourceMapping(o);
        if (mapping != null) {
            ResourceTraversal[] traversals = this.getContext().getScope().getTraversals(mapping);
            if (traversals != null) {
                return traversals;
            }
            try {
                return mapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                TeamUIPlugin.log(e);
            }
        }
        return new ResourceTraversal[0];
    }

    protected abstract FastDiffFilter getDiffFilter();

    public boolean shouldRun() {
        return this.getFileDeltas(this.getElements()).length > 0;
    }
}

