/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.registry.TeamContentProviderDescriptor;
import org.eclipse.team.ui.mapping.ITeamContentProviderDescriptor;
import org.eclipse.team.ui.mapping.ITeamContentProviderManager;

public class TeamContentProviderManager
implements ITeamContentProviderManager {
    public static final String PT_TEAM_CONTENT_PROVIDERS = "teamContentProviders";
    private static ITeamContentProviderManager instance;
    Map descriptors;

    public static ITeamContentProviderManager getInstance() {
        if (instance == null) {
            instance = new TeamContentProviderManager();
        }
        return instance;
    }

    public ITeamContentProviderDescriptor[] getDescriptors() {
        this.lazyInitialize();
        return this.descriptors.values().toArray(new ITeamContentProviderDescriptor[this.descriptors.size()]);
    }

    public String[] getContentProviderIds() {
        ArrayList<String> result = new ArrayList<String>();
        ITeamContentProviderDescriptor[] descriptors = this.getDescriptors();
        int i = 0;
        while (i < descriptors.length) {
            ITeamContentProviderDescriptor descriptor = descriptors[i];
            result.add(descriptor.getContentExtensionId());
            ++i;
        }
        result.add("org.eclipse.team.ui.navigatorContent");
        return result.toArray(new String[result.size()]);
    }

    public ITeamContentProviderDescriptor getDescriptor(String modelProviderId) {
        this.lazyInitialize();
        return (ITeamContentProviderDescriptor)this.descriptors.get(modelProviderId);
    }

    protected void lazyInitialize() {
        if (this.descriptors != null) {
            return;
        }
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.team.ui", PT_TEAM_CONTENT_PROVIDERS);
        IExtension[] extensions = point.getExtensions();
        this.descriptors = new HashMap(extensions.length * 2);
        int i = 0;
        int imax = extensions.length;
        while (i < imax) {
            TeamContentProviderDescriptor desc = null;
            try {
                desc = new TeamContentProviderDescriptor(extensions[i]);
            }
            catch (CoreException e) {
                TeamUIPlugin.log(e);
            }
            if (desc != null) {
                this.descriptors.put(desc.getModelProviderId(), desc);
            }
            ++i;
        }
    }
}

