/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.mapping;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.ResourceMarkAsMergedHandler;
import org.eclipse.team.internal.ui.mapping.ResourceMergeHandler;
import org.eclipse.team.ui.mapping.ISaveableCompareModel;
import org.eclipse.team.ui.mapping.SynchronizationOperation;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public abstract class MergeActionHandler
extends AbstractHandler {
    private final ISynchronizePageConfiguration configuration;
    private boolean enabled = false;
    private ISelectionChangedListener listener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            MergeActionHandler.this.updatedEnablement(event);
        }
    };

    public static IHandler getDefaultHandler(String mergeActionId, ISynchronizePageConfiguration configuration) {
        if (mergeActionId == "org.eclipse.team.ui.mergeAction") {
            return new ResourceMergeHandler(configuration, false);
        }
        if (mergeActionId == "org.eclipse.team.ui.overwriteAction") {
            return new ResourceMergeHandler(configuration, true);
        }
        if (mergeActionId == "org.eclipse.team.ui.markAsMergeAction") {
            return new ResourceMarkAsMergedHandler(configuration);
        }
        return null;
    }

    public MergeActionHandler(ISynchronizePageConfiguration configuration) {
        this.configuration = configuration;
        this.getSelectionProvider().addSelectionChangedListener(this.listener);
        this.updateEnablement((IStructuredSelection)this.getSelectionProvider().getSelection());
    }

    public void dispose() {
        this.getSelectionProvider().removeSelectionChangedListener(this.listener);
    }

    void updatedEnablement(SelectionChangedEvent event) {
        this.updateEnablement((IStructuredSelection)event.getSelection());
    }

    protected void updateEnablement(IStructuredSelection selection) {
        boolean isEnabled = this.getOperation().shouldRun();
        this.setEnabled(isEnabled);
    }

    protected final ISynchronizePageConfiguration getConfiguration() {
        return this.configuration;
    }

    protected final IStructuredSelection getStructuredSelection() {
        return (IStructuredSelection)this.getSelectionProvider().getSelection();
    }

    private ISelectionProvider getSelectionProvider() {
        return this.getConfiguration().getSite().getSelectionProvider();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected void setEnabled(boolean isEnabled) {
        if (this.enabled != isEnabled) {
            this.enabled = isEnabled;
            this.fireHandlerChanged(new HandlerEvent((IHandler)this, true, false));
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            this.getOperation().run();
        }
        catch (InvocationTargetException e) {
            Utils.handle(e);
        }
        catch (InterruptedException interruptedException) {}
        return null;
    }

    protected abstract SynchronizationOperation getOperation();

    public ISaveableCompareModel getTargetBuffer() {
        return this.getOperation().getTargetBuffer();
    }
}

