/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.mapping;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.diff.FastDiffFilter;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffTree;
import org.eclipse.team.core.diff.IDiffVisitor;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.mapping.IMergeContext;
import org.eclipse.team.core.mapping.IResourceMappingMerger;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.mapping.ModelOperation;
import org.eclipse.ui.IWorkbenchPart;

public abstract class ModelMergeOperation
extends ModelOperation {
    static /* synthetic */ Class class$0;

    public static IStatus validateMerge(IMergeContext context, IProgressMonitor monitor) {
        ModelProvider[] providers = context.getScope().getModelProviders();
        monitor.beginTask(null, 100 * providers.length);
        ArrayList<IStatus> notOK = new ArrayList<IStatus>();
        int i = 0;
        while (i < providers.length) {
            ModelProvider provider = providers[i];
            IStatus status = ModelMergeOperation.validateMerge(provider, context, Policy.subMonitorFor(monitor, 100));
            if (!status.isOK()) {
                notOK.add(status);
            }
            ++i;
        }
        if (notOK.isEmpty()) {
            return Status.OK_STATUS;
        }
        if (notOK.size() == 1) {
            return (IStatus)notOK.get(0);
        }
        return new MultiStatus("org.eclipse.team.ui", 0, notOK.toArray(new IStatus[notOK.size()]), TeamUIMessages.ResourceMappingMergeOperation_3, null);
    }

    private static IStatus validateMerge(ModelProvider provider, IMergeContext context, IProgressMonitor monitor) {
        IResourceMappingMerger merger = ModelMergeOperation.getMerger(provider);
        if (merger == null) {
            return Status.OK_STATUS;
        }
        return merger.validateMerge(context, monitor);
    }

    private static IResourceMappingMerger getMerger(ModelProvider provider) {
        Assert.isNotNull((Object)provider);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.team.core.mapping.IResourceMappingMerger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IResourceMappingMerger)Utils.getAdapter(provider, clazz);
    }

    protected ModelMergeOperation(IWorkbenchPart part, ISynchronizationScopeManager manager) {
        super(part, manager);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            try {
                monitor.beginTask(null, 100);
                this.initializeContext(Policy.subMonitorFor(monitor, 75));
                this.executeMerge(Policy.subMonitorFor(monitor, 25));
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        monitor.done();
    }

    protected void executeMerge(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, 100);
        if (!this.hasChangesOfInterest()) {
            this.handleNoChanges();
        } else if (this.isPreviewRequested()) {
            this.handlePreviewRequest();
        } else {
            IStatus status = ModelMergeOperation.validateMerge(this.getMergeContext(), Policy.subMonitorFor(monitor, 10));
            if (!status.isOK()) {
                this.handleValidationFailure(status);
            }
            if (!(status = this.performMerge(Policy.subMonitorFor(monitor, 90))).isOK()) {
                this.handleMergeFailure(status);
            }
        }
        monitor.done();
    }

    protected void handlePreviewRequest() {
    }

    protected abstract void initializeContext(IProgressMonitor var1) throws CoreException;

    protected void handleValidationFailure(IStatus status) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                MessageDialog.openInformation((Shell)ModelMergeOperation.this.getShell(), (String)"Validation Failure", (String)"Better message to come.");
            }
        });
        this.handlePreviewRequest();
    }

    protected void handleMergeFailure(IStatus status) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                MessageDialog.openInformation((Shell)ModelMergeOperation.this.getShell(), (String)TeamUIMessages.MergeIncomingChangesAction_0, (String)TeamUIMessages.MergeIncomingChangesAction_1);
            }
        });
        this.handlePreviewRequest();
    }

    protected void handleNoChanges() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                MessageDialog.openInformation((Shell)ModelMergeOperation.this.getShell(), (String)TeamUIMessages.ResourceMappingMergeOperation_0, (String)TeamUIMessages.ResourceMappingMergeOperation_1);
            }
        });
    }

    protected IStatus performMerge(IProgressMonitor monitor) throws CoreException {
        ISynchronizationContext sc = this.getContext();
        if (sc instanceof IMergeContext) {
            IMergeContext context = (IMergeContext)sc;
            final ModelProvider[] providers = ModelMergeOperation.sortByExtension(context.getScope().getModelProviders());
            final IStatus[] result = new IStatus[]{Status.OK_STATUS};
            context.run(new IWorkspaceRunnable(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor monitor) throws CoreException {
                    block8: {
                        block7: {
                            try {
                                monitor.beginTask(null, -1);
                                int i = 0;
                                while (i < providers.length) {
                                    ModelProvider provider = providers[i];
                                    IStatus status = ModelMergeOperation.this.performMerge(provider, Policy.subMonitorFor(monitor, -1));
                                    if (!status.isOK()) {
                                        result[0] = status;
                                        Object var5_5 = null;
                                        break block7;
                                    }
                                    try {
                                        Platform.getJobManager().join((Object)ModelMergeOperation.this.getContext(), monitor);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                    ++i;
                                }
                                break block8;
                            }
                            catch (Throwable throwable) {
                                Object var5_6 = null;
                                monitor.done();
                                throw throwable;
                            }
                        }
                        monitor.done();
                        return;
                    }
                    Object var5_7 = null;
                    monitor.done();
                }
            }, null, 0, monitor);
            return result[0];
        }
        return this.noMergeContextAvailable();
    }

    protected IStatus performMerge(ModelProvider provider, IProgressMonitor monitor) throws CoreException {
        ISynchronizationContext sc = this.getContext();
        if (sc instanceof IMergeContext) {
            IMergeContext context = (IMergeContext)sc;
            IResourceMappingMerger merger = ModelMergeOperation.getMerger(provider);
            if (merger != null) {
                IStatus status = merger.merge(context, monitor);
                if (status.isOK() || status.getCode() == 1) {
                    return status;
                }
                throw new TeamException(status);
            }
            return Status.OK_STATUS;
        }
        return this.noMergeContextAvailable();
    }

    private IStatus noMergeContextAvailable() {
        throw new IllegalStateException("Merges should only be attemped for operations that have a merge context");
    }

    protected boolean hasChangesOfInterest() {
        return !this.getContext().getDiffTree().isEmpty() && this.hasIncomingChanges((IDiffTree)this.getContext().getDiffTree());
    }

    protected boolean hasChangesMatching(IDiffTree tree, final FastDiffFilter filter) {
        final CoreException found = new CoreException(Status.OK_STATUS);
        try {
            tree.accept(ResourcesPlugin.getWorkspace().getRoot().getFullPath(), new IDiffVisitor(){

                public boolean visit(IDiff delta) throws CoreException {
                    if (filter.select(delta)) {
                        throw found;
                    }
                    return false;
                }
            }, 2);
        }
        catch (CoreException e) {
            if (e == found) {
                return true;
            }
            TeamUIPlugin.log(e);
        }
        return false;
    }

    private boolean hasIncomingChanges(IDiffTree tree) {
        return this.hasChangesMatching(tree, new FastDiffFilter(){

            public boolean select(IDiff node) {
                if (node instanceof IThreeWayDiff) {
                    IThreeWayDiff twd = (IThreeWayDiff)node;
                    int direction = twd.getDirection();
                    return direction == 512 || direction == 768;
                }
                return true;
            }
        });
    }

    private IMergeContext getMergeContext() {
        return (IMergeContext)this.getContext();
    }
}

