/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.mapping;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.mapping.IResourceDiff;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.FileStateTypedElement;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;
import org.eclipse.team.ui.mapping.IModelCompareInput;
import org.eclipse.team.ui.mapping.ISaveableCompareModel;
import org.eclipse.team.ui.mapping.ISynchronizationCompareAdapter;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class SynchronizationCompareAdapter
implements ISynchronizationCompareAdapter {
    static /* synthetic */ Class class$0;

    public ICompareInput asCompareInput(ISynchronizationContext context, Object o) {
        IDiff node;
        IResource resource = Utils.getResource(o);
        if (resource != null && resource.getType() == 1 && (node = context.getDiffTree().getDiff(resource)) != null) {
            return new ResourceDiffCompareInput(node);
        }
        return null;
    }

    public boolean hasCompareInput(ISynchronizationContext context, Object object) {
        return this.asCompareInput(context, object) != null;
    }

    public long countFor(ISynchronizationContext context, int state, int mask) {
        return context.getDiffTree().countFor(state, mask);
    }

    public String getName(ResourceMapping mapping) {
        String label;
        IWorkbenchAdapter adapter;
        Object object = mapping.getModelObject();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (IWorkbenchAdapter)Utils.getAdapter(object, clazz)) != null && (label = adapter.getLabel(object)) != null) {
            return label;
        }
        IResource resource = Utils.getResource(object);
        if (resource != null) {
            return resource.getName();
        }
        if (object instanceof ModelProvider) {
            ModelProvider provider = (ModelProvider)object;
            return provider.getDescriptor().getLabel();
        }
        return "";
    }

    public IPath getFullPath(ResourceMapping mapping) {
        IWorkbenchAdapter adapter;
        Object object = mapping.getModelObject();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (IWorkbenchAdapter)Utils.getAdapter(object, clazz)) != null) {
            ArrayList<String> segments = new ArrayList<String>();
            Object parent = object;
            do {
                String segment;
                if ((segment = adapter.getLabel(parent)) == null || segment.length() <= 0) continue;
                segments.add(0, segment);
            } while ((parent = adapter.getParent(parent)) != null);
            if (!segments.isEmpty()) {
                Path path = Path.EMPTY;
                Iterator iter = segments.iterator();
                while (iter.hasNext()) {
                    String segment = (String)iter.next();
                    path = path.append(segment);
                }
                return path;
            }
        }
        return new Path(this.getName(mapping));
    }

    public void save(ResourceMapping[] mappings, IMemento memento) {
    }

    public ResourceMapping[] restore(IMemento memento) {
        return new ResourceMapping[0];
    }

    private static class ResourceDiffCompareInput
    extends DiffNode
    implements IModelCompareInput,
    IAdaptable {
        private final IDiff node;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        public ResourceDiffCompareInput(IDiff node) {
            super(ResourceDiffCompareInput.getCompareKind(node), ResourceDiffCompareInput.getAncestor(node), ResourceDiffCompareInput.getLeftContributor(node), ResourceDiffCompareInput.getRightContributor(node));
            this.node = node;
        }

        private static int getCompareKind(IDiff node) {
            switch (node.getKind()) {
                case 4: {
                    return 3;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
            }
            return 0;
        }

        private static ITypedElement getRightContributor(IDiff node) {
            if (node instanceof IResourceDiff) {
                IResourceDiff rd = (IResourceDiff)node;
                return ResourceDiffCompareInput.asTypedElement(rd.getAfterState());
            }
            if (node instanceof IThreeWayDiff) {
                IThreeWayDiff twd = (IThreeWayDiff)node;
                IResourceDiff diff = (IResourceDiff)twd.getRemoteChange();
                if (diff != null) {
                    return ResourceDiffCompareInput.getRightContributor((IDiff)diff);
                }
                diff = (IResourceDiff)twd.getLocalChange();
                return ResourceDiffCompareInput.asTypedElement(diff.getBeforeState());
            }
            return null;
        }

        private static ITypedElement getLeftContributor(IDiff node) {
            IResource resource = ResourceDiffTree.getResourceFor((IDiff)node);
            return new LocalResourceTypedElement(resource, resource, node){
                private final /* synthetic */ IResource val$resource;
                private final /* synthetic */ IDiff val$node;
                {
                    this.val$resource = iResource;
                    this.val$node = iDiff;
                }

                public boolean isEditable() {
                    if (!this.val$resource.exists() && this.isOutgoingDeletion(this.val$node)) {
                        return false;
                    }
                    return super.isEditable();
                }

                private boolean isOutgoingDeletion(IDiff node) {
                    if (node instanceof IThreeWayDiff) {
                        IThreeWayDiff twd = (IThreeWayDiff)node;
                        return twd.getKind() == 2 && twd.getDirection() == 256;
                    }
                    return false;
                }
            };
        }

        private static ITypedElement getAncestor(IDiff node) {
            if (node instanceof IThreeWayDiff) {
                IThreeWayDiff twd = (IThreeWayDiff)node;
                IResourceDiff diff = (IResourceDiff)twd.getLocalChange();
                if (diff == null) {
                    diff = (IResourceDiff)twd.getRemoteChange();
                }
                return ResourceDiffCompareInput.asTypedElement(diff.getBeforeState());
            }
            return null;
        }

        private static ITypedElement asTypedElement(IFileRevision state) {
            if (state == null) {
                return null;
            }
            return new FileStateTypedElement(state);
        }

        public void prepareInput(CompareConfiguration configuration, IProgressMonitor monitor) throws CoreException {
            Utils.updateLabels(this.node, configuration);
        }

        public ISaveableCompareModel getCompareModel() {
            return null;
        }

        public Object getAdapter(Class adapter) {
            block15: {
                block14: {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (adapter == clazz) break block14;
                    Class<?> clazz2 = class$1;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (adapter != clazz2) break block15;
                }
                if (this.node instanceof IResourceDiff) {
                    IResourceDiff rd = (IResourceDiff)this.node;
                    return (IFile)rd.getResource();
                }
                if (this.node instanceof IThreeWayDiff) {
                    IThreeWayDiff twd = (IThreeWayDiff)this.node;
                    IResourceDiff diff = (IResourceDiff)twd.getRemoteChange();
                    if (diff != null) {
                        return (IFile)diff.getResource();
                    }
                    diff = (IResourceDiff)twd.getLocalChange();
                    return (IFile)diff.getResource();
                }
            }
            return null;
        }
    }
}

