/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import java.util.ArrayList;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.mapping.IModelProviderDescriptor;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.mapping.IMergeContext;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.MergeContext;
import org.eclipse.team.core.mapping.provider.SynchronizationContext;
import org.eclipse.team.core.mapping.provider.SynchronizationScopeManager;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.ModelProviderAction;
import org.eclipse.team.internal.ui.mapping.ModelSynchronizePage;
import org.eclipse.team.internal.ui.synchronize.IRefreshSubscriberListener;
import org.eclipse.team.internal.ui.synchronize.IRefreshable;
import org.eclipse.team.internal.ui.synchronize.RefreshModelParticipantJob;
import org.eclipse.team.internal.ui.synchronize.RefreshParticipantJob;
import org.eclipse.team.internal.ui.synchronize.RefreshUserNotificationPolicy;
import org.eclipse.team.internal.ui.synchronize.SubscriberRefreshSchedule;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.mapping.IModelCompareInput;
import org.eclipse.team.ui.mapping.ISaveableCompareModel;
import org.eclipse.team.ui.mapping.ISynchronizationCompareAdapter;
import org.eclipse.team.ui.synchronize.AbstractSynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipantActionGroup;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISaveableModel;
import org.eclipse.ui.ISaveableModelSource;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPageBookViewPage;

public class ModelSynchronizeParticipant
extends AbstractSynchronizeParticipant
implements ISaveableModelSource {
    public static final String PROP_ACTIVE_SAVEABLE_MODEL = "org.eclipse.team.ui.ACTIVE_SAVEABLE_MODEL";
    public static final String PROP_DIRTY = "org.eclipse.team.ui.DIRTY";
    private static final String CTX_PARTICIPANT_SETTINGS = "org.eclipse.team.ui.MODEL_PARTICIPANT_SETTINGS";
    private static final String CTX_REFRESH_SCHEDULE_SETTINGS = "org.eclipse.team.ui.MODEL_PARTICIPANT_REFRESH_SCHEDULE";
    private static final String CTX_DESCRIPTION = "org.eclipse.team.ui.MODEL_PARTICIPANT_DESCRIPTION";
    private static final String CTX_PARTICIPANT_MAPPINGS = "org.eclipse.team.ui.MODEL_PARTICIPANT_MAPPINGS";
    private static final String CTX_MODEL_PROVIDER_ID = "modelProviderId";
    private static final String CTX_MODEL_PROVIDER_MAPPINGS = "mappings";
    private SynchronizationContext context;
    private boolean mergingEnabled = true;
    protected SubscriberRefreshSchedule refreshSchedule;
    private String description;
    private ISaveableCompareModel activeModel;
    private IPropertyListener dirtyListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            if (source instanceof ISaveableCompareModel && propId == 257) {
                ISaveableCompareModel scm = (ISaveableCompareModel)source;
                boolean isDirty = scm.isDirty();
                ModelSynchronizeParticipant.this.firePropertyChange(ModelSynchronizeParticipant.this, ModelSynchronizeParticipant.PROP_DIRTY, !isDirty, isDirty);
            }
        }
    };
    static /* synthetic */ Class class$0;

    public static ModelSynchronizeParticipant createParticipant(SynchronizationContext context, String name) {
        return new ModelSynchronizeParticipant(context, name);
    }

    private ModelSynchronizeParticipant(SynchronizationContext context, String name) {
        this.initializeContext(context);
        try {
            this.setInitializationData(TeamUI.getSynchronizeManager().getParticipantDescriptor("org.eclipse.team.ui.synchronization_context_synchronize_participant"));
        }
        catch (CoreException e) {
            TeamUIPlugin.log(e);
        }
        this.setSecondaryId(Long.toString(System.currentTimeMillis()));
        this.setName(name);
        this.refreshSchedule = new SubscriberRefreshSchedule(this.createRefreshable());
    }

    public ModelSynchronizeParticipant(SynchronizationContext context) {
        this.initializeContext(context);
        this.refreshSchedule = new SubscriberRefreshSchedule(this.createRefreshable());
    }

    public ModelSynchronizeParticipant() {
    }

    public String getName() {
        String name = super.getName();
        if (this.description == null) {
            this.description = Utils.getScopeDescription(this.getContext().getScope());
        }
        return NLS.bind((String)TeamUIMessages.SubscriberParticipant_namePattern, (Object[])new String[]{name, this.description});
    }

    protected final String getShortName() {
        return super.getName();
    }

    protected void initializeConfiguration(ISynchronizePageConfiguration configuration) {
        if (this.isMergingEnabled()) {
            configuration.addMenuGroup("org.eclipse.team.ui.P_TOOLBAR_MENU", "merge");
            configuration.addActionContribution(this.createMergeActionGroup());
        }
        configuration.setSupportedModes(15);
        configuration.setMode(4);
        configuration.setProperty("org.eclipse.team.ui.synchronizationContext", this.getContext());
        configuration.setProperty("org.eclipse.team.ui.resourceMappingScope", this.getContext().getScope());
    }

    protected ModelSynchronizeParticipantActionGroup createMergeActionGroup() {
        return new ModelSynchronizeParticipantActionGroup();
    }

    public final IPageBookViewPage createPage(ISynchronizePageConfiguration configuration) {
        return new ModelSynchronizePage(configuration);
    }

    public void run(IWorkbenchPart part) {
        this.refresh((IWorkbenchSite)(part != null ? part.getSite() : null), new ResourceMapping[0]);
    }

    public final void refresh(IWorkbenchSite site, ResourceMapping[] mappings) {
        RefreshUserNotificationPolicy listener = new RefreshUserNotificationPolicy(this);
        this.internalRefresh(mappings, null, null, site, listener);
    }

    public void dispose() {
        this.context.dispose();
        Platform.getJobManager().cancel((Object)this);
        this.refreshSchedule.dispose();
    }

    protected void initializeContext(SynchronizationContext context) {
        this.context = context;
        this.mergingEnabled = context instanceof IMergeContext;
    }

    public SynchronizationContext getContext() {
        return this.context;
    }

    public ICompareInput asCompareInput(Object object) {
        if (object instanceof ICompareInput) {
            return (ICompareInput)object;
        }
        ISynchronizationCompareAdapter adapter = Utils.getCompareAdapter(object);
        if (adapter != null) {
            return adapter.asCompareInput((ISynchronizationContext)this.getContext(), object);
        }
        return null;
    }

    public boolean hasCompareInputFor(Object object) {
        ISynchronizationCompareAdapter adapter = Utils.getCompareAdapter(object);
        if (adapter != null) {
            return adapter.hasCompareInput((ISynchronizationContext)this.getContext(), object);
        }
        return false;
    }

    public boolean isMergingEnabled() {
        return this.mergingEnabled;
    }

    public void setMergingEnabled(boolean mergingEnabled) {
        this.mergingEnabled = mergingEnabled;
    }

    private void internalRefresh(ResourceMapping[] mappings, String jobName, String taskName, IWorkbenchSite site, IRefreshSubscriberListener listener) {
        if (jobName == null) {
            jobName = this.getShortTaskName();
        }
        if (taskName == null) {
            taskName = this.getLongTaskName(mappings);
        }
        Platform.getJobManager().cancel((Object)this);
        RefreshModelParticipantJob job = new RefreshModelParticipantJob(this, jobName, taskName, mappings, listener);
        job.setUser(true);
        Utils.schedule(job, site);
        TeamUIPlugin.getPlugin().getPreferenceStore().setValue("org.eclipse.team.ui.sychronizing_default_participant", this.getId());
        TeamUIPlugin.getPlugin().getPreferenceStore().setValue("org.eclipse.team.ui.sychronizing_default_participant_sec_id", this.getSecondaryId());
    }

    protected String getShortTaskName() {
        return TeamUIMessages.Participant_synchronizing;
    }

    protected String getLongTaskName(ResourceMapping[] mappings) {
        if (mappings == null || mappings.length == this.getContext().getScope().getMappings().length) {
            return NLS.bind((String)TeamUIMessages.Participant_synchronizingDetails, (Object[])new String[]{this.getName()});
        }
        int mappingCount = mappings.length;
        if (mappingCount == 1) {
            return NLS.bind((String)TeamUIMessages.Participant_synchronizingMoreDetails, (Object[])new String[]{this.getShortName(), Utils.getLabel(mappings[0])});
        }
        return NLS.bind((String)TeamUIMessages.Participant_synchronizingResources, (Object[])new String[]{this.getShortName(), Integer.toString(mappingCount)});
    }

    private IRefreshable createRefreshable() {
        return new IRefreshable(){

            public RefreshParticipantJob createJob(String interval) {
                return new RefreshModelParticipantJob(ModelSynchronizeParticipant.this, TeamUIMessages.RefreshSchedule_14, NLS.bind((String)TeamUIMessages.RefreshSchedule_15, (Object[])new String[]{ModelSynchronizeParticipant.this.getName(), interval}), new ResourceMapping[0], new RefreshUserNotificationPolicy(ModelSynchronizeParticipant.this));
            }

            public ISynchronizeParticipant getParticipant() {
                return ModelSynchronizeParticipant.this;
            }

            public void setRefreshSchedule(SubscriberRefreshSchedule schedule) {
                ModelSynchronizeParticipant.this.setRefreshSchedule(schedule);
            }

            public SubscriberRefreshSchedule getRefreshSchedule() {
                return ModelSynchronizeParticipant.this.refreshSchedule;
            }
        };
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.team.internal.ui.synchronize.IRefreshable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz && this.refreshSchedule != null) {
            return this.refreshSchedule.getRefreshable();
        }
        return super.getAdapter(adapter);
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        IMemento settings = memento.createChild(CTX_PARTICIPANT_SETTINGS);
        if (this.description != null) {
            settings.putString(CTX_DESCRIPTION, this.description);
        }
        this.refreshSchedule.saveState(settings.createChild(CTX_REFRESH_SCHEDULE_SETTINGS));
        this.saveMappings(settings);
    }

    private void saveMappings(IMemento settings) {
        ISynchronizationScope inputScope = this.getContext().getScope().asInputScope();
        ModelProvider[] providers = inputScope.getModelProviders();
        int i = 0;
        while (i < providers.length) {
            ModelProvider provider = providers[i];
            ISynchronizationCompareAdapter adapter = Utils.getCompareAdapter(provider);
            if (adapter != null) {
                IMemento child = settings.createChild(CTX_PARTICIPANT_MAPPINGS);
                String id = provider.getDescriptor().getId();
                child.putString(CTX_MODEL_PROVIDER_ID, id);
                adapter.save(inputScope.getMappings(id), child.createChild(CTX_MODEL_PROVIDER_MAPPINGS));
            }
            ++i;
        }
    }

    public void init(String secondaryId, IMemento memento) throws PartInitException {
        super.init(secondaryId, memento);
        if (memento != null) {
            IMemento settings = memento.getChild(CTX_PARTICIPANT_SETTINGS);
            ResourceMapping[] mappings = this.loadMappings(settings);
            if (mappings.length == 0) {
                throw new PartInitException(NLS.bind((String)"{0} failed to initialize due to missing data during restore.", (Object)this.getId()));
            }
            this.initializeContext(mappings);
            if (settings != null) {
                SubscriberRefreshSchedule schedule = SubscriberRefreshSchedule.init(settings.getChild(CTX_REFRESH_SCHEDULE_SETTINGS), this.createRefreshable());
                this.description = settings.getString(CTX_DESCRIPTION);
                this.setRefreshSchedule(schedule);
            }
        }
    }

    private ResourceMapping[] loadMappings(IMemento settings) throws PartInitException {
        ArrayList<ResourceMapping> result = new ArrayList<ResourceMapping>();
        IMemento[] children = settings.getChildren(CTX_PARTICIPANT_MAPPINGS);
        int i = 0;
        while (i < children.length) {
            IMemento memento = children[i];
            String id = memento.getString(CTX_MODEL_PROVIDER_ID);
            if (id != null) {
                IModelProviderDescriptor desc = ModelProvider.getModelProviderDescriptor((String)id);
                try {
                    ModelProvider provider = desc.getModelProvider();
                    ISynchronizationCompareAdapter adapter = Utils.getCompareAdapter(provider);
                    if (adapter != null) {
                        ResourceMapping[] mappings = adapter.restore(memento.getChild(CTX_MODEL_PROVIDER_MAPPINGS));
                        int j = 0;
                        while (j < mappings.length) {
                            ResourceMapping mapping = mappings[j];
                            result.add(mapping);
                            ++j;
                        }
                    }
                }
                catch (CoreException e) {
                    TeamUIPlugin.log(e);
                }
            }
            ++i;
        }
        return result.toArray(new ResourceMapping[result.size()]);
    }

    private void initializeContext(ResourceMapping[] mappings) throws PartInitException {
        try {
            ISynchronizationScopeManager manager = this.createScopeManager(mappings);
            MergeContext context = this.restoreContext(manager);
            this.initializeContext((SynchronizationContext)context);
        }
        catch (CoreException e) {
            TeamUIPlugin.log(e);
            throw new PartInitException(e.getStatus());
        }
    }

    protected MergeContext restoreContext(ISynchronizationScopeManager manager) throws CoreException {
        throw new PartInitException(NLS.bind((String)"Participant {0} is not capable of restoring its context", (Object)this.getId()));
    }

    protected ISynchronizationScopeManager createScopeManager(ResourceMapping[] mappings) {
        return new SynchronizationScopeManager(mappings, ResourceMappingContext.LOCAL_CONTEXT, true);
    }

    void setRefreshSchedule(SubscriberRefreshSchedule schedule) {
        if (this.refreshSchedule != schedule) {
            if (this.refreshSchedule != null) {
                this.refreshSchedule.dispose();
            }
            this.refreshSchedule = schedule;
        }
        this.firePropertyChange(this, "org.eclipse.team.schedule", schedule, schedule);
    }

    public final ISaveableModel[] getModels() {
        if (this.getActiveModel() == null) {
            return new ISaveableModel[0];
        }
        return new ISaveableModel[]{this.getActiveModel()};
    }

    public final ISaveableModel[] getActiveModels() {
        return this.getModels();
    }

    public ISaveableCompareModel getActiveModel() {
        return this.activeModel;
    }

    public void setActiveModel(ISaveableCompareModel activeModel) {
        boolean wasDirty = false;
        ISaveableCompareModel oldModel = this.activeModel;
        if (oldModel != null) {
            oldModel.removePropertyListener(this.dirtyListener);
            wasDirty = oldModel.isDirty();
        }
        this.activeModel = activeModel;
        this.firePropertyChange(this, PROP_ACTIVE_SAVEABLE_MODEL, oldModel, activeModel);
        boolean isDirty = false;
        if (activeModel != null) {
            activeModel.addPropertyListener(this.dirtyListener);
            isDirty = activeModel.isDirty();
        }
        if (isDirty != wasDirty) {
            this.firePropertyChange(this, PROP_DIRTY, wasDirty, isDirty);
        }
    }

    public boolean checkForBufferChange(Shell shell, IModelCompareInput input, boolean cancelAllowed, IProgressMonitor monitor) throws CoreException {
        ISaveableCompareModel currentBuffer = this.getActiveModel();
        ISaveableCompareModel targetBuffer = input.getCompareModel();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            ModelProviderAction.handleBufferChange(shell, targetBuffer, currentBuffer, cancelAllowed, Policy.subMonitorFor(monitor, 10));
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        this.setActiveModel(targetBuffer);
        return true;
    }

    public ModelProvider[] getActiveModelProviders() {
        return this.getContext().getScope().getModelProviders();
    }
}

