/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.team.core.mapping.IMergeContext;
import org.eclipse.team.core.mapping.provider.SynchronizationContext;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.CommonMenuManager;
import org.eclipse.team.internal.ui.mapping.MergeAction;
import org.eclipse.team.internal.ui.mapping.MergeIncomingChangesAction;
import org.eclipse.team.internal.ui.mapping.ModelSelectionDropDownAction;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;

public class ModelSynchronizeParticipantActionGroup
extends SynchronizePageActionGroup {
    public static final String MERGE_ACTION_GROUP = "merge";
    public static final String OTHER_ACTION_GROUP = "other";
    protected static final String MERGE_ALL_ACTION_ID = "org.eclipse.team.ui.mergeAll";
    private MergeIncomingChangesAction updateToolbarAction;
    private ModelSelectionDropDownAction modelPicker;

    public void initialize(ISynchronizePageConfiguration configuration) {
        super.initialize(configuration);
        ModelSynchronizeParticipant participant = (ModelSynchronizeParticipant)configuration.getParticipant();
        if (participant.isMergingEnabled()) {
            this.updateToolbarAction = new MergeIncomingChangesAction(configuration);
            this.configureMergeAction(MERGE_ALL_ACTION_ID, (Action)this.updateToolbarAction);
            this.appendToGroup("org.eclipse.team.ui.P_TOOLBAR_MENU", MERGE_ACTION_GROUP, (IAction)this.updateToolbarAction);
        }
        this.modelPicker = new ModelSelectionDropDownAction(configuration);
        this.appendToGroup("org.eclipse.team.ui.P_TOOLBAR_MENU", "navigate", (IAction)this.modelPicker);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        if (menu instanceof CommonMenuManager) {
            CommonMenuManager cmm = (CommonMenuManager)menu;
            this.addMergeActions(cmm);
        }
    }

    private void addMergeActions(CommonMenuManager cmm) {
        ModelSynchronizeParticipant participant = (ModelSynchronizeParticipant)this.getConfiguration().getParticipant();
        if (participant.isMergingEnabled()) {
            if (!this.isTwoWayMerge()) {
                MergeAction merge = new MergeAction("org.eclipse.team.ui.mergeAction", cmm, this.getConfiguration());
                this.configureMergeAction("org.eclipse.team.ui.mergeAction", merge);
                this.addToContextMenu("org.eclipse.team.ui.mergeAction", merge, (IMenuManager)cmm);
            }
            MergeAction overwrite = new MergeAction("org.eclipse.team.ui.overwriteAction", cmm, this.getConfiguration());
            this.configureMergeAction("org.eclipse.team.ui.overwriteAction", overwrite);
            this.addToContextMenu("org.eclipse.team.ui.overwriteAction", overwrite, (IMenuManager)cmm);
            if (!this.isTwoWayMerge()) {
                MergeAction markAsMerged = new MergeAction("org.eclipse.team.ui.markAsMergeAction", cmm, this.getConfiguration());
                this.configureMergeAction("org.eclipse.team.ui.markAsMergeAction", markAsMerged);
                this.addToContextMenu("org.eclipse.team.ui.markAsMergeAction", markAsMerged, (IMenuManager)cmm);
            }
        }
    }

    protected void configureMergeAction(String mergeActionId, Action action) {
        if (mergeActionId == "org.eclipse.team.ui.mergeAction") {
            Utils.initAction((IAction)action, "action.merge.");
        } else if (mergeActionId == "org.eclipse.team.ui.overwriteAction") {
            if (this.isTwoWayMerge()) {
                Utils.initAction((IAction)action, "action.replace.");
            } else {
                Utils.initAction((IAction)action, "action.overwrite.");
            }
        } else if (mergeActionId == "org.eclipse.team.ui.markAsMergeAction") {
            Utils.initAction((IAction)action, "action.markAsMerged.");
        } else if (mergeActionId == MERGE_ALL_ACTION_ID) {
            if (this.isTwoWayMerge()) {
                Utils.initAction((IAction)action, "action.replaceAll.");
            } else {
                Utils.initAction((IAction)action, "action.mergeAll.");
            }
        }
    }

    private boolean isTwoWayMerge() {
        ModelSynchronizeParticipant participant = (ModelSynchronizeParticipant)this.getConfiguration().getParticipant();
        SynchronizationContext context = participant.getContext();
        if (context instanceof IMergeContext) {
            IMergeContext mc = (IMergeContext)context;
            return mc.getMergeType() == 2;
        }
        return false;
    }

    protected void addToContextMenu(String mergeActionId, Action action, IMenuManager manager) {
        IContributionItem group = null;
        if (mergeActionId == "org.eclipse.team.ui.mergeAction") {
            group = manager.find(MERGE_ACTION_GROUP);
        } else if (mergeActionId == "org.eclipse.team.ui.overwriteAction") {
            group = manager.find(MERGE_ACTION_GROUP);
        } else if (mergeActionId == "org.eclipse.team.ui.markAsMergeAction") {
            group = manager.find(OTHER_ACTION_GROUP);
        }
        if (group != null) {
            manager.appendToGroup(group.getId(), (IAction)action);
        } else {
            manager.add((IAction)action);
        }
    }

    public void dispose() {
        if (this.modelPicker != null) {
            this.modelPicker.dispose();
        }
        super.dispose();
    }
}

