/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PAINTSTRUCT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCROLLINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TypedListener;

public class ExpandBar
extends Composite {
    ExpandItem[] items;
    int itemCount;
    int focusIndex;
    int spacing;
    int yCurrentScroll;
    static final int HEADER_HEIGHT = 24;

    public ExpandBar(Composite parent, int style) {
        super(parent, ExpandBar.checkStyle(style));
    }

    public void addExpandListener(ExpandListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    int callWindowProc(int hwnd, int msg, int wParam, int lParam) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.DefWindowProc(hwnd, msg, wParam, lParam);
    }

    static int checkStyle(int style) {
        return (style &= 0xFFFFFEFF) | 0x40000;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int height = 0;
        int width = 0;
        if ((wHint == -1 || hHint == -1) && this.itemCount > 0) {
            int hDC = OS.GetDC(this.handle);
            int hTheme = 0;
            if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
                hTheme = OS.OpenThemeData(this.handle, EXPLORERBAR);
            }
            height += this.spacing;
            int i = 0;
            while (i < this.itemCount) {
                ExpandItem item = this.items[i];
                height += 24;
                if (item.expanded) {
                    height += item.height;
                }
                height += this.spacing;
                width = Math.max(width, item.getPreferredWidth(hTheme, hDC));
                ++i;
            }
            OS.ReleaseDC(this.handle, hDC);
            if (hTheme != 0) {
                OS.CloseThemeData(hTheme);
            }
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, width, height);
        return new Point(trim.width, trim.height);
    }

    void createHandle() {
        super.createHandle();
        this.state &= 0xFFFFFFFD;
    }

    void createItem(ExpandItem item, int style, int index) {
        if (index < 0 || index > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            ExpandItem[] newItems = new ExpandItem[this.itemCount + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        System.arraycopy(this.items, index, this.items, index + 1, this.itemCount - index);
        this.items[index] = item;
        ++this.itemCount;
        if (this.itemCount == 1) {
            this.focusIndex = 0;
        }
        RECT rect = new RECT();
        OS.GetWindowRect(this.handle, rect);
        item.width = Math.max(0, rect.right - rect.left - this.spacing * 2);
        this.layoutItems(index, true);
    }

    void createWidget() {
        super.createWidget();
        this.items = new ExpandItem[4];
        this.focusIndex = -1;
        if (OS.COMCTL32_MAJOR < 6 || !OS.IsAppThemed()) {
            this.backgroundMode = 1;
        }
    }

    int defaultBackground() {
        if (OS.COMCTL32_MAJOR < 6 || !OS.IsAppThemed()) {
            return OS.GetSysColor(OS.COLOR_WINDOW);
        }
        return super.defaultBackground();
    }

    void destroyItem(ExpandItem item) {
        int index = 0;
        while (index < this.itemCount) {
            if (this.items[index] == item) break;
            ++index;
        }
        if (index == this.itemCount) {
            return;
        }
        System.arraycopy(this.items, index + 1, this.items, index, --this.itemCount - index);
        this.items[this.itemCount] = null;
        if (this.itemCount == 0) {
            this.focusIndex = -1;
        } else if (this.focusIndex == index && this.focusIndex == this.itemCount) {
            this.focusIndex = index - 1;
            this.items[this.focusIndex].redraw(true);
        }
        item.redraw(true);
        this.layoutItems(index, true);
    }

    void drawThemeBackground(int hDC, int hwnd, RECT rect) {
        RECT rect2 = new RECT();
        OS.GetClientRect(this.handle, rect2);
        OS.MapWindowPoints(this.handle, hwnd, rect2, 2);
        int hTheme = OS.OpenThemeData(this.handle, EXPLORERBAR);
        OS.DrawThemeBackground(hTheme, hDC, 5, 0, rect2, null);
        OS.CloseThemeData(hTheme);
    }

    Control findBackgroundControl() {
        Control control = super.findBackgroundControl();
        if (!(OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() || control != null)) {
            control = this;
        }
        return control;
    }

    Control findThemeControl() {
        return this;
    }

    public ExpandItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        return this.items[index];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public ExpandItem[] getItems() {
        this.checkWidget();
        ExpandItem[] result = new ExpandItem[this.itemCount];
        System.arraycopy(this.items, 0, result, 0, this.itemCount);
        return result;
    }

    public int getSpacing() {
        this.checkWidget();
        return this.spacing;
    }

    public int indexOf(ExpandItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        int i = 0;
        while (i < this.itemCount) {
            if (this.items[i] == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void layoutItems(int index, boolean setScrollbar) {
        if (index < this.itemCount) {
            ExpandItem item;
            int y = this.spacing - this.yCurrentScroll;
            int i = 0;
            while (i < index) {
                item = this.items[i];
                if (item.expanded) {
                    y += item.height;
                }
                y += 24 + this.spacing;
                ++i;
            }
            i = index;
            while (i < this.itemCount) {
                item = this.items[i];
                item.setBounds(this.spacing, y, 0, 0, true, false);
                if (item.expanded) {
                    y += item.height;
                }
                y += 24 + this.spacing;
                ++i;
            }
        }
        if (setScrollbar) {
            this.setScrollbar();
        }
    }

    public void removeExpandListener(ExpandListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, listener);
        this.eventTable.unhook(18, listener);
    }

    void setScrollbar() {
        if (this.itemCount == 0) {
            return;
        }
        RECT rect = new RECT();
        OS.GetClientRect(this.handle, rect);
        int height = rect.bottom - rect.top;
        ExpandItem item = this.items[this.itemCount - 1];
        int maxHeight = item.y + 24 + this.spacing;
        if (item.expanded) {
            maxHeight += item.height;
        }
        if (this.yCurrentScroll > 0 && height > maxHeight) {
            this.yCurrentScroll = Math.max(0, this.yCurrentScroll + maxHeight - height);
            this.layoutItems(0, false);
        }
        SCROLLINFO info = new SCROLLINFO();
        info.cbSize = 28;
        info.fMask = 7;
        info.nMin = 0;
        info.nMax = maxHeight += this.yCurrentScroll;
        info.nPage = height;
        info.nPos = Math.min(this.yCurrentScroll, info.nMax);
        if (info.nPage != 0) {
            ++info.nPage;
        }
        OS.SetScrollInfo(this.handle, 1, info, true);
    }

    public void setSpacing(int spacing) {
        this.checkWidget();
        if (spacing < 0) {
            return;
        }
        if (spacing == this.spacing) {
            return;
        }
        this.spacing = spacing;
        RECT rect = new RECT();
        OS.GetClientRect(this.handle, rect);
        int width = Math.max(0, rect.right - rect.left - spacing * 2);
        int i = 0;
        while (i < this.itemCount) {
            ExpandItem item = this.items[i];
            if (item.width != width) {
                item.setBounds(0, 0, width, item.height, false, true);
            }
            ++i;
        }
        this.layoutItems(0, true);
        OS.InvalidateRect(this.handle, null, true);
    }

    void showItem(int index) {
        ExpandItem item = this.items[index];
        Control control = item.control;
        if (control != null && !control.isDisposed()) {
            if (item.expanded) {
                OS.ShowWindow(control.handle, 5);
            } else {
                OS.ShowWindow(control.handle, 0);
            }
        }
        item.redraw(true);
        this.layoutItems(index + 1, true);
    }

    TCHAR windowClass() {
        return this.display.windowClass;
    }

    int windowProc() {
        return this.display.windowProc;
    }

    LRESULT WM_KEYDOWN(int wParam, int lParam) {
        LRESULT result = super.WM_KEYDOWN(wParam, lParam);
        if (result != null) {
            return result;
        }
        if (this.focusIndex == -1) {
            return result;
        }
        ExpandItem item = this.items[this.focusIndex];
        switch (wParam) {
            case 13: 
            case 32: {
                Event event = new Event();
                event.item = item;
                this.sendEvent(item.expanded ? 17 : 18, event);
                item.expanded = !item.expanded;
                this.showItem(this.focusIndex);
                return LRESULT.ZERO;
            }
            case 38: {
                if (this.focusIndex <= 0) break;
                item.redraw(true);
                --this.focusIndex;
                this.items[this.focusIndex].redraw(true);
                return LRESULT.ZERO;
            }
            case 40: {
                if (this.focusIndex >= this.itemCount - 1) break;
                item.redraw(true);
                ++this.focusIndex;
                this.items[this.focusIndex].redraw(true);
                return LRESULT.ZERO;
            }
        }
        return result;
    }

    LRESULT WM_KILLFOCUS(int wParam, int lParam) {
        LRESULT result = super.WM_KILLFOCUS(wParam, lParam);
        if (this.focusIndex != -1) {
            this.items[this.focusIndex].redraw(true);
        }
        return result;
    }

    LRESULT WM_LBUTTONDOWN(int wParam, int lParam) {
        LRESULT result = super.WM_LBUTTONDOWN(wParam, lParam);
        if (result == LRESULT.ZERO) {
            return result;
        }
        int x = lParam & 0xFFFF;
        int y = lParam >> 16;
        int i = 0;
        while (i < this.itemCount) {
            boolean hover;
            ExpandItem item = this.items[i];
            boolean bl = hover = item.x <= x && x < item.x + item.width && item.y <= y && y < item.y + 24;
            if (hover && this.focusIndex != i) {
                this.items[this.focusIndex].redraw(true);
                this.focusIndex = i;
                this.items[this.focusIndex].redraw(true);
                this.forceFocus();
                break;
            }
            ++i;
        }
        return result;
    }

    LRESULT WM_LBUTTONUP(int wParam, int lParam) {
        boolean hover;
        LRESULT result = super.WM_LBUTTONUP(wParam, lParam);
        if (result == LRESULT.ZERO) {
            return result;
        }
        if (this.focusIndex == -1) {
            return result;
        }
        ExpandItem item = this.items[this.focusIndex];
        int x = lParam & 0xFFFF;
        int y = lParam >> 16;
        boolean bl = hover = item.x <= x && x < item.x + item.width && item.y <= y && y < item.y + 24;
        if (hover) {
            Event event = new Event();
            event.item = item;
            this.sendEvent(item.expanded ? 17 : 18, event);
            item.expanded = !item.expanded;
            this.showItem(this.focusIndex);
        }
        return result;
    }

    LRESULT WM_MOUSEMOVE(int wParam, int lParam) {
        LRESULT result = super.WM_MOUSEMOVE(wParam, lParam);
        if (result == LRESULT.ZERO) {
            return result;
        }
        int x = lParam & 0xFFFF;
        int y = lParam >> 16;
        int i = 0;
        while (i < this.itemCount) {
            boolean hover;
            ExpandItem item = this.items[i];
            boolean bl = hover = item.x <= x && x < item.x + item.width && item.y <= y && y < item.y + 24;
            if (item.hover != hover) {
                item.hover = hover;
                item.redraw(false);
            }
            ++i;
        }
        return result;
    }

    LRESULT WM_PAINT(int wParam, int lParam) {
        PAINTSTRUCT ps = new PAINTSTRUCT();
        GCData data = new GCData();
        data.ps = ps;
        data.hwnd = this.handle;
        GC gc = this.new_GC(data);
        if (gc != null) {
            if (ps.right - ps.left != 0 && ps.bottom - ps.top != 0) {
                int hTheme = 0;
                if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
                    hTheme = OS.OpenThemeData(this.handle, EXPLORERBAR);
                }
                RECT clipRect = new RECT();
                OS.SetRect(clipRect, ps.left, ps.top, ps.right, ps.bottom);
                if (hTheme != 0) {
                    RECT rect = new RECT();
                    OS.GetClientRect(this.handle, rect);
                    OS.DrawThemeBackground(hTheme, gc.handle, 1, 0, rect, clipRect);
                } else {
                    this.drawBackground(gc.handle);
                }
                boolean drawFocus = false;
                if (this.handle == OS.GetFocus()) {
                    int uiState = OS.SendMessage(this.handle, 297, 0, 0);
                    drawFocus = (uiState & 1) == 0;
                }
                int i = 0;
                while (i < this.itemCount) {
                    ExpandItem item = this.items[i];
                    item.drawItem(gc, hTheme, clipRect, i == this.focusIndex && drawFocus);
                    ++i;
                }
                if (hTheme != 0) {
                    OS.CloseThemeData(hTheme);
                }
                if (this.hooks(9) || this.filters(9)) {
                    Event event = new Event();
                    event.gc = gc;
                    event.x = clipRect.left;
                    event.y = clipRect.top;
                    event.width = clipRect.right - clipRect.left;
                    event.height = clipRect.bottom - clipRect.top;
                    this.sendEvent(9, event);
                    event.gc = null;
                }
            }
            gc.dispose();
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_SETFOCUS(int wParam, int lParam) {
        LRESULT result = super.WM_SETFOCUS(wParam, lParam);
        if (this.focusIndex != -1) {
            this.items[this.focusIndex].redraw(true);
        }
        return result;
    }

    LRESULT WM_SIZE(int wParam, int lParam) {
        LRESULT result = super.WM_SIZE(wParam, lParam);
        int width = Math.max(0, (lParam & 0xFFFF) - this.spacing * 2);
        int i = 0;
        while (i < this.itemCount) {
            ExpandItem item = this.items[i];
            if (item.width != width) {
                item.setBounds(0, 0, width, item.height, false, true);
            }
            ++i;
        }
        this.setScrollbar();
        return result;
    }

    LRESULT wmScroll(ScrollBar bar, boolean update, int hwnd, int msg, int wParam, int lParam) {
        LRESULT result = super.wmScroll(bar, true, hwnd, msg, wParam, lParam);
        SCROLLINFO info = new SCROLLINFO();
        info.cbSize = 28;
        info.fMask = 4;
        OS.GetScrollInfo(this.handle, 1, info);
        int updateY = this.yCurrentScroll - info.nPos;
        OS.ScrollWindowEx(this.handle, 0, updateY, null, null, 0, null, 3);
        this.yCurrentScroll = info.nPos;
        if (updateY != 0) {
            int i = 0;
            while (i < this.itemCount) {
                this.items[i].y += updateY;
                ++i;
            }
        }
        return result;
    }
}

