/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public abstract class BreakpointChange
extends Change {
    private IJavaBreakpoint fBreakpoint;
    private String fTypeName;
    private int fHitCount;
    private IJavaObject[] fInstanceFilters;
    private int fSuspendPolicy;
    private IJavaThread[] fThreadFilters;
    private boolean fEnabled;

    public BreakpointChange(IJavaBreakpoint breakpoint) throws CoreException {
        this.fBreakpoint = breakpoint;
        this.fTypeName = breakpoint.getTypeName();
        this.fHitCount = breakpoint.getHitCount();
        this.fInstanceFilters = breakpoint.getInstanceFilters();
        this.fSuspendPolicy = breakpoint.getSuspendPolicy();
        this.fThreadFilters = breakpoint.getThreadFilters();
        this.fEnabled = breakpoint.isEnabled();
    }

    protected void apply(IJavaBreakpoint breakpoint) throws CoreException {
        breakpoint.setHitCount(this.fHitCount);
        int i = 0;
        while (i < this.fInstanceFilters.length) {
            breakpoint.addInstanceFilter(this.fInstanceFilters[i]);
            ++i;
        }
        breakpoint.setSuspendPolicy(this.fSuspendPolicy);
        i = 0;
        while (i < this.fThreadFilters.length) {
            breakpoint.setThreadFilter(this.fThreadFilters[i]);
            ++i;
        }
        breakpoint.setEnabled(this.fEnabled);
    }

    protected IJavaBreakpoint getOriginalBreakpoint() {
        return this.fBreakpoint;
    }

    protected String getOriginalBreakpointTypeName() {
        return this.fTypeName;
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Object getModifiedElement() {
        return this.fBreakpoint;
    }
}

