/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.text.Collator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.ide.DialogUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.model.ModelProviderBasedEditorOpenStrategy;
import org.eclipse.ui.internal.provisional.ide.IEditorOpenStrategy;
import org.eclipse.ui.internal.provisional.ide.OpenWithEntry;
import org.eclipse.ui.internal.provisional.ide.OpenWithInfo;

public class OpenWithMenu
extends ContributionItem {
    private IWorkbenchPage page;
    private Object element;
    private IEditorOpenStrategy strategy = new ModelProviderBasedEditorOpenStrategy();
    private static Hashtable imageCache = new Hashtable(11);
    public static final String ID = "org.eclipse.ui.OpenWithMenu";
    private static final Comparator comparer = new Comparator(){
        private Collator collator = Collator.getInstance();

        public int compare(Object arg0, Object arg1) {
            String s1 = ((OpenWithEntry)arg0).getLabel();
            String s2 = ((OpenWithEntry)arg1).getLabel();
            return this.collator.compare(s1, s2);
        }
    };

    public OpenWithMenu(IWorkbenchPage page) {
        this(page, null);
    }

    public OpenWithMenu(IWorkbenchPage page, IAdaptable file) {
        this(page, (Object)file);
    }

    public OpenWithMenu(IWorkbenchPage page, Object element) {
        super(ID);
        this.page = page;
        this.element = element;
    }

    private Image getImage(OpenWithEntry entry) {
        ImageDescriptor imageDesc = entry.getImageDescriptor();
        if (imageDesc == null) {
            return null;
        }
        Image image = (Image)imageCache.get(imageDesc);
        if (image == null) {
            image = imageDesc.createImage();
            imageCache.put(imageDesc, image);
        }
        return image;
    }

    private void createMenuItem(Menu menu, final OpenWithEntry entry, boolean isPreferred) {
        MenuItem menuItem = new MenuItem(menu, 0);
        if (isPreferred) {
            menu.setDefaultItem(menuItem);
        }
        menuItem.setText(entry.getLabel());
        Image image = this.getImage(entry);
        if (image != null) {
            menuItem.setImage(image);
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        OpenWithMenu.this.openEditor(entry, true);
                    }
                }
            }
        };
        menuItem.addListener(13, listener);
    }

    private void createDefaultMenuItem(Menu menu, final OpenWithEntry entry) {
        MenuItem menuItem = new MenuItem(menu, 0);
        menuItem.setText(IDEWorkbenchMessages.DefaultEditorDescription_name);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        OpenWithMenu.this.openEditor(entry, false);
                    }
                }
            }
        };
        menuItem.addListener(13, listener);
    }

    public void fill(Menu menu, int index) {
        Object element = this.getElement();
        if (element == null) {
            return;
        }
        OpenWithInfo info = this.strategy.getOpenWithInfo(element);
        if (info == null) {
            return;
        }
        OpenWithEntry preferredEntry = info.getPreferredEntry();
        OpenWithEntry[] entries = info.getEntries();
        Collections.sort(Arrays.asList(entries), comparer);
        menu.setDefaultItem(null);
        int i = 0;
        while (i < entries.length) {
            OpenWithEntry entry = entries[i];
            this.createMenuItem(menu, entry, entry.equals(preferredEntry));
            ++i;
        }
        if (entries.length > 0) {
            new MenuItem(menu, 2);
        }
        if (info.getExternalEntry() != null) {
            this.createMenuItem(menu, info.getExternalEntry(), info.getExternalEntry().equals(preferredEntry));
        }
        if (info.getInPlaceEntry() != null) {
            this.createMenuItem(menu, info.getInPlaceEntry(), info.getInPlaceEntry().equals(preferredEntry));
        }
        if (info.getDefaultEntry() != null) {
            this.createDefaultMenuItem(menu, info.getDefaultEntry());
        }
    }

    private Object getElement() {
        return this.element;
    }

    public boolean isDynamic() {
        return true;
    }

    private void openEditor(OpenWithEntry entry, boolean rememberEditor) {
        try {
            entry.openEditor(this.page, true, 3, rememberEditor);
        }
        catch (PartInitException e) {
            DialogUtil.openError(this.page.getWorkbenchWindow().getShell(), IDEWorkbenchMessages.OpenWithMenu_dialogTitle, e.getMessage(), e);
        }
    }
}

