/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.part.FileEditorInput;

public final class ResourceUtil {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    private ResourceUtil() {
    }

    public static IFile getFile(IEditorInput editorInput) {
        Object o;
        if (editorInput == null) {
            return null;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((o = editorInput.getAdapter((Class)clazz)) instanceof IFile) {
            return (IFile)o;
        }
        return null;
    }

    public static IResource getResource(IEditorInput editorInput) {
        Object o;
        if (editorInput == null) {
            return null;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((o = editorInput.getAdapter((Class)clazz)) instanceof IResource) {
            return (IResource)o;
        }
        return ResourceUtil.getFile(editorInput);
    }

    public static IEditorPart findEditor(IWorkbenchPage page, IFile file) {
        IEditorPart editor = page.findEditor((IEditorInput)new FileEditorInput(file));
        if (editor != null) {
            return editor;
        }
        IEditorReference[] refs = page.getEditorReferences();
        int i = 0;
        while (i < refs.length) {
            IFile editorFile;
            IEditorReference ref = refs[i];
            IEditorPart part = ref.getEditor(false);
            if (part != null && (editorFile = ResourceUtil.getFile(part.getEditorInput())) != null && file.equals((Object)editorFile)) {
                return part;
            }
            ++i;
        }
        return null;
    }

    public static IResource getResource(Object element) {
        if (element == null) {
            return null;
        }
        if (element instanceof IResource) {
            return (IResource)element;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IResource)ResourceUtil.getAdapter(element, clazz, true);
    }

    public static IFile getFile(Object element) {
        Object adapter;
        if (element == null) {
            return null;
        }
        if (element instanceof IFile) {
            return (IFile)element;
        }
        ResourceMapping mapping = ResourceUtil.getResourceMapping(element);
        if (mapping != null) {
            return ResourceUtil.getFileFromResourceMapping(mapping);
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = ResourceUtil.getAdapter(element, clazz, true)) instanceof IFile) {
            return (IFile)adapter;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = ResourceUtil.getAdapter(element, clazz2, true)) instanceof IFile) {
            return (IFile)adapter;
        }
        return null;
    }

    public static ResourceMapping getResourceMapping(Object element) {
        Object adapter;
        if (element == null) {
            return null;
        }
        if (element instanceof ResourceMapping) {
            return (ResourceMapping)element;
        }
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.core.resources.mapping.ResourceMapping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = ResourceUtil.getAdapter(element, clazz, true)) instanceof ResourceMapping) {
            return (ResourceMapping)adapter;
        }
        return null;
    }

    private static IFile getFileFromResourceMapping(ResourceMapping mapping) {
        IResource resource = ResourceUtil.getResourceFromResourceMapping(mapping);
        if (resource instanceof IFile) {
            return (IFile)resource;
        }
        return null;
    }

    private static IResource getResourceFromResourceMapping(ResourceMapping mapping) {
        try {
            ResourceTraversal[] traversals = mapping.getTraversals(null, null);
            if (traversals.length != 1) {
                return null;
            }
            ResourceTraversal traversal = traversals[0];
            IResource[] resources = traversal.getResources();
            if (resources.length != 1) {
                return null;
            }
            return resources[0];
        }
        catch (CoreException e) {
            IDEWorkbenchPlugin.log("Error in ResourceUtil.getFileFromResourceMapping", e);
            return null;
        }
    }

    public static Object getAdapter(Object element, Class adapterType, boolean forceLoad) {
        IAdaptable adaptable;
        Object o;
        if (element instanceof IAdaptable && (o = (adaptable = (IAdaptable)element).getAdapter(adapterType)) != null) {
            return o;
        }
        if (forceLoad) {
            return Platform.getAdapterManager().loadAdapter(element, adapterType.getName());
        }
        return Platform.getAdapterManager().getAdapter(element, adapterType);
    }
}

