/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.dialogs;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.WorkbenchEncoding;
import org.eclipse.ui.ide.IDEEncoding;
import org.eclipse.ui.ide.dialogs.AbstractEncodingFieldEditor;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public final class ResourceEncodingFieldEditor
extends AbstractEncodingFieldEditor {
    private IResource resource;

    public ResourceEncodingFieldEditor(String labelText, Composite parent, IResource charsetResource) {
        Assert.isTrue((charsetResource instanceof IContainer || charsetResource instanceof IFile ? 1 : 0) != 0);
        this.setLabelText(labelText);
        this.resource = charsetResource;
        this.createControl(parent);
    }

    protected String getStoredValue() {
        try {
            if (this.resource instanceof IContainer) {
                return ((IContainer)this.resource).getDefaultCharset(false);
            }
            return ((IFile)this.resource).getCharset(false);
        }
        catch (CoreException e) {
            IDEWorkbenchPlugin.log(IDEWorkbenchMessages.ResourceEncodingFieldEditor_ErrorLoadingMessage, e.getStatus());
            return WorkbenchEncoding.getWorkbenchDefaultEncoding();
        }
    }

    protected void doStore() {
        String encoding = this.getSelectedEncoding();
        if (this.isDefaultSelected()) {
            encoding = null;
        }
        if (this.hasSameEncoding(encoding)) {
            return;
        }
        String descriptionCharset = this.getCharsetFromDescription();
        if (descriptionCharset != null && !descriptionCharset.equals(encoding) && encoding != null) {
            MessageDialog dialog;
            Shell shell = null;
            DialogPage page = this.getPage();
            if (page != null) {
                shell = page.getShell();
            }
            if ((dialog = new MessageDialog(shell, IDEWorkbenchMessages.ResourceEncodingFieldEditor_EncodingConflictTitle, null, NLS.bind((String)IDEWorkbenchMessages.ResourceEncodingFieldEditor_EncodingConflictMessage, (Object)encoding, (Object)descriptionCharset), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0)).open() > 0) {
                return;
            }
        }
        IDEEncoding.addIDEEncoding(encoding);
        final String finalEncoding = encoding;
        Job charsetJob = new Job(IDEWorkbenchMessages.IDEEncoding_EncodingJob){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (ResourceEncodingFieldEditor.this.resource instanceof IContainer) {
                        ((IContainer)ResourceEncodingFieldEditor.this.resource).setDefaultCharset(finalEncoding, monitor);
                    } else {
                        ((IFile)ResourceEncodingFieldEditor.this.resource).setCharset(finalEncoding, monitor);
                    }
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    IDEWorkbenchPlugin.log(IDEWorkbenchMessages.ResourceEncodingFieldEditor_ErrorStoringMessage, e.getStatus());
                    return e.getStatus();
                }
            }
        };
        charsetJob.schedule();
    }

    public void store() {
        this.doStore();
    }

    public void load() {
        this.setPresentsDefaultValue(false);
        this.doLoad();
    }

    public void loadDefault() {
        this.setPresentsDefaultValue(true);
        this.doLoadDefault();
        this.refreshValidState();
    }

    protected String findDefaultEncoding() {
        if (this.resource instanceof IWorkspaceRoot) {
            return super.findDefaultEncoding();
        }
        String defaultCharset = this.getCharsetFromDescription();
        defaultCharset = this.getCharsetFromDescription();
        if (defaultCharset != null && defaultCharset.length() > 0) {
            return defaultCharset;
        }
        try {
            defaultCharset = this.resource.getParent().getDefaultCharset(true);
        }
        catch (CoreException coreException) {}
        if (defaultCharset != null && defaultCharset.length() > 0) {
            return defaultCharset;
        }
        return super.findDefaultEncoding();
    }

    private String getCharsetFromDescription() {
        IContentDescription description = this.getContentDescription();
        if (description != null) {
            return description.getCharset();
        }
        return null;
    }

    protected String defaultButtonText() {
        if (this.resource instanceof IWorkspaceRoot) {
            return super.defaultButtonText();
        }
        if (this.resource instanceof IFile) {
            try {
                IContentDescription description = ((IFile)this.resource).getContentDescription();
                if (description == null || description.getCharset() == null) {
                    return NLS.bind((String)IDEWorkbenchMessages.ResourceInfo_fileContainerEncodingFormat, (Object)this.getDefaultEnc());
                }
                return NLS.bind((String)IDEWorkbenchMessages.ResourceInfo_fileContentEncodingFormat, (Object)this.getDefaultEnc());
            }
            catch (CoreException coreException) {}
        }
        return NLS.bind((String)IDEWorkbenchMessages.ResourceInfo_containerEncodingFormat, (Object)this.getDefaultEnc());
    }

    protected Composite createEncodingGroup(Composite parent, int numColumns) {
        Composite group = super.createEncodingGroup(parent, numColumns);
        String byteOrderLabel = IDEEncoding.getByteOrderMarkLabel(this.getContentDescription());
        if (byteOrderLabel != null) {
            Label label = new Label(group, 0);
            label.setText(NLS.bind((String)IDEWorkbenchMessages.WorkbenchPreference_encoding_encodingMessage, (Object)byteOrderLabel));
            GridData layoutData = new GridData();
            layoutData.horizontalSpan = numColumns + 1;
            label.setLayoutData((Object)layoutData);
        }
        return group;
    }

    private IContentDescription getContentDescription() {
        try {
            if (this.resource instanceof IFile) {
                return ((IFile)this.resource).getContentDescription();
            }
        }
        catch (CoreException coreException) {}
        return null;
    }
}

