/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.CellEditorActionHandler;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.markers.internal.BookmarkFilter;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.DialogBookmarkFilter;
import org.eclipse.ui.views.markers.internal.DialogMarkerFilter;
import org.eclipse.ui.views.markers.internal.FieldCreationTime;
import org.eclipse.ui.views.markers.internal.FieldDummy;
import org.eclipse.ui.views.markers.internal.FieldFolder;
import org.eclipse.ui.views.markers.internal.FieldLineNumber;
import org.eclipse.ui.views.markers.internal.FieldMessage;
import org.eclipse.ui.views.markers.internal.FieldResource;
import org.eclipse.ui.views.markers.internal.IField;
import org.eclipse.ui.views.markers.internal.MarkerFilter;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerView;
import org.eclipse.ui.views.markers.internal.Util;

public class BookmarkView
extends MarkerView {
    private final IField[] HIDDEN_FIELDS = new IField[]{new FieldCreationTime()};
    private static final String[] ROOT_TYPES = new String[]{"org.eclipse.core.resources.bookmark"};
    private static final String[] TABLE_COLUMN_PROPERTIES = new String[]{Util.EMPTY_STRING, "message", Util.EMPTY_STRING, Util.EMPTY_STRING, Util.EMPTY_STRING};
    private static final String TAG_DIALOG_SECTION = "org.eclipse.ui.views.bookmark";
    private final IField[] VISIBLE_FIELDS = new IField[]{new FieldDummy(), new FieldMessage(), new FieldResource(), new FieldFolder(), new FieldLineNumber()};
    private ICellModifier cellModifier = new ICellModifier(){

        public Object getValue(Object element, String property) {
            if (element instanceof ConcreteMarker && "message".equals(property)) {
                return ((ConcreteMarker)element).getDescription();
            }
            return null;
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public void modify(Object element, String property, Object value) {
            Item item;
            Object data;
            if (element instanceof Item && (data = (item = (Item)element).getData()) instanceof ConcreteMarker) {
                IMarker marker = ((ConcreteMarker)data).getMarker();
                try {
                    if (!marker.getAttribute(property).equals(value) && "message".equals(property)) {
                        marker.setAttribute("message", value);
                    }
                }
                catch (CoreException e) {
                    ErrorDialog.openError((Shell)BookmarkView.this.getSite().getShell(), (String)MarkerMessages.errorModifyingBookmark, null, (IStatus)e.getStatus());
                }
            }
        }
    };
    private CellEditorActionHandler cellEditorActionHandler;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        TreeViewer treeViewer = this.getViewer();
        CellEditor[] cellEditors = new CellEditor[treeViewer.getTree().getColumnCount()];
        TextCellEditor descriptionCellEditor = new TextCellEditor((Composite)treeViewer.getTree());
        cellEditors[1] = descriptionCellEditor;
        treeViewer.setCellEditors(cellEditors);
        treeViewer.setCellModifier(this.cellModifier);
        treeViewer.setColumnProperties(TABLE_COLUMN_PROPERTIES);
        this.cellEditorActionHandler = new CellEditorActionHandler(this.getViewSite().getActionBars());
        this.cellEditorActionHandler.addCellEditor((CellEditor)descriptionCellEditor);
        this.cellEditorActionHandler.setCopyAction((IAction)this.copyAction);
        this.cellEditorActionHandler.setPasteAction((IAction)this.pasteAction);
        this.cellEditorActionHandler.setDeleteAction((IAction)this.deleteAction);
        this.cellEditorActionHandler.setSelectAllAction((IAction)this.selectAllAction);
    }

    public void dispose() {
        if (this.cellEditorActionHandler != null) {
            this.cellEditorActionHandler.dispose();
        }
        super.dispose();
    }

    protected IDialogSettings getDialogSettings() {
        AbstractUIPlugin plugin = (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
        IDialogSettings workbenchSettings = plugin.getDialogSettings();
        IDialogSettings settings = workbenchSettings.getSection(TAG_DIALOG_SECTION);
        if (settings == null) {
            settings = workbenchSettings.addNewSection(TAG_DIALOG_SECTION);
        }
        return settings;
    }

    protected IField[] getSortingFields() {
        IField[] all = new IField[this.VISIBLE_FIELDS.length + this.HIDDEN_FIELDS.length];
        System.arraycopy(this.VISIBLE_FIELDS, 0, all, 0, this.VISIBLE_FIELDS.length);
        System.arraycopy(this.HIDDEN_FIELDS, 0, all, this.VISIBLE_FIELDS.length, this.HIDDEN_FIELDS.length);
        return all;
    }

    protected IField[] getAllFields() {
        return this.getSortingFields();
    }

    protected String[] getRootTypes() {
        return ROOT_TYPES;
    }

    public void setSelection(IStructuredSelection structuredSelection, boolean reveal) {
        super.setSelection(structuredSelection, reveal);
    }

    protected String[] getMarkerTypes() {
        return new String[]{"org.eclipse.core.resources.bookmark"};
    }

    protected DialogMarkerFilter createFiltersDialog() {
        MarkerFilter[] filters = this.getUserFilters();
        BookmarkFilter[] bookmarkFilters = new BookmarkFilter[filters.length];
        System.arraycopy(filters, 0, bookmarkFilters, 0, filters.length);
        return new DialogBookmarkFilter(this.getSite().getShell(), bookmarkFilters);
    }

    protected String getStaticContextId() {
        return "org.eclipse.ui.bookmark_view_context";
    }

    protected MarkerFilter createFilter(String name) {
        return new BookmarkFilter(name);
    }

    protected String getSectionTag() {
        return TAG_DIALOG_SECTION;
    }

    void fillContextMenuAdditions(IMenuManager manager) {
    }

    String getMarkerEnablementPreferenceName() {
        return "LIMIT_BOOKMARKS";
    }

    String getMarkerLimitPreferenceName() {
        return "BOOKMARKS_LIMIT";
    }

    String getFiltersPreferenceName() {
        return "BOOKMARKS_FILTERS";
    }
}

