/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ActivityManagerEvent;
import org.eclipse.ui.activities.IActivityManagerListener;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.markers.internal.ActionProblemProperties;
import org.eclipse.ui.views.markers.internal.ActionResolveMarker;
import org.eclipse.ui.views.markers.internal.CategorySorter;
import org.eclipse.ui.views.markers.internal.DialogMarkerFilter;
import org.eclipse.ui.views.markers.internal.DialogProblemFilter;
import org.eclipse.ui.views.markers.internal.FieldCategory;
import org.eclipse.ui.views.markers.internal.FieldCreationTime;
import org.eclipse.ui.views.markers.internal.FieldFolder;
import org.eclipse.ui.views.markers.internal.FieldId;
import org.eclipse.ui.views.markers.internal.FieldLineNumber;
import org.eclipse.ui.views.markers.internal.FieldMarkerGroup;
import org.eclipse.ui.views.markers.internal.FieldMessage;
import org.eclipse.ui.views.markers.internal.FieldResource;
import org.eclipse.ui.views.markers.internal.FieldSeverity;
import org.eclipse.ui.views.markers.internal.IField;
import org.eclipse.ui.views.markers.internal.MarkerFilter;
import org.eclipse.ui.views.markers.internal.MarkerList;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerNode;
import org.eclipse.ui.views.markers.internal.MarkerSupportRegistry;
import org.eclipse.ui.views.markers.internal.MarkerView;
import org.eclipse.ui.views.markers.internal.ProblemFilter;
import org.eclipse.ui.views.markers.internal.TableSorter;
import org.eclipse.ui.views.markers.internal.Util;

public class ProblemView
extends MarkerView {
    private static final String[] ROOT_TYPES = new String[]{"org.eclipse.core.resources.problemmarker"};
    private static final String TAG_DIALOG_SECTION = "org.eclipse.ui.views.problem";
    private ActionResolveMarker resolveMarkerAction;
    private IActivityManagerListener activityManagerListener;
    private IField severity = new FieldSeverity();
    private IField folder = new FieldFolder();
    private IField resource = new FieldResource();
    private IField message = new FieldMessage();
    private IField lineNumber = new FieldLineNumber();
    private IField creationTime = new FieldCreationTime();
    private static IField id = new FieldId();

    public ProblemView() {
        this.creationTime.setShowing(false);
    }

    public void dispose() {
        if (this.resolveMarkerAction != null) {
            this.resolveMarkerAction.dispose();
        }
        PlatformUI.getWorkbench().getActivitySupport().getActivityManager().removeActivityManagerListener(this.activityManagerListener);
        super.dispose();
    }

    protected IField[] getSortingFields() {
        return new IField[]{this.severity, this.folder, this.resource, this.message, this.lineNumber, this.creationTime, id};
    }

    protected IDialogSettings getDialogSettings() {
        AbstractUIPlugin plugin = (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
        IDialogSettings workbenchSettings = plugin.getDialogSettings();
        IDialogSettings settings = workbenchSettings.getSection(TAG_DIALOG_SECTION);
        if (settings == null) {
            settings = workbenchSettings.addNewSection(TAG_DIALOG_SECTION);
        }
        return settings;
    }

    protected void createActions() {
        super.createActions();
        this.propertiesAction = new ActionProblemProperties((IWorkbenchPart)this, (ISelectionProvider)this.getViewer());
        this.resolveMarkerAction = new ActionResolveMarker(this, (ISelectionProvider)this.getViewer());
    }

    protected void fillContextMenuAdditions(IMenuManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.resolveMarkerAction);
    }

    protected String[] getRootTypes() {
        return ROOT_TYPES;
    }

    protected IField[] getAllFields() {
        return new IField[]{this.message, this.resource, this.folder, this.lineNumber, this.creationTime};
    }

    void updateTitle() {
        int totalCount;
        MarkerList visibleMarkers = this.getVisibleMarkers();
        String breakdown = this.formatSummaryBreakDown(visibleMarkers);
        int filteredCount = visibleMarkers.getItemCount();
        if (filteredCount != (totalCount = this.getTotalMarkers())) {
            breakdown = NLS.bind((String)MarkerMessages.problem_filter_matchedMessage, (Object[])new Object[]{breakdown, new Integer(filteredCount), new Integer(totalCount)});
        }
        this.setContentDescription(breakdown);
    }

    private String formatSummaryBreakDown(MarkerList visibleMarkers) {
        return MessageFormat.format(MarkerMessages.problem_statusSummaryBreakdown, new Integer(visibleMarkers.getErrors()), new Integer(visibleMarkers.getWarnings()), new Integer(visibleMarkers.getInfos()));
    }

    private String getSummary(MarkerList markers, String messageKey) {
        String message = NLS.bind((String)messageKey, (Object[])new Object[]{new Integer(markers.getItemCount()), this.formatSummaryBreakDown(markers)});
        return message;
    }

    protected String updateSummarySelected(IStructuredSelection selection) {
        ArrayList<MarkerNode> selectionList = new ArrayList<MarkerNode>();
        Iterator selectionIterator = selection.iterator();
        while (selectionIterator.hasNext()) {
            MarkerNode next = (MarkerNode)selectionIterator.next();
            if (!next.isConcrete()) continue;
            selectionList.add(next);
        }
        return this.getSummary(new MarkerList(selectionList), "problem.statusSummarySelected");
    }

    protected String[] getMarkerTypes() {
        return new String[]{"org.eclipse.core.resources.problemmarker"};
    }

    protected String getStaticContextId() {
        return "org.eclipse.ui.problem_view_context";
    }

    protected DialogMarkerFilter createFiltersDialog() {
        MarkerFilter[] filters = this.getUserFilters();
        ProblemFilter[] problemFilters = new ProblemFilter[filters.length];
        System.arraycopy(filters, 0, problemFilters, 0, filters.length);
        return new DialogProblemFilter(this.getSite().getShell(), problemFilters);
    }

    protected MarkerFilter createFilter(String name) {
        return new ProblemFilter(name);
    }

    protected String getSectionTag() {
        return TAG_DIALOG_SECTION;
    }

    String getMarkerEnablementPreferenceName() {
        return "LIMIT_PROBLEMS";
    }

    String getMarkerLimitPreferenceName() {
        return "PROBLEMS_LIMIT";
    }

    String getFiltersPreferenceName() {
        return "PROBLEMS_FILTERS";
    }

    MarkerFilter[] getAllFilters() {
        MarkerFilter[] userFilters = super.getAllFilters();
        Collection declaredFilters = MarkerSupportRegistry.getInstance().getRegisteredFilters();
        Iterator iterator = declaredFilters.iterator();
        MarkerFilter[] allFilters = new MarkerFilter[userFilters.length + declaredFilters.size()];
        System.arraycopy(userFilters, 0, allFilters, 0, userFilters.length);
        int index = userFilters.length;
        while (iterator.hasNext()) {
            allFilters[index] = (MarkerFilter)iterator.next();
            ++index;
        }
        return allFilters;
    }

    void addDropDownContributions(IMenuManager menu) {
        MenuManager groupByMenu = new MenuManager(MarkerMessages.ProblemView_GroupByMenu);
        groupByMenu.add((IAction)new GroupingAction(MarkerMessages.ProblemView_Type, new FieldCategory(), this));
        Iterator definedGroups = MarkerSupportRegistry.getInstance().getMarkerGroups().iterator();
        while (definedGroups.hasNext()) {
            FieldMarkerGroup group = (FieldMarkerGroup)definedGroups.next();
            groupByMenu.add((IAction)new GroupingAction(group.getDescription(), group, this));
        }
        groupByMenu.add((IAction)new GroupingAction(MarkerMessages.ProblemView_None, null, this));
        menu.add((IContributionItem)groupByMenu);
        super.addDropDownContributions(menu);
    }

    protected void regenerateLayout() {
        TableLayout layout = new TableLayout();
        this.getViewer().getTree().setLayout((Layout)layout);
        ColumnPixelData[] columnWidths = this.getDefaultColumnLayouts();
        int i = 0;
        while (i < columnWidths.length) {
            layout.addColumnData((ColumnLayoutData)columnWidths[i]);
            ++i;
        }
        this.getViewer().getTree().layout(true);
    }

    void setSorter(TableSorter sorter2) {
        this.getMarkerAdapter().getCategorySorter().setTableSorter(sorter2);
        this.getMarkerAdapter().getCategorySorter().saveState(this.getDialogSettings());
        this.refreshViewer();
    }

    public TableSorter getTableSorter() {
        return ((CategorySorter)this.getViewer().getSorter()).innerSorter;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.createActivityManagerListener();
        PlatformUI.getWorkbench().getActivitySupport().getActivityManager().addActivityManagerListener(this.activityManagerListener);
    }

    private void createActivityManagerListener() {
        this.activityManagerListener = new IActivityManagerListener(){

            public void activityManagerChanged(ActivityManagerEvent activityManagerEvent) {
                ProblemView.this.clearEnabledFilters();
                ProblemView.this.getViewer().refresh();
            }
        };
    }

    public IField findField(String description) {
        IField[] fields = this.getSortingFields();
        int i = 0;
        while (i < fields.length) {
            if (fields[i].getDescription().equals(description)) {
                return fields[i];
            }
            ++i;
        }
        return null;
    }

    protected ViewerSorter buildSorter() {
        TableSorter sorter = TableSorter.createTableSorter(this.getSortingFields());
        sorter.restoreState(this.getDialogSettings());
        CategorySorter category = new CategorySorter(sorter);
        category.restoreState(this.getDialogSettings(), this);
        return category;
    }

    boolean canBeEditable() {
        return false;
    }

    private class GroupingAction
    extends Action {
        IField groupingField;
        ProblemView problemView;

        public GroupingAction(String label, IField field, ProblemView view) {
            super(label, 8);
            this.groupingField = field;
            this.problemView = view;
            IField categoryField = view.getMarkerAdapter().getCategorySorter().getCategoryField();
            if (categoryField == null) {
                this.setChecked(this.groupingField == null);
            } else {
                this.setChecked(categoryField.equals(this.groupingField));
            }
        }

        public void run() {
            String description = Util.EMPTY_STRING;
            if (this.groupingField != null) {
                description = this.groupingField.getDescription();
            }
            IDEWorkbenchPlugin.getDefault().getPluginPreferences().setValue("PROBLEMS_GROUPING", description);
            this.problemView.getMarkerAdapter().getCurrentMarkers().clearGroups();
            this.problemView.getMarkerAdapter().getCategorySorter().setCategoryField(this.groupingField);
            this.problemView.refreshViewer();
            ProblemView.this.getMarkerAdapter().getCategorySorter().saveState(ProblemView.this.getDialogSettings());
        }
    }
}

