/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.dnd;

import java.util.ArrayList;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.dnd.CommonDropHandlerService;
import org.eclipse.ui.internal.navigator.dnd.DropHandlerDescriptor;
import org.eclipse.ui.internal.navigator.dnd.IDropValidator;
import org.eclipse.ui.internal.navigator.dnd.ISerializer;
import org.eclipse.ui.internal.navigator.dnd.LocalSelectionTransfer;
import org.eclipse.ui.internal.navigator.dnd.NavigatorDropSelectionDialog;
import org.eclipse.ui.internal.navigator.dnd.NavigatorSelectionSerializer;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonDropAdapter;
import org.eclipse.ui.part.PluginDropAdapter;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.PluginTransferData;

public class CommonNavigatorDropAdapter
extends PluginDropAdapter
implements ICommonDropAdapter {
    private ISerializer serializer;
    private final CommonViewer commonViewer;

    public CommonNavigatorDropAdapter(CommonViewer aViewer) {
        super((StructuredViewer)aViewer);
        this.commonViewer = aViewer;
    }

    public boolean performDrop(Object data) {
        boolean result = false;
        if (PluginTransfer.getInstance().isSupportedType(this.getCurrentTransfer())) {
            result = super.performDrop(data);
        } else {
            Object target = this.getCurrentTarget();
            Object draggedObject = this.getSelectedObject(this.getCurrentTransfer(), data);
            if (this.getCurrentTarget() == draggedObject) {
                return false;
            }
            IDropValidator dropValidator = null;
            CommonDropHandlerService registry = CommonDropHandlerService.getInstance(this.commonViewer.getNavigatorContentService().getViewerId());
            DropHandlerDescriptor[] descriptors = registry.getDropHandlersEnabledFor(draggedObject, target);
            ArrayList<DropHandlerDescriptor> validatedList = new ArrayList<DropHandlerDescriptor>();
            int i = 0;
            while (i < descriptors.length) {
                dropValidator = registry.getDropValidator(this.commonViewer, descriptors[i]);
                if (dropValidator == null || dropValidator.validateDrop(this, this.getCurrentTarget(), this.getCurrentOperation(), this.getCurrentTransfer())) {
                    validatedList.add(descriptors[i]);
                }
                ++i;
            }
            boolean skipOnSingle = NavigatorPlugin.getDefault().getDialogSettings().getBoolean("NavigatorDropSelectionDialog.SKIP_ON_SINGLE_SELECTION");
            if (validatedList.size() > 0) {
                DropHandlerDescriptor[] validatedDescriptors = new DropHandlerDescriptor[validatedList.size()];
                validatedList.toArray(validatedDescriptors);
                DropHandlerDescriptor descriptorToUse = validatedDescriptors[0];
                if (validatedDescriptors.length != 1 || !skipOnSingle) {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    NavigatorDropSelectionDialog dialog = new NavigatorDropSelectionDialog(shell, validatedDescriptors);
                    descriptorToUse = dialog.open() == 0 ? dialog.getSelectedDescriptor() : null;
                }
                if (descriptorToUse != null) {
                    result |= registry.getDropActionDelegate(this.commonViewer, descriptorToUse).run(this, data, target);
                }
            }
        }
        return result;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        if (super.validateDrop(target, operation, transferType)) {
            return true;
        }
        Object source = this.getSelectedObject(transferType);
        if (source == target) {
            return false;
        }
        IDropValidator dropValidator = null;
        CommonDropHandlerService registry = CommonDropHandlerService.getInstance(this.commonViewer.getNavigatorContentService().getViewerId());
        DropHandlerDescriptor[] descriptors = registry.getDropHandlersEnabledFor(source, target);
        boolean result = false;
        int i = 0;
        while (i < descriptors.length) {
            try {
                dropValidator = registry.getDropValidator(this.commonViewer, descriptors[i]);
                if (dropValidator == null || dropValidator.validateDrop(this, target, operation, transferType)) {
                    result = true;
                    break;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            ++i;
        }
        return result;
    }

    public Object getSelectedObject(TransferData transferType) {
        IStructuredSelection selection = null;
        if (LocalSelectionTransfer.getInstance().isSupportedType(transferType)) {
            selection = (IStructuredSelection)LocalSelectionTransfer.getInstance().nativeToJava(transferType);
        }
        if (selection != null) {
            return selection.getFirstElement();
        }
        return null;
    }

    public Object getSelectedObject(TransferData transferType, Object data) {
        IStructuredSelection selection = null;
        if (LocalSelectionTransfer.getInstance().isSupportedType(transferType)) {
            selection = (IStructuredSelection)LocalSelectionTransfer.getInstance().nativeToJava(transferType);
        }
        if (selection != null) {
            return selection.getFirstElement();
        }
        return null;
    }

    public void dragEnter(DropTargetEvent event) {
        super.dragEnter(event);
        int i = 0;
        while (i < event.dataTypes.length) {
            if (LocalSelectionTransfer.getInstance().isSupportedType(event.dataTypes[i])) {
                event.data = LocalSelectionTransfer.getInstance().getSelection();
                break;
            }
            if (PluginTransfer.getInstance().isSupportedType(event.dataTypes[i])) {
                IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getInstance().getSelection();
                byte[] data = this.getSerializer().toByteArray(selection);
                event.data = new PluginTransferData("org.eclipse.ui.navigator.PluginDropAction", data);
                break;
            }
            if (FileTransfer.getInstance().isSupportedType(event.dataTypes[i])) {
                event.data = FileTransfer.getInstance().nativeToJava(event.dataTypes[i]);
                event.detail = 1;
                break;
            }
            ++i;
        }
    }

    public void dragLeave(DropTargetEvent event) {
        super.dragLeave(event);
        if (LocalSelectionTransfer.getInstance().isSupportedType(event.currentDataType)) {
            IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getInstance().getSelection();
            byte[] data = this.getSerializer().toByteArray(selection);
            event.data = new PluginTransferData("org.eclipse.ui.navigator.GenericDropAction", data);
        }
    }

    public int getCurrentLocation() {
        return super.getCurrentLocation();
    }

    public int getCurrentOperation() {
        return super.getCurrentOperation();
    }

    public Object getCurrentTarget() {
        return super.getCurrentTarget();
    }

    public TransferData getCurrentTransfer() {
        return super.getCurrentTransfer();
    }

    public Object getSelectedObject() {
        return super.getSelectedObject();
    }

    protected ISerializer getSerializer() {
        if (this.serializer == null) {
            this.serializer = new NavigatorSelectionSerializer(this.commonViewer.getNavigatorContentService().getViewerId());
        }
        return this.serializer;
    }
}

