/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.dnd;

import org.eclipse.core.expressions.ElementHandler;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.util.Assert;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.dnd.IDropValidator;
import org.eclipse.ui.internal.navigator.dnd.SerializerCollectionDescriptor;
import org.eclipse.ui.navigator.ICommonDropActionDelegate;

public class DropHandlerDescriptor {
    private String name;
    private String description;
    private String id = null;
    private IConfigurationElement configurationElement;
    private Expression dragEnablement;
    private Expression dropEnablement;
    private SerializerCollectionDescriptor serializers;
    private IConfigurationElement dropEnablementConfigElement;
    private IDropValidator dropValidator;

    public DropHandlerDescriptor(IConfigurationElement aConfigurationElement) {
        Assert.isLegal((boolean)"dropHandler".equals(aConfigurationElement.getName()));
        this.configurationElement = aConfigurationElement;
        this.init();
    }

    private void init() {
        IConfigurationElement[] serializersChild;
        IConfigurationElement[] dropEnablementChildren;
        this.id = this.configurationElement.getAttribute("id");
        this.name = this.configurationElement.getAttribute("name");
        this.description = this.configurationElement.getAttribute("description");
        IConfigurationElement[] dragEnablementChildren = this.configurationElement.getChildren("dragEnablement");
        if (dragEnablementChildren.length > 0 && dragEnablementChildren[0] != null) {
            try {
                this.dragEnablement = ElementHandler.getDefault().create(ExpressionConverter.getDefault(), dragEnablementChildren[0]);
            }
            catch (CoreException e) {
                NavigatorPlugin.log(4, 0, e.getMessage(), e);
            }
        }
        if ((dropEnablementChildren = this.configurationElement.getChildren("dropEnablement")).length > 0 && dropEnablementChildren[0] != null) {
            this.dropEnablementConfigElement = dropEnablementChildren[0];
            try {
                this.dropEnablement = ElementHandler.getDefault().create(ExpressionConverter.getDefault(), dropEnablementChildren[0]);
            }
            catch (CoreException e) {
                NavigatorPlugin.log(4, 0, e.getMessage(), e);
            }
        }
        if ((serializersChild = this.configurationElement.getChildren("serializers")).length > 0 && serializersChild[0] != null) {
            this.serializers = new SerializerCollectionDescriptor(this.id, serializersChild[0], this.dragEnablement);
        }
    }

    public boolean isDragEnabledFor(Object anElement) {
        if (this.dragEnablement == null || anElement == null) {
            return false;
        }
        try {
            return this.dragEnablement.evaluate((IEvaluationContext)new EvaluationContext(null, anElement)) == EvaluationResult.TRUE;
        }
        catch (CoreException e) {
            NavigatorPlugin.log(4, 0, e.getMessage(), e);
            return false;
        }
    }

    public boolean isDropEnabledFor(Object anElement) {
        if (this.dropEnablement == null || anElement == null) {
            return false;
        }
        try {
            return this.dropEnablement.evaluate((IEvaluationContext)new EvaluationContext(null, anElement)) == EvaluationResult.TRUE;
        }
        catch (CoreException e) {
            NavigatorPlugin.log(4, 0, e.getMessage(), e);
            return false;
        }
    }

    protected IDropValidator getDropValidator() {
        if (this.dropValidator == null) {
            try {
                String classValue = this.dropEnablementConfigElement.getAttribute("validatorClass");
                if (classValue != null && classValue.length() > 0) {
                    this.dropValidator = (IDropValidator)this.dropEnablementConfigElement.createExecutableExtension("validatorClass");
                }
            }
            catch (CoreException coreException) {}
        }
        return this.dropValidator;
    }

    public SerializerCollectionDescriptor getSerializersDescriptor() {
        return this.serializers;
    }

    public String getId() {
        return this.id;
    }

    protected ICommonDropActionDelegate createAction() {
        try {
            return (ICommonDropActionDelegate)this.configurationElement.createExecutableExtension("class");
        }
        catch (CoreException e) {
            String msg = NLS.bind((String)CommonNavigatorMessages.DropHandlerDescriptor_10, (Object[])new Object[]{this.getId()});
            NavigatorPlugin.log(msg, e.getStatus());
            return null;
        }
    }

    public String getDescription() {
        return this.description != null ? this.description : "";
    }

    public String getName() {
        return this.name != null ? this.name : this.id;
    }

    public static interface ExtensionPointElements {
        public static final String DROP_HANDLER = "dropHandler";
        public static final String ATT_ID = "id";
        public static final String ATT_CLASS = "class";
        public static final String ATT_VALIDATOR_CLASS = "validatorClass";
        public static final String DRAG_ENABLEMENT = "dragEnablement";
        public static final String DROP_ENABLEMENT = "dropEnablement";
        public static final String SERIALIZERS = "serializers";
        public static final String SERIALIZER = "serializer";
        public static final String NAME = "name";
        public static final String DESCRIPTION = "description";
    }
}

