/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.filters;

import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.NavigatorActivationService;

class ContentDescriptorContentProvider
implements ITreeContentProvider {
    private static final NavigatorActivationService NAVIGATOR_ACTIVATION_SERVICE = NavigatorActivationService.getInstance();
    private static final Object[] NO_CHILDREN = new Object[0];
    private INavigatorContentService contentService;
    private CheckboxTableViewer talbleViewer;

    ContentDescriptorContentProvider() {
    }

    public void inputChanged(Viewer aViewer, Object anOldInput, Object aNewInput) {
        if (aNewInput != null) {
            if (aNewInput instanceof INavigatorContentService) {
                this.contentService = (INavigatorContentService)aNewInput;
            }
            if (aViewer instanceof CheckboxTableViewer) {
                this.talbleViewer = (CheckboxTableViewer)aViewer;
            }
            this.updateCheckState();
        } else {
            this.contentService = null;
            this.talbleViewer = null;
        }
    }

    public Object[] getChildren(Object aParentElement) {
        return NO_CHILDREN;
    }

    public Object getParent(Object anElement) {
        return null;
    }

    public boolean hasChildren(Object anElement) {
        return this.getChildren(anElement).length != 0;
    }

    public Object[] getElements(Object anInputElement) {
        return this.contentService != null ? this.contentService.getVisibleExtensions() : NO_CHILDREN;
    }

    public void dispose() {
    }

    private void updateCheckState() {
        if (this.talbleViewer == null || this.contentService == null) {
            return;
        }
        TableItem[] descriptorTableItems = this.talbleViewer.getTable().getItems();
        int i = 0;
        while (i < descriptorTableItems.length) {
            if (descriptorTableItems[i].getData() instanceof INavigatorContentDescriptor) {
                INavigatorContentDescriptor descriptor = (INavigatorContentDescriptor)descriptorTableItems[i].getData();
                boolean enabled = NAVIGATOR_ACTIVATION_SERVICE.isNavigatorExtensionActive(this.contentService.getViewerId(), descriptor.getId());
                this.talbleViewer.setChecked((Object)descriptor, enabled);
            }
            ++i;
        }
    }
}

