/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.navigator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.navigator.DelegateTreeViewerSorter;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.dnd.CommonNavigatorDragAdapter;
import org.eclipse.ui.internal.navigator.dnd.CommonNavigatorDropAdapter;
import org.eclipse.ui.navigator.CommonViewerSorter;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.TreeViewerSorter;
import org.eclipse.ui.part.PluginTransfer;

public class CommonViewer
extends TreeViewer {
    private final NavigatorContentService contentService;

    protected void init() {
        this.setUseHashlookup(true);
        this.setContentProvider((IContentProvider)this.contentService.createCommonContentProvider());
        DecoratingLabelProvider decoratingProvider = new DecoratingLabelProvider(this.contentService.createCommonLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
        this.setLabelProvider((IBaseLabelProvider)decoratingProvider);
        this.initDragAndDrop();
    }

    protected void removeWithoutRefresh(Object[] elements) {
        super.remove(elements);
    }

    protected Object[] getSortedChildren(Object parent) {
        Object[] result = this.getFilteredChildren(parent);
        ViewerSorter sorter = this.getSorter();
        if (sorter != null) {
            result = (Object[])result.clone();
            ((TreeViewerSorter)sorter).sort((Viewer)this, parent, result);
        }
        return result;
    }

    protected void internalAdd(Widget widget, Object parentElement, Object[] childElements) {
        Item ti;
        if (widget instanceof Item && !this.getExpanded(ti = (Item)widget)) {
            boolean needDummy = this.isExpandable(parentElement);
            boolean haveDummy = false;
            Item[] items = this.getItems(ti);
            int i = 0;
            while (i < items.length) {
                if (items[i].getData() != null) {
                    this.disassociate(items[i]);
                    items[i].dispose();
                } else if (needDummy && !haveDummy) {
                    haveDummy = true;
                } else {
                    items[i].dispose();
                }
                ++i;
            }
            if (needDummy && !haveDummy) {
                this.newItem((Widget)ti, 0, -1);
            }
            return;
        }
        if (childElements.length > 0) {
            Object[] filtered = this.filter(childElements);
            if (this.getSorter() != null) {
                ((TreeViewerSorter)this.getSorter()).sort((Viewer)this, parentElement, filtered);
            }
            this.createAddedElements(widget, parentElement, filtered);
        }
    }

    private boolean itemExists(Item[] items, Object element) {
        if (this.usingElementMap()) {
            return this.findItem(element) != null;
        }
        int i = 0;
        while (i < items.length) {
            if (items[i].getData().equals(element)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private void createAddedElements(Widget widget, Object parent, Object[] elements) {
        if (elements.length == 1 && this.equals(elements[0], widget.getData())) {
            return;
        }
        sorter = (TreeViewerSorter)this.getSorter();
        items = this.getChildren(widget);
        lastInsertion = 0;
        if (items.length == 0) {
            i = 0;
            while (i < elements.length) {
                this.createTreeItem(widget, elements[i], -1);
                ++i;
            }
            return;
        }
        i = 0;
        while (i < elements.length) {
            block9: {
                block8: {
                    newItem = true;
                    element = elements[i];
                    if (this.getSorter() != null) break block8;
                    if (this.itemExists(items, element)) {
                        this.refresh(element);
                        newItem = false;
                    }
                    index = -1;
                    break block9;
                }
                if ((lastInsertion = this.insertionPosition(items, lastInsertion, sorter, parent, element)) != items.length) ** GOTO lbl31
                index = -1;
                break block9;
lbl-1000:
                // 1 sources

                {
                    if (items[lastInsertion].getData().equals(element)) {
                        this.refresh(element);
                        newItem = false;
                    }
                    ++lastInsertion;
lbl31:
                    // 2 sources

                    ** while (lastInsertion < items.length && sorter.compare((Viewer)this, (Object)parent, (Object)element, (Object)items[lastInsertion].getData()) == 0)
                }
lbl32:
                // 1 sources

                index = lastInsertion == items.length ? -1 : lastInsertion + i;
            }
            if (newItem) {
                this.createTreeItem(widget, element, index);
            }
            ++i;
        }
    }

    private int insertionPosition(Item[] items, int lastInsertion, TreeViewerSorter sorter, Object parent, Object element) {
        int size = items.length;
        if (this.getSorter() == null) {
            return size;
        }
        int min = lastInsertion;
        int max = size - 1;
        while (min <= max) {
            int mid = (min + max) / 2;
            Object data = items[mid].getData();
            int compare = sorter.compare((Viewer)this, parent, data, element);
            if (compare == 0) {
                return mid;
            }
            if (compare < 0) {
                min = mid + 1;
                continue;
            }
            max = mid - 1;
        }
        return min;
    }

    protected void initDragAndDrop() {
        int operations = 3;
        Transfer[] transfers = new Transfer[]{PluginTransfer.getInstance(), FileTransfer.getInstance()};
        this.addDragSupport(operations, transfers, (DragSourceListener)new CommonNavigatorDragAdapter(this));
        this.addDropSupport(operations, transfers, (DropTargetListener)new CommonNavigatorDropAdapter(this));
    }

    protected void createTreeItem(Widget parent, Object element, int index) {
        try {
            super.createTreeItem(parent, element, index);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        catch (Error e) {
            e.printStackTrace();
        }
    }

    protected void handleLabelProviderChanged(LabelProviderChangedEvent event) {
        Object[] changed = event.getElements();
        if (changed != null) {
            ArrayList<Object> others = new ArrayList<Object>();
            int i = 0;
            while (i < changed.length) {
                Object curr = changed[i];
                others.add(curr);
                ++i;
            }
            if (others.isEmpty()) {
                return;
            }
            event = new LabelProviderChangedEvent((IBaseLabelProvider)event.getSource(), others.toArray());
        }
        super.handleLabelProviderChanged(event);
    }

    protected void handleDispose(DisposeEvent event) {
        super.handleDispose(event);
        this.dispose();
    }

    protected void setSelectionToWidget(List v, boolean reveal) {
        if (v == null) {
            this.setSelection(new ArrayList(0));
            return;
        }
        int size = v.size();
        ArrayList<Widget> newSelection = new ArrayList<Widget>(size);
        int i = 0;
        while (i < size) {
            Widget w = this.internalExpand(v.get(i), reveal);
            if (w instanceof Item) {
                newSelection.add(w);
            }
            ++i;
        }
        this.setSelection(newSelection);
    }

    public CommonViewer(String aViewerId, Composite aParent, int aStyle) {
        super(aParent, aStyle);
        this.contentService = new NavigatorContentService(aViewerId, (StructuredViewer)this);
        this.init();
    }

    public boolean isExpandable(Object element) {
        return this.getFilteredChildren(element).length != 0;
    }

    public void dispose() {
        if (this.contentService != null) {
            this.contentService.dispose();
        }
    }

    public void setSorter(ViewerSorter sorter) {
        if (sorter != null && sorter instanceof CommonViewerSorter) {
            ((CommonViewerSorter)sorter).setContentService(this.contentService);
        }
        if (sorter == null || sorter instanceof TreeViewerSorter) {
            super.setSorter(sorter);
        } else {
            super.setSorter((ViewerSorter)new DelegateTreeViewerSorter(sorter));
        }
    }

    public INavigatorContentService getNavigatorContentService() {
        return this.contentService;
    }

    public void add(Object parentElement, Object[] childElements) {
        super.add(parentElement, childElements);
    }

    public void remove(Object[] elements) {
        super.remove(elements);
        ITreeContentProvider contentProvider = (ITreeContentProvider)this.getContentProvider();
        int i = 0;
        while (i < elements.length) {
            super.internalRefresh(contentProvider.getParent(elements[i]));
            ++i;
        }
    }

    public void refresh(boolean updateLabels) {
        super.refresh(updateLabels);
    }

    public void refresh(Object element, boolean updateLabels) {
        super.refresh(element, updateLabels);
    }

    public void refresh(Object element) {
        super.refresh(element);
    }

    public void update(Object element, String[] properties) {
        super.update(element, properties);
    }

    public String toString() {
        return this.contentService.getViewerId();
    }
}

