/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.navigator;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorSorterService;
import org.eclipse.ui.navigator.TreeViewerSorter;

public final class CommonViewerSorter
extends TreeViewerSorter {
    private NavigatorContentService contentService;
    private INavigatorSorterService sorterService;

    protected void setContentService(NavigatorContentService aContentService) {
        this.contentService = aContentService;
        this.sorterService = this.contentService.getSorterService();
    }

    public int category(Object element) {
        NavigatorContentDescriptor source = this.contentService.getSourceOfContribution(element);
        return source != null ? source.getPriority() : 3;
    }

    public void sort(final Viewer viewer, final Object parent, Object[] elements) {
        Arrays.sort(elements, new Comparator(){

            public int compare(Object a, Object b) {
                return CommonViewerSorter.this.compare(viewer, parent, a, b);
            }
        });
    }

    public int compare(Viewer viewer, Object parent, Object e1, Object e2) {
        ViewerSorter sorter;
        INavigatorContentDescriptor sourceOfLvalue = this.getSource(e1);
        INavigatorContentDescriptor sourceOfRvalue = this.getSource(e2);
        if (sourceOfLvalue != null && sourceOfLvalue == sourceOfRvalue && (sorter = this.sorterService.findSorter(sourceOfLvalue, parent, e1, e2)) != null) {
            return sorter.compare(viewer, e1, e2);
        }
        int categoryDelta = this.category(e1) - this.category(e2);
        if (categoryDelta == 0) {
            super.compare(viewer, e1, e2);
        }
        return categoryDelta;
    }

    private INavigatorContentDescriptor getSource(Object o) {
        Set descriptors = this.contentService.findDescriptorsWithPossibleChild(o);
        if (descriptors != null && descriptors.size() > 0) {
            return (INavigatorContentDescriptor)descriptors.iterator().next();
        }
        return null;
    }
}

