/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.navigator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.actions.CommonActionDescriptorManager;
import org.eclipse.ui.internal.navigator.actions.CommonActionProviderDescriptor;
import org.eclipse.ui.internal.navigator.extensions.InsertionPoint;
import org.eclipse.ui.internal.navigator.extensions.SkeletonActionProvider;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.CommonActionProviderConfig;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.ui.navigator.IMementoAware;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.INavigatorViewerDescriptor;

public final class NavigatorActionService
extends ActionGroup
implements IMementoAware {
    private static final IContributionItem[] DEFAULT_GROUPS = new IContributionItem[]{new Separator("group.new"), new GroupMarker("group.goto"), new Separator("group.open"), new Separator("group.openWith"), new GroupMarker("group.show"), new GroupMarker("group.reorganize"), new GroupMarker("group.port"), new Separator("group.generate"), new Separator("group.search"), new Separator("group.build"), new Separator("additions"), new Separator("group.properties")};
    private final ICommonViewerSite commonViewerSite;
    private final StructuredViewer structuredViewer;
    private final NavigatorContentService contentService;
    private final INavigatorViewerDescriptor viewerDescriptor;
    private final Set actionProviderDescriptors = new HashSet();
    private final Map actionProviderInstances = new HashMap();
    private IMemento memento;
    private IContributionItem[] menuGroups;
    private boolean disposed = false;

    public NavigatorActionService(ICommonViewerSite aCommonViewerSite, StructuredViewer aStructuredViewer, INavigatorContentService aContentService) {
        Assert.isNotNull((Object)aCommonViewerSite);
        Assert.isNotNull((Object)aStructuredViewer);
        Assert.isNotNull((Object)aContentService);
        this.commonViewerSite = aCommonViewerSite;
        this.contentService = (NavigatorContentService)aContentService;
        this.structuredViewer = aStructuredViewer;
        this.viewerDescriptor = this.contentService.getViewerDescriptor();
    }

    public void prepareMenuForPlatformContributions(MenuManager menu, ISelectionProvider aSelectionProvider, boolean force) {
        Assert.isTrue((!this.disposed ? 1 : 0) != 0);
        if (this.commonViewerSite instanceof ICommonViewerWorkbenchSite && (force || this.viewerDescriptor.allowsPlatformContributionsToContextMenu())) {
            ((ICommonViewerWorkbenchSite)this.commonViewerSite).registerContextMenu(this.contentService.getViewerDescriptor().getPopupMenuId(), menu, aSelectionProvider);
        }
    }

    public void fillContextMenu(IMenuManager aMenu) {
        Assert.isTrue((!this.disposed ? 1 : 0) != 0);
        if (this.menuGroups == null) {
            this.createMenuGroups();
        }
        int i = 0;
        while (i < this.menuGroups.length) {
            aMenu.add(this.menuGroups[i]);
            ++i;
        }
        this.addCommonActionProviderMenu(aMenu);
    }

    private void createMenuGroups() {
        InsertionPoint[] customPoints = this.viewerDescriptor.getCustomInsertionPoints();
        if (customPoints == null) {
            this.menuGroups = DEFAULT_GROUPS;
        } else {
            this.menuGroups = new IContributionItem[customPoints.length];
            int i = 0;
            while (i < customPoints.length) {
                this.menuGroups[i] = customPoints[i].isSeparator() ? new Separator(customPoints[i].getName()) : new GroupMarker(customPoints[i].getName());
                ++i;
            }
        }
    }

    private void addCommonActionProviderMenu(IMenuManager aMenu) {
        CommonActionProviderDescriptor[] providerDescriptors = CommonActionDescriptorManager.getInstance().findRelevantActionDescriptors(this.contentService, this.getContext());
        if (providerDescriptors.length > 0) {
            CommonActionProvider provider = null;
            int i = 0;
            while (i < providerDescriptors.length) {
                try {
                    provider = this.getActionProviderInstance(providerDescriptors[i]);
                    provider.setContext(this.getContext());
                    provider.fillContextMenu(aMenu);
                }
                catch (Throwable t) {
                    NavigatorPlugin.logError(0, t.getMessage(), t);
                }
                ++i;
            }
        }
    }

    public void fillActionBars(IActionBars theActionBars) {
        Assert.isTrue((!this.disposed ? 1 : 0) != 0);
        theActionBars.clearGlobalActionHandlers();
        CommonActionProviderDescriptor[] providerDescriptors = CommonActionDescriptorManager.getInstance().findRelevantActionDescriptors(this.contentService, this.getContext());
        if (providerDescriptors.length > 0) {
            CommonActionProvider provider = null;
            int i = 0;
            while (i < providerDescriptors.length) {
                try {
                    provider = this.getActionProviderInstance(providerDescriptors[i]);
                    provider.setContext(this.getContext());
                    provider.fillActionBars(theActionBars);
                }
                catch (RuntimeException e) {
                    NavigatorPlugin.logError(0, e.getMessage(), e);
                }
                ++i;
            }
        }
        theActionBars.updateActionBars();
        theActionBars.getMenuManager().update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map map = this.actionProviderInstances;
        synchronized (map) {
            Iterator iter = this.actionProviderInstances.values().iterator();
            while (iter.hasNext()) {
                CommonActionProvider element = (CommonActionProvider)iter.next();
                element.dispose();
            }
            this.actionProviderInstances.clear();
        }
        this.actionProviderDescriptors.clear();
        this.disposed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreState(IMemento aMemento) {
        Assert.isTrue((!this.disposed ? 1 : 0) != 0);
        this.memento = aMemento;
        Map map = this.actionProviderInstances;
        synchronized (map) {
            Iterator actionProviderIterator = this.actionProviderInstances.values().iterator();
            while (actionProviderIterator.hasNext()) {
                final CommonActionProvider provider = (CommonActionProvider)actionProviderIterator.next();
                ISafeRunnable runnable = new ISafeRunnable(){

                    public void run() throws Exception {
                        provider.restoreState(NavigatorActionService.this.memento);
                    }

                    public void handleException(Throwable exception) {
                        NavigatorPlugin.logError(0, "Could not restore state for action provider " + provider.getClass(), exception);
                    }
                };
                Platform.run((ISafeRunnable)runnable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveState(IMemento aMemento) {
        Assert.isTrue((!this.disposed ? 1 : 0) != 0);
        this.memento = aMemento;
        CommonActionProvider provider = null;
        Map map = this.actionProviderInstances;
        synchronized (map) {
            Iterator actionProviderIterator = this.actionProviderInstances.values().iterator();
            while (actionProviderIterator.hasNext()) {
                provider = (CommonActionProvider)actionProviderIterator.next();
                provider.saveState(this.memento);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommonActionProvider getActionProviderInstance(CommonActionProviderDescriptor aProviderDescriptor) {
        CommonActionProvider provider = (CommonActionProvider)this.actionProviderInstances.get(aProviderDescriptor);
        if (provider != null) {
            return provider;
        }
        Map map = this.actionProviderInstances;
        synchronized (map) {
            provider = (CommonActionProvider)this.actionProviderInstances.get(aProviderDescriptor);
            if (provider == null) {
                provider = aProviderDescriptor.createActionProvider();
                if (provider != null) {
                    this.initialize(aProviderDescriptor.getId(), provider);
                    this.actionProviderInstances.put(aProviderDescriptor, provider);
                } else {
                    provider = SkeletonActionProvider.INSTANCE;
                    this.actionProviderInstances.put(aProviderDescriptor, provider);
                }
            }
        }
        return provider;
    }

    private void initialize(String id, CommonActionProvider anActionProvider) {
        if (anActionProvider != null && anActionProvider != SkeletonActionProvider.INSTANCE) {
            CommonActionProviderConfig configuration = new CommonActionProviderConfig(id, this.commonViewerSite, this.contentService, this.structuredViewer);
            anActionProvider.init(configuration);
            anActionProvider.restoreState(this.memento);
            anActionProvider.setContext(new ActionContext((ISelection)StructuredSelection.EMPTY));
            if (this.commonViewerSite instanceof ICommonViewerWorkbenchSite) {
                anActionProvider.fillActionBars(((ICommonViewerWorkbenchSite)this.commonViewerSite).getActionBars());
            }
        }
    }
}

