/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.navigator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptor;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptorManager;
import org.eclipse.ui.navigator.IExtensionActivationListener;

public final class NavigatorActivationService {
    private static final String ACTIVATED_EXTENSIONS = ".activatedExtensions";
    private static final String EXTENSION_ACTIVATED_SUFFIX = ".extensionActivated";
    private static final NavigatorActivationService INSTANCE = new NavigatorActivationService();
    private static final NavigatorContentDescriptorManager CONTENT_DESCRIPTOR_REGISTRY = NavigatorContentDescriptorManager.getInstance();
    private final Map activatedExtensionsMap = new HashMap();
    private final Map contentServiceListenersMap = new HashMap();

    private NavigatorActivationService() {
    }

    public static NavigatorActivationService getInstance() {
        return INSTANCE;
    }

    public boolean isNavigatorExtensionActive(String aViewerId, String aNavigatorExtensionId) {
        return this.getActiveExtensions(aViewerId, true).contains(this.getExtensionActivationPreferenceKey(aNavigatorExtensionId));
    }

    public void activateNavigatorExtension(String aViewerId, String aNavigatorExtensionId, boolean toEnable) {
        boolean currentlyActive = this.isNavigatorExtensionActive(aViewerId, aNavigatorExtensionId);
        if (currentlyActive == toEnable) {
            return;
        }
        Set activatedExtensions = this.getActiveExtensions(aViewerId, true);
        if (toEnable) {
            activatedExtensions.add(this.getExtensionActivationPreferenceKey(aNavigatorExtensionId));
        } else {
            activatedExtensions.remove(this.getExtensionActivationPreferenceKey(aNavigatorExtensionId));
        }
        this.notifyListeners(aViewerId, new String[]{aNavigatorExtensionId}, toEnable);
    }

    public void activateNavigatorExtension(String aViewerId, String[] aNavigatorExtensionIds, boolean toEnable) {
        Set activatedExtensions = this.getActiveExtensions(aViewerId, true);
        if (toEnable) {
            int i = 0;
            while (i < aNavigatorExtensionIds.length) {
                activatedExtensions.add(this.getExtensionActivationPreferenceKey(aNavigatorExtensionIds[i]));
                ++i;
            }
        } else {
            int i = 0;
            while (i < aNavigatorExtensionIds.length) {
                activatedExtensions.remove(this.getExtensionActivationPreferenceKey(aNavigatorExtensionIds[i]));
                ++i;
            }
        }
        this.notifyListeners(aViewerId, aNavigatorExtensionIds, toEnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistExtensionActivations(String aViewerId) {
        Set activatedExtensions = this.getActiveExtensions(aViewerId, false);
        if (activatedExtensions == null) {
            return;
        }
        Preferences preferences = NavigatorPlugin.getDefault().getPluginPreferences();
        Set set = activatedExtensions;
        synchronized (set) {
            Iterator activatedExtensionsIterator = activatedExtensions.iterator();
            StringBuffer activatedExtensionsStringBuffer = new StringBuffer(";");
            while (activatedExtensionsIterator.hasNext()) {
                activatedExtensionsStringBuffer.append(activatedExtensionsIterator.next()).append(";");
            }
            preferences.setValue(this.getPreferenceKey(aViewerId), activatedExtensionsStringBuffer.toString());
        }
        NavigatorPlugin.getDefault().savePluginPreferences();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExtensionActivationListener(String aViewerId, IExtensionActivationListener aListener) {
        Map map = this.contentServiceListenersMap;
        synchronized (map) {
            ListenerList listeners = this.getExtensionActivationListeners(aViewerId, true);
            listeners.add((Object)aListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExtensionActivationListener(String aViewerId, IExtensionActivationListener aListener) {
        Map map = this.contentServiceListenersMap;
        synchronized (map) {
            ListenerList listeners = this.getExtensionActivationListeners(aViewerId, true);
            listeners.remove((Object)aListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(String aViewerId, String[] navigatorExtensionIds, boolean toEnable) {
        Map map = this.contentServiceListenersMap;
        synchronized (map) {
            ListenerList listeners = (ListenerList)this.contentServiceListenersMap.get(aViewerId);
            if (listeners != null) {
                Object[] listenerArray = listeners.getListeners();
                int i = 0;
                while (i < listenerArray.length) {
                    ((IExtensionActivationListener)listenerArray[i]).onExtensionActivation(aViewerId, navigatorExtensionIds, toEnable);
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListenerList getExtensionActivationListeners(String aViewerId, boolean initializeIfNecessary) {
        ListenerList listeners = (ListenerList)this.contentServiceListenersMap.get(aViewerId);
        if (listeners != null || !initializeIfNecessary) {
            return listeners;
        }
        Map map = this.contentServiceListenersMap;
        synchronized (map) {
            listeners = (ListenerList)this.contentServiceListenersMap.get(aViewerId);
            if (listeners == null) {
                listeners = new ListenerList();
                this.contentServiceListenersMap.put(aViewerId, listeners);
            }
        }
        return listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getActiveExtensions(String aViewerId, boolean initializeIfNecessary) {
        Set activatedExtensions = (Set)this.activatedExtensionsMap.get(aViewerId);
        if (activatedExtensions != null || !initializeIfNecessary) {
            return activatedExtensions;
        }
        Map map = this.activatedExtensionsMap;
        synchronized (map) {
            activatedExtensions = (Set)this.activatedExtensionsMap.get(aViewerId);
            if (activatedExtensions == null) {
                activatedExtensions = this.revertExtensionActivations(aViewerId);
                this.activatedExtensionsMap.put(aViewerId, activatedExtensions);
            }
        }
        return activatedExtensions;
    }

    private Set revertExtensionActivations(String aViewerId) {
        Preferences preferences = NavigatorPlugin.getDefault().getPluginPreferences();
        HashSet<String> activatedExtensions = new HashSet<String>();
        String activatedExtensionsString = preferences.getString(this.getPreferenceKey(aViewerId));
        if (activatedExtensionsString != null && activatedExtensionsString.length() > 0) {
            String activatedExtensionKey = null;
            StringTokenizer tokenizer = new StringTokenizer(activatedExtensionsString, ";");
            while (tokenizer.hasMoreTokens()) {
                activatedExtensionKey = tokenizer.nextToken();
                if (activatedExtensionKey.length() <= 0) continue;
                activatedExtensions.add(activatedExtensionKey);
            }
        } else {
            NavigatorContentDescriptor[] contentDescriptors = CONTENT_DESCRIPTOR_REGISTRY.getAllContentDescriptors();
            int i = 0;
            while (i < contentDescriptors.length) {
                if (contentDescriptors[i].isActiveByDefault()) {
                    activatedExtensions.add(this.getExtensionActivationPreferenceKey(contentDescriptors[i].getId()));
                }
                ++i;
            }
        }
        return activatedExtensions;
    }

    private String getPreferenceKey(String aViewerId) {
        return String.valueOf(aViewerId) + ACTIVATED_EXTENSIONS;
    }

    private String getExtensionActivationPreferenceKey(String aNavigatorExtensionId) {
        return String.valueOf(aNavigatorExtensionId) + EXTENSION_ACTIVATED_SUFFIX;
    }
}

